/*
 * #%L
 * JMexico :: Model
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2011 - 2012 Réseau Mexico, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package fr.reseaumexico.model;

import fr.reseaumexico.model.event.InputDesignFactorListener;
import fr.reseaumexico.model.event.InputDesignScenarioListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;

public abstract class InputDesign implements Serializable {

    private static final long serialVersionUID = 3486691221034055733L;

    public static final String PROPERTY_DATE = "date";

    public static final String PROPERTY_EXPERIMENT_DESIGN = "experimentDesign";

    public static final String PROPERTY_SCENARIO = "scenario";

    protected Date date;

    protected ExperimentDesign experimentDesign;

    protected Collection<Scenario> scenario;

    protected final PropertyChangeSupport pcs = new PropertyChangeSupport(this);;

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        Date oldValue = getDate();
        this.date = date;
        firePropertyChange(PROPERTY_DATE, oldValue, date);
    }

    public ExperimentDesign getExperimentDesign() {
        return experimentDesign;
    }

    public void setExperimentDesign(ExperimentDesign experimentDesign) {
        ExperimentDesign oldValue = getExperimentDesign();
        this.experimentDesign = experimentDesign;
        firePropertyChange(PROPERTY_EXPERIMENT_DESIGN, oldValue, experimentDesign);
    }

    public Scenario getScenario(int index) {
        Scenario o = getChild(scenario, index);
        return o;
    }

    public void addScenario(Scenario scenario) {
        getScenario().add(scenario);
    
        firePropertyChange(PROPERTY_SCENARIO, null, scenario);
    }

    public void addAllScenario(Collection<Scenario> scenario) {
        getScenario().addAll(scenario);
    
        firePropertyChange(PROPERTY_SCENARIO, null, scenario);
    }

    public boolean removeScenario(Scenario scenario) {
        boolean  removed = getScenario().remove(scenario);
    
        if (removed) {
            firePropertyChange(PROPERTY_SCENARIO, scenario, null);
      }
    
        return removed;
    }

    public boolean removeAllScenario(Collection<Scenario> scenario) {
        boolean  removed = getScenario().removeAll(scenario);
    
        if (removed) {
            firePropertyChange(PROPERTY_SCENARIO, scenario, null);
      }
    
        return removed;
    }

    public boolean containsScenario(Scenario scenario) {
        boolean contains = getScenario().contains(scenario);
    
        return contains;
    }

    public boolean containsAllScenario(Collection<Scenario> scenario) {
        boolean  contains = getScenario().containsAll(scenario);
    
        return contains;
    }

    public Collection<Scenario> getScenario() {
        return scenario;
    }

    public void setScenario(Collection<Scenario> scenario) {
        Collection<Scenario> oldValue = getScenario();
        this.scenario = scenario;
        firePropertyChange(PROPERTY_SCENARIO, oldValue, scenario);
    }

    public abstract void addInputDesignScenarioListener(InputDesignScenarioListener scenarioListener);

    public abstract void removeInputDesignScenarioListener(InputDesignScenarioListener scenarioListener);

    public abstract void addInputDesignFactorListener(InputDesignFactorListener factorListener);

    public abstract void removeInputDesignFactorListener(InputDesignFactorListener factorListener);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected void firePropertyChange(String propertyName, Object newValue) {
        firePropertyChange(propertyName, null, newValue);
    }

    protected <T> T getChild(Collection<T> childs, int index) {
        if (childs != null) {
            int i = 0;
            for (T o : childs) {
                if (index == i) {
                    return o;
                }
                i++;
            }
        }
        return null;
    }

} //InputDesign
