package fr.reseaumexico.model;

import java.util.Collection;
import java.util.Date;

public abstract class ExperimentDesign extends AbstractMexicoBean {

    private static final long serialVersionUID = 7148676296484610658L;

    public static final String PROPERTY_ID = "id";

    public static final String PROPERTY_DATE = "date";

    public static final String PROPERTY_DESCRIPTION = "description";

    public static final String PROPERTY_AUTHOR = "author";

    public static final String PROPERTY_LICENCE = "licence";

    public static final String PROPERTY_FACTOR = "factor";

    protected String id;

    protected Date date;

    protected String description;

    protected String author;

    protected String licence;

    protected Collection<Factor> factor;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        String oldValue = getId();
        this.id = id;
        firePropertyChange(PROPERTY_ID, oldValue, id);
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        Date oldValue = getDate();
        this.date = date;
        firePropertyChange(PROPERTY_DATE, oldValue, date);
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        String oldValue = getDescription();
        this.description = description;
        firePropertyChange(PROPERTY_DESCRIPTION, oldValue, description);
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        String oldValue = getAuthor();
        this.author = author;
        firePropertyChange(PROPERTY_AUTHOR, oldValue, author);
    }

    public String getLicence() {
        return licence;
    }

    public void setLicence(String licence) {
        String oldValue = getLicence();
        this.licence = licence;
        firePropertyChange(PROPERTY_LICENCE, oldValue, licence);
    }

    public Factor getFactor(int index) {
        Factor o = getChild(factor, index);
        return o;
    }

    public boolean isFactorEmpty() {
        return factor == null || factor.isEmpty();
    }

    public int sizeFactor() {
        return factor == null ? 0 : factor.size();
    }

    public void addFactor(Factor factor) {
        getFactor().add(factor);
        firePropertyChange(PROPERTY_FACTOR, null, factor);
    }

    public void addAllFactor(Collection<Factor> factor) {
        getFactor().addAll(factor);
        firePropertyChange(PROPERTY_FACTOR, null, factor);
    }

    public boolean removeFactor(Factor factor) {
        boolean removed = getFactor().remove(factor);
        if (removed) {
            firePropertyChange(PROPERTY_FACTOR, factor, null);
        }
        return removed;
    }

    public boolean removeAllFactor(Collection<Factor> factor) {
        boolean  removed = getFactor().removeAll(factor);
        if (removed) {
            firePropertyChange(PROPERTY_FACTOR, factor, null);
        }
        return removed;
    }

    public boolean containsFactor(Factor factor) {
        boolean contains = getFactor().contains(factor);
        return contains;
    }

    public boolean containsAllFactor(Collection<Factor> factor) {
        boolean  contains = getFactor().containsAll(factor);
        return contains;
    }

    public Collection<Factor> getFactor() {
        return factor;
    }

    public void setFactor(Collection<Factor> factor) {
        Collection<Factor> oldValue = getFactor();
        this.factor = factor;
        firePropertyChange(PROPERTY_FACTOR, oldValue, factor);
    }

} //ExperimentDesign
