/*
 * #%L
 * Refcomp :: services
 * 
 * $Id: RefcompConfigurationHelper.java 151 2011-04-01 13:12:49Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.0/refcomp-services/src/main/java/fr/inra/refcomp/services/RefcompConfigurationHelper.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.services;

import java.io.File;
import java.util.Locale;
import org.nuiton.util.ApplicationConfig;

/**
 * User: couteau
 * Date: 26 nov. 2010
 */
public class RefcompConfigurationHelper {

    /**
     * Get current application version as string.
     *
     * @param config vradi service configuration
     * @return version
     */
    public static String getApplicationVersion(ApplicationConfig config) {
        return config.getOption(RefcompConfiguration.RefcompOption.APPLICATION_VERSION.key);
    }

    public static String getDataDir(ApplicationConfig config) {
        String option = config.getOption(RefcompConfiguration.RefcompOption.DATA_DIR.key);
        return option;
    }

    public static File getDataDirAsFile(ApplicationConfig config) {
        File option = config.getOptionAsFile(RefcompConfiguration.RefcompOption.DATA_DIR.key);
        return option;
    }

    public static Locale getLocale(ApplicationConfig config) {
        Locale result = config.getOption(Locale.class, RefcompConfiguration.RefcompOption.LOCALE.key);
        return result;
    }

    public static void setLocale(ApplicationConfig config, Locale locale) {
        config.setOption(RefcompConfiguration.RefcompOption.LOCALE.key, locale.toString());
    }

    public static String getAdminEmail(ApplicationConfig config){
        String email = config.getOption(RefcompConfiguration.RefcompOption.ADMIN_EMAIL.key);
        return email;
    }

    public static String getAdminLogin(ApplicationConfig config){
        String email = config.getOption(RefcompConfiguration.RefcompOption.ADMIN_LOGIN.key);
        return email;
    }

    public static String getAdminPassword(ApplicationConfig config){
        String email = config.getOption(RefcompConfiguration.RefcompOption.ADMIN_PASSWORD.key);
        return email;
    }
}
