/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.spring;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringObjectFactory
extends ObjectFactory
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(SpringObjectFactory.class);
    protected ApplicationContext appContext;
    protected AutowireCapableBeanFactory autoWiringFactory;
    protected int autowireStrategy = 1;
    private final Map<String, Object> classes = new HashMap<String, Object>();
    private boolean useClassCache = true;
    private boolean alwaysRespectAutowireStrategy = false;

    @Inject(value="applicationContextPath", required=false)
    public void setApplicationContextPath(String ctx) {
        if (ctx != null) {
            this.setApplicationContext((ApplicationContext)new ClassPathXmlApplicationContext(ctx));
        }
    }

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.appContext = appContext;
        this.autoWiringFactory = this.findAutoWiringBeanFactory(this.appContext);
    }

    public void setAutowireStrategy(int autowireStrategy) {
        switch (autowireStrategy) {
            case 4: {
                LOG.info("Setting autowire strategy to autodetect", new String[0]);
                this.autowireStrategy = autowireStrategy;
                break;
            }
            case 1: {
                LOG.info("Setting autowire strategy to name", new String[0]);
                this.autowireStrategy = autowireStrategy;
                break;
            }
            case 2: {
                LOG.info("Setting autowire strategy to type", new String[0]);
                this.autowireStrategy = autowireStrategy;
                break;
            }
            case 3: {
                LOG.info("Setting autowire strategy to constructor", new String[0]);
                this.autowireStrategy = autowireStrategy;
                break;
            }
            case 0: {
                LOG.info("Setting autowire strategy to none", new String[0]);
                this.autowireStrategy = autowireStrategy;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid autowire type set");
            }
        }
    }

    public int getAutowireStrategy() {
        return this.autowireStrategy;
    }

    protected AutowireCapableBeanFactory findAutoWiringBeanFactory(ApplicationContext context) {
        if (context instanceof AutowireCapableBeanFactory) {
            return (AutowireCapableBeanFactory)context;
        }
        if (context instanceof ConfigurableApplicationContext) {
            return ((ConfigurableApplicationContext)context).getBeanFactory();
        }
        if (context.getParent() != null) {
            return this.findAutoWiringBeanFactory(context.getParent());
        }
        return null;
    }

    @Override
    public Object buildBean(String beanName, Map<String, Object> extraContext, boolean injectInternal) throws Exception {
        Object o = null;
        try {
            o = this.appContext.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException e) {
            Class beanClazz = this.getClassInstance(beanName);
            o = this.buildBean(beanClazz, extraContext);
        }
        if (injectInternal) {
            this.injectInternalBeans(o);
        }
        return o;
    }

    @Override
    public Object buildBean(Class clazz, Map<String, Object> extraContext) throws Exception {
        try {
            if (this.alwaysRespectAutowireStrategy) {
                Object bean = this.autoWiringFactory.createBean(clazz, this.autowireStrategy, false);
                this.injectApplicationContext(bean);
                return this.injectInternalBeans(bean);
            }
            Object bean = this.autoWiringFactory.autowire(clazz, 3, false);
            bean = this.autoWiringFactory.applyBeanPostProcessorsBeforeInitialization(bean, bean.getClass().getName());
            bean = this.autoWiringFactory.applyBeanPostProcessorsAfterInitialization(bean, bean.getClass().getName());
            return this.autoWireBean(bean, this.autoWiringFactory);
        }
        catch (UnsatisfiedDependencyException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error building bean", e, new String[0]);
            }
            return this.autoWireBean(super.buildBean(clazz, extraContext), this.autoWiringFactory);
        }
    }

    public Object autoWireBean(Object bean) {
        return this.autoWireBean(bean, this.autoWiringFactory);
    }

    public Object autoWireBean(Object bean, AutowireCapableBeanFactory autoWiringFactory) {
        if (autoWiringFactory != null) {
            autoWiringFactory.autowireBeanProperties(bean, this.autowireStrategy, false);
        }
        this.injectApplicationContext(bean);
        this.injectInternalBeans(bean);
        return bean;
    }

    private void injectApplicationContext(Object bean) {
        if (bean instanceof ApplicationContextAware) {
            ((ApplicationContextAware)bean).setApplicationContext(this.appContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class getClassInstance(String className) throws ClassNotFoundException {
        Map<String, Object> map;
        Class<?> clazz = null;
        if (this.useClassCache) {
            map = this.classes;
            synchronized (map) {
                clazz = (Class)this.classes.get(className);
            }
        }
        if (clazz == null) {
            clazz = this.appContext.containsBean(className) ? this.appContext.getBean(className).getClass() : super.getClassInstance(className);
            if (this.useClassCache) {
                map = this.classes;
                synchronized (map) {
                    this.classes.put(className, clazz);
                }
            }
        }
        return clazz;
    }

    @Deprecated
    public void initObjectFactory() {
    }

    @Override
    public boolean isNoArgConstructorRequired() {
        return false;
    }

    public void setUseClassCache(boolean useClassCache) {
        this.useClassCache = useClassCache;
    }

    public void setAlwaysRespectAutowireStrategy(boolean alwaysRespectAutowireStrategy) {
        this.alwaysRespectAutowireStrategy = alwaysRespectAutowireStrategy;
    }
}

