/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyField;
import org.nuiton.wikitty.entities.WikittyTreeNode;

public class WikittyTreeNodeDTO
implements WikittyTreeNode {
    @WikittyField(fqn="WikittyTreeNode.name")
    protected String name;
    @WikittyField(fqn="WikittyTreeNode.attachment")
    protected Set<String> attachment = new LinkedHashSet<String>();
    @WikittyField(fqn="WikittyTreeNode.parent")
    protected String parent;
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        ++this.modificationCount;
    }

    public Set<String> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Set<String> attachment) {
        this.attachment = attachment == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(attachment);
        ++this.modificationCount;
    }

    public void addAllAttachment(Set<String> attachment) {
        if (this.attachment == null) {
            this.attachment = new LinkedHashSet<String>();
        }
        this.attachment.addAll(attachment);
        ++this.modificationCount;
    }

    public void addAttachment(String element) {
        if (this.attachment == null) {
            this.attachment = new LinkedHashSet<String>();
        }
        this.attachment.add(element);
        ++this.modificationCount;
    }

    public void removeAttachment(String element) {
        this.attachment.remove(element);
        ++this.modificationCount;
    }

    public void clearAttachment() {
        this.attachment.clear();
        ++this.modificationCount;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
        ++this.modificationCount;
    }

    public WikittyTreeNodeDTO() {
    }

    public WikittyTreeNodeDTO(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public String toString() {
        return "dto:" + this.getWikittyId() + ":" + this.getWikittyVersion();
    }

    public String getWikittyId() {
        return this.wikittyId;
    }

    public void setWikittyId(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public String getWikittyVersion() {
        String result = this.wikittyVersion;
        if (this.modificationCount > 0) {
            result = result + "." + this.modificationCount;
        }
        return result;
    }

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion = wikittyVersion;
        this.modificationCount = 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copyFrom(BusinessEntity source) {
        if (!(source instanceof WikittyTreeNode)) {
            throw new WikittyException("Can't copy source object " + source + ". They are not of the same type");
        }
        WikittyTreeNode sourceCopy = (WikittyTreeNode)source;
        this.setName(sourceCopy.getName());
        Set attachment = sourceCopy.getAttachment();
        if (attachment != null) {
            this.setAttachment(new LinkedHashSet<String>(attachment));
        }
        this.setParent(sourceCopy.getParent());
        this.setWikittyVersion(sourceCopy.getWikittyVersion());
    }
}

