/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: AdminCati.java 114 2011-02-16 17:17:55Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.5.1/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/cati/AdminCati.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.cati;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import fr.inra.refcomp.client.admin.AdminUtil;
import fr.inra.refcomp.client.constants.Form;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.Cati;
import java.util.List;

/**
 * User: couteau
 * Date: 29 nov. 2010
 */
public class AdminCati extends Composite {

    private static final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("AdminCati.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, AdminCati> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiField
    static ListBox catiList;

    @UiField
    Form form;

    @UiHandler("addButton")
    void doClickAdd(ClickEvent event) {
        service.createCati(new RefcompCallBack<Cati>() {
            @Override
            public void onSuccess(Cati result) {
                form.setContent(result, true);
            }
        });
    }


    public AdminCati() {
        initWidget(binder.createAndBindUi(this));

        History.newItem("adminCati");

        AdminUtil.checkAdmin();
        refresh();

        CatiForm catiForm = new CatiForm();

        form.setContentPanel(catiForm);

        catiList.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {

                String beanId = catiList.getValue(catiList.getSelectedIndex());

                service.getCati(beanId, new RefcompCallBack<Cati>() {
                    @Override
                    public void onSuccess(Cati result) {
                        form.setContent(result, false);
                    }
                });
            }
        });
    }

    public static void refresh() {
        service.getCatis(new RefcompCallBack<List<Cati>>() {
            @Override
            public void onSuccess(List<Cati> result) {
                catiList.clear();
                for (Cati cati : result) {
                    String text = cati.getName();
                    String fullName = cati.getFullName();
                    if (fullName != null && !fullName.isEmpty()) {
                        text += " - " + fullName;
                    }
                    catiList.addItem(text, cati.getWikittyId());
                }
            }
        });
    }
}
