/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: BoatActivityCalendar.java 874 2010-12-31 15:52:58Z bleny $
 * $HeadURL: svn+ssh://bleny@labs.libre-entreprise.org/svnroot/suiviobsmer/tags/wao-2.1/wao-ui/src/main/java/fr/ifremer/wao/ui/pages/BoatActivityCalendar.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.ActivityCalendar;
import fr.ifremer.wao.entity.ActivityMonth;
import fr.ifremer.wao.entity.ActivityProfession;
import fr.ifremer.wao.entity.ActivityZone;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.nuiton.util.DateUtil;
import org.slf4j.Logger;

import java.util.Collections;
import java.util.List;

/**
 * ActivityCalendarPage
 *
 * Created: 14 déc. 2009
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
@RequiresAuthentication(allowedRoles = {UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER})
@Import(stylesheet = "context:css/boats.css")
public class BoatActivityCalendar {

    @Inject
    private Logger log;

    @InjectComponent
    private Layout layout;
    
    @Inject
    private ServiceBoat serviceBoat;

    @SessionState
    private ConnectedUser user;

    private ActivityCalendar activityCalendar;

//    @Property
//    private ActivityMonth activityMonth;

    @Property
    private int month;

    @Property
    private int professionIndex;

    @Property
    private int zoneIndex;

    private Boat boat;

    private Integer boatImmatriculation;

    void setupRender() {
        if (boatImmatriculation == null) {
             layout.addFatal("Page inaccessible, aucun navire chargé" +
                     " permettant l'affichage du calendrier d'activité." +
                     " Veuillez retourner sur la page des navires.");
        } else {
            try {
                getBoat();
            } catch (WaoBusinessException eee) {
                layout.addFatal(eee.getMessage());
            }
        }
    }

    void onActivate(Integer boatImmatriculation) {
        this.boatImmatriculation = boatImmatriculation;
    }

    Integer onPassivate() {
        return boatImmatriculation;
    }

    @Deprecated
    public void setBoat(Boat boat) {
       this.boat = boat;
    }

    public Boat getBoat() throws WaoBusinessException {
        if (boat == null) {
            boat = serviceBoat.getBoat(boatImmatriculation);
        }
        return boat;
    }

    public List<Boat> getBoats() {
        return Collections.singletonList(boat);
    }

    public ActivityCalendar getActivityCalendar() throws WaoBusinessException {
        if (activityCalendar == null) {
            this.activityCalendar = serviceBoat.getLastActivityCalendar(user, getBoat());
        }
        return activityCalendar;
    }

    public ActivityMonth getActivityMonth() throws WaoBusinessException {
        return getActivityCalendar().getActivityMonth(month);
    }

    public String getMonthName() {
        String libelle = DateUtil.getMonthLibelle(month);
        return StringUtils.capitalize(libelle);
    }

    public int getProfessionIndexMax() {
        int result = 0;
        for (ActivityMonth curr : activityCalendar.getActivityMonth()) {
            int nbProfessions = curr.sizeActivityProfession();
            if (nbProfessions > result) {
                result = nbProfessions;
            }
        }
        return result-1;
    }

    public boolean hasProfessions() {
        return getProfessionIndexMax() != -1;
    }

    public ActivityProfession getActivityProfession() throws WaoBusinessException {
        if (getActivityMonth() == null) {
            return null;
        }
        if (professionIndex >= getActivityMonth().sizeActivityProfession()) {
            return null;
        }
        return getActivityMonth().getActivityProfession().get(professionIndex);
    }

    public int getZoneIndexMax() throws WaoBusinessException {
        int result = 0;
        for (ActivityMonth activityMonth : activityCalendar.getActivityMonth()) {
            month = activityMonth.getMonth();
            ActivityProfession profession = getActivityProfession();
            if (profession != null) {
                int nbZones = profession.sizeActivityZone();
                if (nbZones > result) {
                    result = nbZones;
                }
            }
        }
        return result-1;
    }

    /** Hack for pagelink to Boats page
     *
     * @return null
     */
    public String getNorow() {
        return null;
    }

//    public boolean hasZones() {
//        return getZoneIndexMax() != -1;
//    }

    public ActivityZone getActivityZone() throws WaoBusinessException {
        ActivityProfession profession = getActivityProfession();
        if (profession == null) {
            return null;
        }
        if (zoneIndex >= profession.sizeActivityZone()) {
            return null;
        }
        return profession.getActivityZone().get(zoneIndex);
    }

    /*************************** RETURN LINK **********************************/

    public Object[] getBoatsPageContext() throws WaoBusinessException {
        return new Object[] {null, getBoat().getImmatriculation()};
    }

//    @InjectPage
//    private Boats boatsPage;
//
//    Object onActionFromReturnToBoats() {
//        boatsPage.setBoatSelectedImmatriculation(getBoat().getImmatriculation());
//        return boatsPage;
//    }
}
