/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.io.ImportResults;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.ui.components.SamplingFilterComponent;
import fr.ifremer.wao.ui.data.ExportStreamResponse;
import fr.ifremer.wao.ui.data.ImportEngine;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.data.SampleRowDataSource;
import fr.ifremer.wao.ui.services.SampleRowModelFactory;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.BeanModelSource;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

@RequiresAuthentication(allowedPrograms = {ObsProgram.OBSDEB})
public class ObsDebSamplingPlan {

    /********* Tapestry stuffs **********/

    @Inject
    private BeanModelSource beanModelSource;

    @Inject
    private ComponentResources resources;

    @Inject
    private ServiceSampling serviceSampling;

    private DateFormat dateFormat;

    public DateFormat getDateFormat() {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("dd/MM/YYYY");
        }
        return dateFormat;
    }

    /********* Session ************/

    @SessionState
    @Property
    private ConnectedUser connectedUser;

    /********* Page layout ***********/

    @Persist
    private Boolean showImport;

    @InjectComponent
    private Zone importZone;

    @InjectComponent
    private SamplingFilterComponent samplingFilter;

    public ServiceSampling getServiceSampling() {
        return serviceSampling;
    }

    public boolean getShowImport() {
        if (showImport == null) {
            showImport = false;
        }
        return showImport;
    }

    public Object onActionFromShowFilters() {
        samplingFilter.switchFiltersVisible();
        return samplingFilter;
    }

    public Object onActionFromShowImport() {
        showImport = ! getShowImport();
        if (showImport) {
            return importZone.getBody();
        } else {
            return importZone;
        }
    }

    /********* GRID ********/

    private GridDataSource sampleRows;

    @Property
    private SampleRow sampleRow;

    public GridDataSource getSampleRows() {
        if (sampleRows == null) {
            sampleRows = new SampleRowDataSource(samplingFilter.getFilter(), serviceSampling);
        }
        return sampleRows;
    }

    private BeanModel<SampleRow> obsdebSamplingPlanModel;

    public BeanModel<SampleRow> getObsdebSamplingPlanModel() {
        if (obsdebSamplingPlanModel == null) {
            SampleRowModelFactory sampleRowModelFactory = new SampleRowModelFactory(beanModelSource, resources, connectedUser);
            obsdebSamplingPlanModel = sampleRowModelFactory.newModel();
        }
        return obsdebSamplingPlanModel;
    }

    /************ ACTIONS ***************/

    public boolean canEditSampleRow() {
        boolean canEditSampleRow = connectedUser.isAdmin() || connectedUser.isCoordinator();
        return canEditSampleRow;
    }

    /********** IMPORT / EXPORT *********/

    public ImportEngine getSamplingPlanImportEngine() {
        return new ImportEngine() {
            @Override
            public ImportResults execute(InputStream input)
                    throws WaoException, WaoBusinessException {
                ImportResults results = serviceSampling.importSamplingPlanCsv(input, connectedUser);
                return results;
            }
        };
    }

    StreamResponse onActionFromExportSamplingPlan() {
        return new ExportStreamResponse("wao-echantillonnage-obsdeb") {
            @Override
            public InputStream getStream() throws IOException {
                InputStream csv;
                try {
                    csv = serviceSampling.exportSamplingPlanCsv(connectedUser, samplingFilter.getFilter());
                } catch (WaoException eee) {
                    throw new IOException(eee);
                }
                return csv;
            }
        };
    }
}
