/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.wao.ui.components;

import org.apache.tapestry5.OptionGroupModel;
import org.apache.tapestry5.OptionModel;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.util.AbstractSelectModel;
import org.slf4j.Logger;

import java.util.ArrayList;
import java.util.List;

/**
 * Component to select one or many string
 *
 * @author sletellier <letellier@codelutin.com>
 */
public class SimpleSelector {

    @Inject
    private Logger log;

    @Inject
    private PropertyAccess propertyAccess;

    @Parameter(required = true)
    private List<String> values;

    @Parameter(required = false)
    private Boolean multiple;

    @Parameter(required = false)
    private String selectedValue;

    @Parameter(required = false)
    private List<String> selectedValues;

    @Parameter(required = false)
    private Integer size;

    @Parameter(required = false)
    private SimpleSelectorModel model;

    public SimpleSelectorModel getModel() {
        if (model == null) {
            model = new SimpleSelectorModel();
        }
        return model;
    }

    public void setModel(SimpleSelectorModel model) {
        this.model = model;
    }

    public String getSelectedValue() {
        return selectedValue;
    }

    public void setSelectedValue(String selectedValue) {
        this.selectedValue = selectedValue;
    }

    public List<String> getSelectedValues() {
        return selectedValues;
    }

    public void setSelectedValues(List<String> selectedValues) {
        this.selectedValues = selectedValues;
    }

    public List<String> getValues() {
        return values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public Integer getSize() {
        if (size == null) {
            size = getValues().size();
        }
        return size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public boolean getMultiple() {
        if (multiple == null) {
            multiple = false;
        }
        return multiple;
    }

    public void setMultiple(Boolean multiple) {
        this.multiple = multiple;
    }

    /**
     * Model used by {@link fr.ifremer.wao.ui.components.SimpleSelector}
     *
     * @author sletellier <letellier@codelutin.com>
     */
    public class SimpleSelectorModel extends AbstractSelectModel {

        protected SelectModelImpl delegate;

        public SimpleSelectorModel() {
            delegate = new SelectModelImpl(null, getOptionModels(getValues()));
        }

        @Override
        public List<OptionGroupModel> getOptionGroups() {
            return delegate.getOptionGroups();
        }

        @Override
        public List<OptionModel> getOptions() {
            return delegate.getOptions();
        }

        protected List<OptionModel> getOptionModels(List<String> values) {
            List<OptionModel> options = new ArrayList<OptionModel>();
            for (String value : values) {
                options.add(new OptionModelImpl(value, value));
            }
            return options;
        }
    }
}
