/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.entity.UserProfile;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.components.FeedBack;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import fr.ifremer.wao.ui.data.TapestryUtil;
import fr.ifremer.wao.ui.services.ServiceAuthentication;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.PageRenderLinkSource;
import org.slf4j.Logger;

@Import(library={"context:js/wao.js"})
public class Connexion {
    @Inject
    private Logger logger;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private ServiceAuthentication serviceAuthentication;
    @Inject
    private PageRenderLinkSource pageRender;
    @InjectComponent
    private FeedBack connexionFeedback;
    private Object[] activationContext;
    @Property
    private String login;
    @Property
    private String password;
    @Persist(value="flash")
    @Property
    private String email;
    @Persist(value="flash")
    @Property
    private boolean showRoleWindow;
    @InjectComponent
    private Form connexionForm;
    @Inject
    private PropertyAccess propertyAccess;
    private GenericSelectModel<UserProfile> profileSelectModel;
    @Property
    private UserProfile userProfile;
    @Property
    private String userProfileId;

    void onActivate(Object ... activationContext) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Activiation context : " + Arrays.toString(activationContext));
        }
        this.activationContext = activationContext;
    }

    Object[] onPassivate() {
        return this.activationContext;
    }

    @Log
    void onValidateFormFromConnexionForm() {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Connection for user with login : " + this.login);
            }
            ConnectedUser user = this.serviceUser.connect(this.login, this.password);
            this.serviceAuthentication.setConnectedUser(user);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("User connected : " + user.getFullName());
            }
        }
        catch (WaoBusinessException eee) {
            if (eee.getType().equals((Object)WaoBusinessException.Type.BAD_CONNECTION)) {
                this.connexionFeedback.addError(new String[]{eee.getMessage()});
                this.email = this.login;
            } else if (eee.getType().equals((Object)WaoBusinessException.Type.ILLEGAL_CONNECTION)) {
                this.connexionFeedback.addInfo(eee.getMessage());
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.error("WaoBusinessException " + eee.getType() + " : " + eee.getMessage(), (Throwable)eee);
            }
            this.connexionForm.recordError(eee.getMessage());
        }
    }

    public boolean hasConnexionErrors() {
        return this.connexionFeedback.hasErrors();
    }

    @Log
    Object onSuccessFromConnexionForm() throws WaoException {
        if (this.serviceAuthentication.getConnectedUser().getProfile() == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Not only one role, window will be open to select the role");
            }
            this.showRoleWindow = true;
            return this;
        }
        return this.getRedirectLink();
    }

    @Log
    Object onFailureFromConnexionForm() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Failure, errors are recorded (email = " + this.email + ")");
        }
        return this;
    }

    private Link getRedirectLink() {
        String redirectPage = TapestryUtil.getFirstString((Object[])this.activationContext);
        if (redirectPage == null) {
            redirectPage = "index";
        }
        Object[] redirectPageContext = TapestryUtil.getOtherContext((Object[])this.activationContext);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Redirect page '" + redirectPage + "' " + "context : " + Arrays.toString(redirectPageContext));
        }
        Link redirectLink = null;
        redirectLink = redirectPageContext == null ? this.pageRender.createPageRenderLink(redirectPage) : this.pageRender.createPageRenderLinkWithContext(redirectPage, redirectPageContext);
        return redirectLink;
    }

    void onSuccessFromForgetPassword() throws WaoException {
        try {
            this.serviceUser.forgetPassword(this.email);
            this.connexionFeedback.addInfo("Un email avec votre nouveau mot de passe vous a \u00e9t\u00e9 envoy\u00e9.");
        }
        catch (WaoBusinessException eee) {
            this.connexionFeedback.addError(new String[]{eee.getMessage()});
        }
    }

    public GenericSelectModel<UserProfile> getProfileSelectModel() throws WaoException {
        if (this.serviceAuthentication.existConnectedUser()) {
            WaoUser user = this.serviceAuthentication.getConnectedUser().getUser();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Load user roles for " + user.getFullName());
            }
            ArrayList profiles = new ArrayList(user.getUserProfile());
            this.profileSelectModel = new GenericSelectModel(profiles, UserProfile.class, "description", "topiaId", this.propertyAccess);
        } else if (this.profileSelectModel == null) {
            this.profileSelectModel = new GenericSelectModel(new ArrayList(), UserProfile.class, "description", "topiaId", this.propertyAccess);
        }
        return this.profileSelectModel;
    }

    Link onSuccessFromRoleForm() {
        this.userProfile = (UserProfile)this.getProfileSelectModel().findObject(this.userProfileId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Connection with role : " + this.userProfile.getDescription());
        }
        this.serviceAuthentication.getConnectedUser().setProfile(this.userProfile);
        return this.getRedirectLink();
    }
}

