/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ContactFilter;
import fr.ifremer.wao.bean.ContactFilterImpl;
import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.bean.DataReliability;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.io.ImportResults;
import fr.ifremer.wao.service.ServiceContact;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.base.AbstractFilteredPage;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.ContactDataSource;
import fr.ifremer.wao.ui.data.GenericSelectModel;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.pages.Contacts;
import fr.ifremer.wao.ui.services.ContactModelFactory;
import fr.ifremer.wao.ui.services.WaoManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.BeanModelSource;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.slf4j.Logger;

@RequiresAuthentication(value={UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER})
@IncludeStylesheet(value={"context:css/contacts.css"})
@IncludeJavaScriptLibrary(value={"context:js/contacts.js"})
public class Contacts
extends AbstractFilteredPage {
    @Inject
    private Logger logger;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private ConnectedUser user;
    @Inject
    private ServiceContact serviceContact;
    @Environmental
    private RenderSupport renderSupport;
    @Persist
    private ContactFilter contactFilter;
    @InjectComponent
    private Zone filtersZone;
    @InjectComponent
    private Zone importExportZone;
    private boolean reset;
    @Property
    private ContactState stateFilter;
    @Property
    private UploadedFile contactsCsvFile;
    @Persist
    @Property
    private Boolean fullView;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private ComponentResources resources;
    @Inject
    private ContactModelFactory contactModelFactory;
    @Persist
    private ContactDataSource contacts;
    @Property
    private Contact contact;
    private BeanModel<Contact> contactModel;
    @Inject
    private PropertyAccess propertyAccess;
    private GenericSelectModel<WaoUser> userSelectModel;
    @Property
    @Persist(value="flash")
    private String contactUserId;
    private boolean even = true;
    private boolean edited;
    private boolean deleted;
    @Persist
    @Property
    private Contact contactEdited;
    @Persist
    private String oldComment;
    @Persist
    private ContactState oldState;
    @Persist(value="flash")
    private String contactSelectedId;
    @InjectComponent
    private Form contactsForm;
    @InjectComponent
    private Zone gridZone;
    @InjectComponent
    private Field beginDate;
    @InjectComponent
    private Field endDate;
    @InjectComponent
    private Field nbObservants;
    @InjectComponent
    private Field comment;
    @InjectComponent
    private Field inputDate;
    @Inject
    private WaoManager manager;
    @Inject
    private Messages messages;
    @Property
    private boolean sendEmail;
    @Property
    private String contactId;
    @Property
    private String extraComment;

    @Log
    void setupRender() throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("RESET DATA");
            this.logger.debug("User : " + this.user.getFullName());
        }
        this.contacts = null;
        this.contactsForm.clearErrors();
        if (this.isFiltersVisible()) {
            this.initSelectFilters(true, true, true);
        }
        if (this.fullView == null) {
            this.fullView = this.user.isAdmin();
        }
        this.initCompanyFilter();
    }

    @Log
    void afterRender() {
        this.addCommentScript();
        this.addSendEmailScript();
    }

    public ContactFilter getContactFilter() throws WaoException {
        if (this.contactFilter == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Init contactFilter");
            }
            this.contactFilter = new ContactFilterImpl();
            GregorianCalendar beginningOfCurrentYear = new GregorianCalendar();
            beginningOfCurrentYear.set(6, 1);
            this.contactFilter.setFromDate(beginningOfCurrentYear.getTime());
        }
        return this.contactFilter;
    }

    public boolean isFiltersVisible() {
        boolean companyFiltered = this.getContactFilter().getCompany() != null && this.user.isAdmin();
        return (this.getContactFilter().isFiltered() || companyFiltered) && StringUtils.isEmpty((String)this.getContactFilter().getBoatName());
    }

    protected SamplingFilter getFilter() throws WaoException {
        return this.getContactFilter();
    }

    protected boolean isAvailableDataForFiltersOnly() {
        return true;
    }

    public boolean canFilterExtraComments() {
        return this.user.isAdmin() || this.user.isCoordinator();
    }

    Object onActionFromShowFilters() {
        this.initSelectFilters(true, true, true);
        return this.filtersZone.getBody();
    }

    Object onActionFromShowImportExport() {
        return this.importExportZone.getBody();
    }

    void onSelectedFromReset() {
        this.reset = true;
    }

    @Log
    Object onSuccessFromFiltersForm() throws WaoException {
        if (this.isEdited()) {
            return this.filtersZone.getBody();
        }
        if (this.reset) {
            this.contactFilter = null;
        }
        return this;
    }

    public boolean canImportExport() {
        return (this.user.isAdmin() || this.user.getRole().equals((Object)UserRole.COORDINATOR)) && !this.user.isReadOnly();
    }

    @Log
    void onSuccessFromImportContacts() throws WaoException {
        if (this.canImportExport()) {
            try {
                ImportResults result = this.serviceContact.importContactCsv(this.user, this.contactsCsvFile.getStream());
                this.contacts = null;
                this.layout.addInfo(result.getNbRowsImported() + " contacts " + "import\u00e9s,  " + result.getNbRowsRefused() + " refus\u00e9s.");
                for (String error : result.getErrors()) {
                    this.layout.addInfo(error);
                }
            }
            catch (WaoBusinessException eee) {
                this.layout.addError(new String[]{eee.getMessage()});
            }
        }
    }

    StreamResponse onActionFromExportShowContacts() {
        if (this.canImportExport()) {
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        return null;
    }

    void onActionFromToggleDisplayMode() {
        this.fullView = this.fullView == false;
    }

    public ContactDataSource getContacts() throws WaoException {
        if (this.contacts == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Create DataSource");
            }
            this.contacts = new ContactDataSource(this.getContactFilter(), this.serviceContact);
        }
        return this.contacts;
    }

    public BeanModel<Contact> getContactModel() {
        if (this.contactModel == null) {
            this.contactModel = this.user.isAdmin() || this.user.isCoordinator() ? (this.fullView != false ? this.contactModelFactory.buildAdminContactModel(this.beanModelSource, this.resources) : this.contactModelFactory.buildCoordinatorContactModel(this.beanModelSource, this.resources)) : this.contactModelFactory.buildContactModel(this.beanModelSource, this.resources);
        }
        return this.contactModel;
    }

    public GenericSelectModel<WaoUser> getUserSelectModel() {
        if (this.userSelectModel == null) {
            List users = this.serviceUser.getObservers(this.user.getCompany(), true);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Nb users : " + users.size());
            }
            this.userSelectModel = new GenericSelectModel(users, WaoUser.class, "fullName", "id", this.propertyAccess);
        }
        return this.userSelectModel;
    }

    public String getCommentDisplayText(String comment) {
        if (comment != null && comment.length() > 20) {
            return comment.substring(0, 20) + "...";
        }
        return comment;
    }

    public String getCommentTooltip(String comment) {
        return this.manager.getTooltipText(comment);
    }

    public String getSampleRowDescription() {
        return this.manager.getTooltipSampleRow(this.contact.getSampleRow());
    }

    public String getBoatDescription() {
        return this.manager.getTooltipBoat(this.contact.getBoat());
    }

    public String getTooltipExportFrom() throws WaoException {
        if (this.getContactFilter().getFromDate() != null) {
            return "depuis le " + this.getDateFormat().format(this.getContactFilter().getFromDate());
        }
        return "";
    }

    public String getGridClass() {
        return this.fullView != false ? "admin" : "user";
    }

    public String getRowClass() {
        String result = this.manager.getContactStyle(this.contact, this.user.isAdmin());
        if (this.contact.getTopiaId().equals(this.contactSelectedId)) {
            result = "selected";
        }
        return result;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public boolean isEditionMode() {
        return this.contactEdited != null && this.contact.equals(this.contactEdited);
    }

    public boolean isEmpty(Boolean validation) {
        return validation == null;
    }

    public boolean isBoardingDone() {
        return this.contact.getContactState() == ContactState.BOARDING_DONE;
    }

    public boolean canUpdateDataReliability() {
        boolean result = this.user.isAdmin() && !this.user.isReadOnly() && this.contact.getValidationProgram() == null;
        return result;
    }

    public boolean hasActions() {
        return !this.user.isAdmin() && this.contact.getValidationCompany() == null && !this.user.isReadOnly();
    }

    public boolean hasValidationActions() {
        return (this.user.isAdmin() || this.user.getRole().equals((Object)UserRole.COORDINATOR)) && !this.user.isReadOnly();
    }

    public boolean canValidate() {
        if (this.isEditionMode()) {
            return false;
        }
        switch (2.$SwitchMap$fr$ifremer$wao$bean$UserRole[this.user.getRole().ordinal()]) {
            case 1: {
                return this.contact.getValidationProgram() == null && BooleanUtils.isTrue((Boolean)this.contact.getValidationCompany());
            }
            case 2: {
                ContactState state = this.contact.getContactState();
                boolean boardingDone = state.equals((Object)ContactState.BOARDING_DONE) && this.contact.getDataInputDate() != null;
                return this.contact.getValidationCompany() == null && (state.isUnfinishedState() || boardingDone);
            }
        }
        return false;
    }

    public boolean canUnvalidate() {
        switch (2.$SwitchMap$fr$ifremer$wao$bean$UserRole[this.user.getRole().ordinal()]) {
            case 1: {
                return this.contact.getValidationProgram() != null;
            }
            case 2: {
                return this.contact.getValidationCompany() != null && this.contact.getValidationProgram() == null;
            }
        }
        return false;
    }

    void onSelectedFromAcceptContact(String contactId) throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Accept contact : " + contactId);
        }
        this.contactEdited = (Contact)this.getContacts().get((Object)contactId);
        if (this.user.isAdmin()) {
            this.contactEdited.setValidationProgram(Boolean.TRUE);
        } else {
            this.contactEdited.setValidationCompany(Boolean.TRUE);
        }
    }

    void onSelectedFromRefuseContact(String contactId) throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Refuse contact : " + contactId);
        }
        this.contactEdited = (Contact)this.getContacts().get((Object)contactId);
        if (this.user.isAdmin()) {
            this.contactEdited.setValidationProgram(Boolean.FALSE);
        } else {
            this.contactEdited.setValidationCompany(Boolean.FALSE);
        }
    }

    void onSelectedFromUnvalidateContact(String contactId) throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Unvalidate contact : " + contactId);
        }
        this.contactEdited = (Contact)this.getContacts().get((Object)contactId);
        if (this.user.isAdmin()) {
            this.contactEdited.setValidationProgram(null);
        } else {
            this.contactEdited.setValidationCompany(null);
        }
    }

    @Log
    void onSelectedFromEditContact(String contactId) throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Edit contact : " + contactId);
            this.logger.debug("Contact : " + this.getContacts().get((Object)contactId));
            this.logger.debug("Set observerId : " + ((Contact)this.getContacts().get((Object)contactId)).getObserver());
        }
        this.contactEdited = (Contact)this.getContacts().get((Object)contactId);
        this.contactUserId = this.contactEdited.getObserver().getId();
        this.contactSelectedId = contactId;
        this.oldComment = this.contactEdited.getComment();
        this.oldState = this.contactEdited.getContactState();
        this.edited = true;
    }

    @Log
    void onSelectedFromDeleteContact(String contactId) throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Delete contact : " + contactId);
        }
        this.contactEdited = (Contact)this.getContacts().get((Object)contactId);
        this.deleted = true;
    }

    @Log
    void onSelectedFromSaveContact(String contactId) throws WaoException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Save contact : " + contactId);
            this.logger.debug("Observer Id : " + this.contactUserId);
        }
        WaoUser contactUser = (WaoUser)this.getUserSelectModel().findObject(this.contactUserId);
        this.contactEdited.setObserver(contactUser);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Comment : " + this.contactEdited.getComment());
        }
    }

    void onSelectedFromCancelEditContact() throws WaoException {
        this.contactEdited = null;
        this.edited = true;
    }

    protected void addSendEmailScript() {
        if (this.contactEdited != null && !this.contactEdited.getEmailSent()) {
            String confirmMessage = "Souhaitez vous envoyer un email de demande d\\'ajout du navire \u00e0 votre portefeuille Allegro afin de pouvoir saisir les donn\u00e9es ?";
            this.renderSupport.addScript("new ContactSendEmail('%s', '%s');", new Object[]{confirmMessage, ContactState.BOARDING_DONE.name()});
            this.renderSupport.addScript("new ContactSendEmail('%s', '%s');", new Object[]{confirmMessage, ContactState.BOARDING_EXPECTED.name()});
        }
    }

    @Log
    void onValidateFormFromContactsForm() {
        this.contactsForm.clearErrors();
        if (!this.edited && this.contactEdited != null) {
            ContactState contactState = this.contactEdited.getContactState();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("For state : " + contactState);
            }
            Date begin = this.contactEdited.getTideBeginDate();
            Date end = this.contactEdited.getTideEndDate();
            Date input = this.contactEdited.getDataInputDate();
            SampleRow row = this.contactEdited.getSampleRow();
            if (begin != null && !row.isValid(begin)) {
                this.contactsForm.recordError(this.beginDate, "La date de d\u00e9but de la mar\u00e9e doit correspondre \u00e0 un mois valide (non vide) de la ligne " + row.getCode());
            }
            if (begin != null && end != null && end.before(begin)) {
                this.contactsForm.recordError(this.endDate, "La date de fin de la mar\u00e9e ne peut pas \u00eatre ant\u00e9rieure \u00e0 celle de d\u00e9but");
            }
            Date current = this.manager.getCurrentDate();
            if (end != null && end.after(current)) {
                this.contactsForm.recordError(this.endDate, "La date de fin de la mar\u00e9e ne peut pas \u00eatre post\u00e9rieure \u00e0 la date du jour");
            }
            if (end != null && input != null && end.after(input)) {
                this.contactsForm.recordError(this.inputDate, "La date de saisie des donn\u00e9es ne peut pas \u00eatre ant\u00e9rieure \u00e0 la date de fin de la mar\u00e9e");
            }
            if (input != null && input.after(current)) {
                this.contactsForm.recordError(this.inputDate, "La date de saisie des donn\u00e9es ne peut pas \u00eatre post\u00e9rieure \u00e0 la date du jour");
            }
            if (contactState.isUnfinishedState()) {
                boolean previousUnfinishedState;
                String newComment = this.contactEdited.getComment();
                boolean commentDefined = StringUtils.isNotEmpty((String)newComment);
                boolean commentChanged = commentDefined && !newComment.equals(this.oldComment);
                boolean bl = previousUnfinishedState = commentDefined && this.oldState != null && this.oldState.isUnfinishedState();
                if (previousUnfinishedState || commentChanged) {
                    this.contactEdited.setTideBeginDate(null);
                    this.contactEdited.setTideEndDate(null);
                    this.contactEdited.setNbObservants(0);
                    this.contactEdited.setMammalsCapture(false);
                    this.contactEdited.setMammalsObservation(false);
                    this.contactEdited.setDataInputDate(null);
                } else {
                    this.contactsForm.recordError(this.comment, "Vous devez ajouter un commentaire pour l'\u00e9tat '" + contactState.libelle() + "'");
                }
            } else if (contactState.equals((Object)ContactState.BOARDING_DONE)) {
                if (begin == null) {
                    this.contactsForm.recordError(this.beginDate, "La date de d\u00e9but de mar\u00e9e est obligatoire pour l'\u00e9tat '" + contactState.libelle() + "'");
                }
                if (end == null) {
                    this.contactsForm.recordError(this.endDate, "La date de fin de mar\u00e9e est obligatoire pour l'\u00e9tat '" + contactState.libelle() + "'");
                }
                if (this.contactEdited.getNbObservants() == 0) {
                    this.contactsForm.recordError(this.nbObservants, "Il ne peut y avoir aucun observateur pour l'\u00e9tat '" + contactState.libelle() + "'");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("ValidationProgram = " + this.contactEdited.isValidationProgram());
                }
                if (BooleanUtils.isTrue((Boolean)this.contactEdited.isValidationProgram())) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("field data reliability is " + this.contactEdited.getDataReliability());
                    }
                    if (this.contactEdited.getDataReliability() == null || this.contactEdited.getDataReliability() == DataReliability.UNKNOWN) {
                        this.contactsForm.recordError("Il faut pr\u00e9ciser la qualit\u00e9 des donn\u00e9es avant de valider");
                    }
                }
            }
        }
    }

    @Log
    Object onSuccessFromContactsForm() {
        if (!this.edited && this.contactEdited != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Contact save : " + this.contactEdited);
                this.logger.debug("Contact sendEmail : " + this.sendEmail);
            }
            this.serviceContact.saveContact(this.contactEdited, this.deleted);
            try {
                if (this.sendEmail && this.serviceContact.sendContactDoneEmail(this.contactEdited)) {
                    this.layout.addInfo("Un email a \u00e9t\u00e9 envoy\u00e9 pour l'ajout du navire au portefeuille ALLEGRO.");
                }
            }
            catch (WaoBusinessException eee) {
                String message = this.manager.getErrorMessage(eee, this.messages, this.logger);
                this.layout.addError(new String[]{message});
            }
            this.contactSelectedId = this.contactEdited.getTopiaId();
            this.oldComment = null;
            this.contactEdited = null;
        }
        return this;
    }

    @Log
    Object onFailureFromContactsForm() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Contact can't be saved with errors");
        }
        if (BooleanUtils.isTrue((Boolean)this.contactEdited.isValidationProgram())) {
            this.contactEdited = null;
        }
        return this.contactsForm;
    }

    public void createNewContact(Boat boat, SampleRow sampleRow) throws WaoException {
        this.contact = this.serviceContact.getNewContact(this.user.getUser(), sampleRow, boat);
        if (boat != null && boat.canCreateContact(this.user.getCompany())) {
            this.serviceContact.saveContact(this.contact, Boolean.FALSE.booleanValue());
            this.contactSelectedId = this.contact.getTopiaId();
        } else {
            this.layout.addError(new String[]{"Un contact en cours existe d\u00e9j\u00e0 pour ce navire"});
        }
    }

    protected void addCommentScript() {
        this.renderSupport.addScript("commentController = new ContactComment('" + this.contactsForm.getClientId() + "');");
    }

    public String getContactComment() {
        String comment = null;
        if (this.isEditionMode()) {
            comment = this.contact.getComment();
        } else {
            switch (2.$SwitchMap$fr$ifremer$wao$bean$UserRole[this.user.getRole().ordinal()]) {
                case 1: {
                    comment = this.contact.getCommentAdmin();
                    break;
                }
                case 2: {
                    comment = this.contact.getCommentCoordinator();
                }
            }
        }
        return comment == null ? "" : comment.replace("'", "'");
    }

    public JSONObject getCommentData() {
        JSONObject json = new JSONObject();
        if (this.isEditionMode()) {
            json.put("formId", (Object)this.contactsForm.getClientId());
        }
        json.put("id", (Object)this.contact.getId());
        json.put("edited", (Object)this.isEditionMode());
        json.put("unfinished", (Object)this.contact.getContactState().isUnfinishedState());
        json.put("comment", (Object)this.getContactComment());
        return json;
    }

    @Log
    void onSuccessFromCommentForm() {
        this.serviceContact.saveComment(this.contactId, this.user.getRole(), this.extraComment);
    }

    static /* synthetic */ ServiceContact access$000(Contacts x0) {
        return x0.serviceContact;
    }
}

