/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.bean.PieChartData;
import fr.ifremer.wao.service.ServiceChart;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.InjectService;
import org.slf4j.Logger;

import java.net.MalformedURLException;
import java.net.URL;

/**
 * Created: 1 juil. 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id: PieChart.java 610 2010-07-11 19:10:28Z fdesbois $
 */
@RequiresAuthentication
public class PieChart {

    @Inject
    private Logger logger;

    @InjectService("serviceChartServlet")
    private ServiceChart chartServlet;

    URL onActivate(PieChartData data, boolean thumb)
            throws MalformedURLException {

        return new URL(chartServlet.getPieChartUrl(data, thumb));
    }

}
