/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.wao.ui.data;

import java.util.Arrays;

/**
 * Created: 12 juin 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id: TapestryUtil.java 593 2010-07-08 14:12:28Z fdesbois $
 */
public class TapestryUtil {

    public static String getFirstString(Object[] activationContext) {
        String firstString = null;
        if (activationContext.length > 0) {
            firstString = (String)activationContext[0];
        }
        return firstString;
    }

    public static Object[] getOtherContext(Object[] activationContext) {
        if (activationContext.length > 1) {
            Object[] otherContext =
                    Arrays.copyOfRange(activationContext, 1,
                                       activationContext.length);
            return otherContext;
        }
        return null;
    }
}
