/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.program.actions;

import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUIHandler;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import org.nuiton.i18n.I18n;

public class SaveProgramAction
extends LongActionSupport<EditProgramUIModel, EditProgramUI, EditProgramUIHandler> {
    public SaveProgramAction(EditProgramUIHandler handler) {
        super(handler, true);
    }

    @Override
    public void doAction() throws Exception {
        Program saved;
        TuttiUIContext context = this.getContext();
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        EditProgramUIModel model = (EditProgramUIModel)this.getModel();
        Program bean = (Program)model.toEntity();
        if (TuttiEntities.isNew(bean)) {
            saved = persistenceService.createProgram(bean);
            model.setId(saved.getId());
            this.sendMessage(I18n.t((String)"tutti.flash.info.programCreated", (Object[])new Object[]{bean.getName()}));
        } else {
            saved = persistenceService.saveProgram(bean);
            this.sendMessage(I18n.t((String)"tutti.flash.info.programSaved", (Object[])new Object[]{bean.getName()}));
        }
        context.setProgramId(saved.getId());
        model.setModify(false);
    }

    public void postSuccessAction() {
        this.getContext().getMainUI().getHandler().setBodyTitle(EditProgramUIHandler.getTitle(true));
    }
}

