/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.operationimport;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.protocol.OperationFieldMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.operationimport.ImportFromColumnFileFishingOperationNotFoundException;
import fr.ifremer.tutti.service.operationimport.ImportFromColumnFileInvalidRowException;
import fr.ifremer.tutti.service.operationimport.ImportFromColumnFileMissingHeaderException;
import fr.ifremer.tutti.service.operationimport.ImportFromColumnFileModel;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.Import2;
import org.nuiton.csv.ImportConf;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRow;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.util.DateUtil;

public class FishingOperationImportService
extends AbstractTuttiService {
    protected PersistenceService persistenceService;
    private TuttiDataContext dataContext;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.dataContext = context.getDataContext();
    }

    public void importCaracteristicsFromColumnFile(File columnsFile, FishingOperation fishingoperation) throws ImportFromColumnFileInvalidRowException, ImportFromColumnFileFishingOperationNotFoundException, ImportFromColumnFileMissingHeaderException, IOException {
        List<String> headers = this.getService(ProtocolImportExportService.class).loadProtocolCaracteristicsImportColumns(columnsFile);
        ImportFromColumnFileModel importModel = new ImportFromColumnFileModel(';', new HashSet<String>(headers), this.persistenceService, this.dataContext, fishingoperation);
        ImportConf conf = new ImportConf();
        conf.setStrictMode(false);
        MatchingFishingOperationNaturalIdPredicate matchingRowPredicate = new MatchingFishingOperationNaturalIdPredicate(fishingoperation.getStationNumber(), fishingoperation.getFishingOperationNumber(), fishingoperation.getGearShootingStartDate(), this.dataContext.getProtocol());
        try (Import2 operationUIModelImport = Import2.newImport((ImportConf)conf, (ImportModel)importModel, (InputStream)new FileInputStream(columnsFile));){
            this.doImport((Import2<FishingOperation>)operationUIModelImport, matchingRowPredicate);
        }
        catch (FileNotFoundException e) {
            throw new ApplicationTechnicalException("Could not find import file " + columnsFile);
        }
    }

    protected void doImport(Import2<FishingOperation> operationUIModelImport, MatchingFishingOperationNaturalIdPredicate matchingRowPredicate) throws ImportFromColumnFileInvalidRowException, ImportFromColumnFileFishingOperationNotFoundException {
        boolean found = false;
        for (ImportRow next : operationUIModelImport) {
            FishingOperation fishingOperation = (FishingOperation)next.getBean();
            if (!matchingRowPredicate.apply(fishingOperation)) continue;
            if (!next.isValid()) {
                Set errors = next.getErrors();
                throw new ImportFromColumnFileInvalidRowException(errors);
            }
            found = true;
            break;
        }
        if (!found) {
            throw new ImportFromColumnFileFishingOperationNotFoundException();
        }
    }

    protected static class MatchingFishingOperationNaturalIdPredicate
    implements Predicate<FishingOperation> {
        protected final String stationNumber;
        protected final Integer fishingOperationNumber;
        protected final Date modelGearShootingStartOnlyDate;
        protected final Map<String, OperationFieldMappingRow> mappingRowsByField;

        MatchingFishingOperationNaturalIdPredicate(String stationNumber, Integer fishingOperationNumber, Date modelGearShootingStartDate, TuttiProtocol protocol) {
            this.stationNumber = stationNumber;
            this.fishingOperationNumber = fishingOperationNumber;
            this.modelGearShootingStartOnlyDate = modelGearShootingStartDate != null ? DateUtil.getDay((Date)modelGearShootingStartDate) : null;
            this.mappingRowsByField = Maps.uniqueIndex((Iterable)protocol.getOperationFieldMapping(), OperationFieldMappingRow::getField);
        }

        public boolean apply(FishingOperation fishingOperation) {
            OperationFieldMappingRow operationNumberRow = this.mappingRowsByField.get("fishingOperationNumber");
            OperationFieldMappingRow stationNumberRow = this.mappingRowsByField.get("stationNumber");
            OperationFieldMappingRow startDateRow = this.mappingRowsByField.get("gearShootingStartDate");
            String operationNumberColumn = operationNumberRow != null ? operationNumberRow.getImportColumn() : null;
            String stationColumn = stationNumberRow != null ? stationNumberRow.getImportColumn() : null;
            String startDateColumn = startDateRow != null ? startDateRow.getImportColumn() : null;
            boolean sameStationNumber = Objects.equals(fishingOperation.getStationNumber(), this.stationNumber);
            boolean sameFishingOperationNumber = Objects.equals(fishingOperation.getFishingOperationNumber(), this.fishingOperationNumber);
            Date gearShootingStartDate = fishingOperation.getGearShootingStartDate();
            if (gearShootingStartDate != null) {
                gearShootingStartDate = DateUtil.getDay((Date)gearShootingStartDate);
            }
            boolean sameGearShootingStartDate = Objects.equals(this.modelGearShootingStartOnlyDate, gearShootingStartDate);
            return !(!StringUtils.isBlank((CharSequence)stationColumn) && !sameStationNumber || !StringUtils.isBlank((CharSequence)operationNumberColumn) && !sameFishingOperationNumber || !StringUtils.isBlank((CharSequence)startDateColumn) && !sameGearShootingStartDate);
        }
    }
}

