/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.catches.WeightComputingService;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class GenericFormatCheckDataService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(GenericFormatCheckDataService.class);
    protected PersistenceService persistenceService;
    protected WeightComputingService weightComputingService;
    protected Decorator<FishingOperation> fishingOperationDecorator;
    protected Decorator<Cruise> cruiseDecorator;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.weightComputingService = this.getService(WeightComputingService.class);
        DecoratorService decoratorService = this.getService(DecoratorService.class);
        this.cruiseDecorator = decoratorService.getDecoratorByType(Cruise.class);
        this.fishingOperationDecorator = decoratorService.getDecoratorByType(FishingOperation.class);
    }

    public String getCruiseErrors(Cruise cruise, Set<FishingOperation> operations, ProgressionModel progressionModel) {
        String result;
        Map<Integer, String> errors = this.getFishingOperationsErrors(cruise, operations, progressionModel);
        if (!errors.isEmpty()) {
            StringBuilder errorMessageBuilder = new StringBuilder();
            for (String error : errors.values()) {
                errorMessageBuilder.append("<li>").append(error).append("</li>");
            }
            String cruiseStr = this.cruiseDecorator.toString((Object)cruise);
            result = I18n.t((String)"tutti.service.genericFormat.invalid.cruise", (Object[])new Object[]{cruiseStr, errorMessageBuilder.toString()});
        } else {
            result = null;
        }
        return result;
    }

    protected Map<Integer, String> getFishingOperationsErrors(Cruise cruise, Set<FishingOperation> operations, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)cruise);
        Preconditions.checkNotNull((Object)progressionModel);
        progressionModel.increments(I18n.t((String)"tutti.service.genericFormat.checkCruise", (Object[])new Object[]{cruise.getName()}));
        LinkedHashMap<Integer, String> errors = new LinkedHashMap<Integer, String>();
        for (FishingOperation fishingOperation : operations) {
            Integer fishingOperationId = fishingOperation.getIdAsInt();
            progressionModel.increments(I18n.t((String)"tutti.service.genericFormat.checkCruiseFishingOperation", (Object[])new Object[]{cruise.getName(), this.fishingOperationDecorator.toString((Object)fishingOperation)}));
            Set<String> errorsForOperation = this.checkFishingOperation(fishingOperationId);
            if (errorsForOperation.isEmpty()) continue;
            String fishingOperationStr = this.fishingOperationDecorator.toString((Object)fishingOperation);
            StringBuilder sb = new StringBuilder();
            for (String error : errorsForOperation) {
                sb.append("<li>").append(error).append("</li>");
            }
            String errorMessage = I18n.t((String)"tutti.service.genericFormat.invalid.fishingOperation", (Object[])new Object[]{fishingOperationStr, sb.toString()});
            errors.put(fishingOperationId, errorMessage);
        }
        return errors;
    }

    public Set<String> checkFishingOperation(Integer fishingOperationId) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will check operation: " + fishingOperationId));
        }
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        boolean withCatchBatch = this.persistenceService.isFishingOperationWithCatchBatch(fishingOperationId);
        if (!withCatchBatch) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Skip fishing operation " + fishingOperationId + " since no catchBatch associated."));
            }
        } else {
            BatchContainer<MarineLitterBatch> rootMarineLitterBatch;
            BatchContainer<SpeciesBatch> rootBenthosBatch;
            BatchContainer<SpeciesBatch> rootSpeciesBatch;
            try {
                rootSpeciesBatch = this.weightComputingService.getComputedSpeciesBatches(fishingOperationId);
            }
            catch (ApplicationBusinessException e) {
                errors.add(e.getMessage());
                rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(fishingOperationId, false);
            }
            try {
                rootBenthosBatch = this.weightComputingService.getComputedBenthosBatches(fishingOperationId);
            }
            catch (ApplicationBusinessException e) {
                errors.add(e.getMessage());
                rootBenthosBatch = this.persistenceService.getRootBenthosBatch(fishingOperationId, false);
            }
            CatchBatch catchBatch = this.persistenceService.getCatchBatchFromFishingOperation(fishingOperationId);
            try {
                Float weight = catchBatch == null ? null : catchBatch.getMarineLitterTotalWeight();
                rootMarineLitterBatch = this.weightComputingService.getComputedMarineLitterBatches(fishingOperationId, weight);
            }
            catch (ApplicationBusinessException e) {
                errors.add(e.getMessage());
                rootMarineLitterBatch = this.persistenceService.getRootMarineLitterBatch(fishingOperationId);
            }
            try {
                if (catchBatch != null) {
                    this.weightComputingService.computeCatchBatchWeights(catchBatch, rootSpeciesBatch, rootBenthosBatch, rootMarineLitterBatch);
                }
            }
            catch (ApplicationBusinessException e) {
                errors.add(e.getMessage());
            }
        }
        return errors;
    }
}

