/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential.csv;

import fr.ifremer.tutti.persistence.entities.referential.Vessels;
import fr.ifremer.tutti.service.csv.AbstractTuttiImportExportModel;
import fr.ifremer.tutti.service.csv.TuttiCsvUtil;
import fr.ifremer.tutti.service.referential.csv.TemporaryReferentialEntityIdParser;
import fr.ifremer.tutti.service.referential.csv.VesselRow;
import org.nuiton.csv.Common;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;
import org.nuiton.i18n.I18n;

public class VesselModel
extends AbstractTuttiImportExportModel<VesselRow> {
    public static VesselModel forExport(char separator) {
        VesselModel exportModel = new VesselModel(separator);
        exportModel.forExport();
        return exportModel;
    }

    public static VesselModel forImport(char separator) {
        VesselModel importModel = new VesselModel(separator);
        importModel.forImport();
        return importModel;
    }

    public VesselRow newEmptyInstance() {
        return new VesselRow();
    }

    protected VesselModel(char separator) {
        super(separator);
    }

    protected void forImport() {
        this.newMandatoryColumn("id", new TemporaryReferentialEntityIdParser(I18n.t((String)"tutti.service.referential.import.vessel.codePrefixMissing.error", (Object[])new Object[]{"#TEMP\u00bf"})){

            @Override
            protected boolean isTemporaryId(String parse) {
                return Vessels.isTemporaryId((String)parse);
            }
        });
        this.newMandatoryColumn("name");
        this.newMandatoryColumn("internationalRegistrationCode");
        this.newMandatoryColumn("scientificVessel", (ValueParser)Common.PRIMITIVE_BOOLEAN);
        this.newMandatoryColumn("toDelete", (ValueParser)TuttiCsvUtil.BOOLEAN);
    }

    protected void forExport() {
        this.newColumnForExport("id");
        this.newColumnForExport("name");
        this.newColumnForExport("internationalRegistrationCode");
        this.newColumnForExport("scientificVessel", (ValueFormatter)Common.PRIMITIVE_BOOLEAN);
        this.newColumnForExport("toDelete");
    }
}

