/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequencys;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.BenthosBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.SpeciesBatchPersistenceServiceSupport;
import fr.ifremer.tutti.persistence.service.util.BatchPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.tree.BenthosBatchTreeHelper;
import fr.ifremer.tutti.persistence.service.util.tree.SpeciesBatchTreeHelperSupport;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service(value="benthosBatchPersistenceService")
public class BenthosBatchPersistenceServiceImpl
extends SpeciesBatchPersistenceServiceSupport
implements BenthosBatchPersistenceService {
    private static final Log log = LogFactory.getLog(BenthosBatchPersistenceServiceImpl.class);
    @Resource(name="benthosBatchTreeHelper")
    protected BenthosBatchTreeHelper batchTreeHelper;

    public BenthosBatchPersistenceServiceImpl() {
        super("Benthos", SpeciesBatchs::newBenthosBatch, SpeciesBatchFrequencys::newBenthosBatchFrequency);
    }

    @Override
    protected SpeciesBatchTreeHelperSupport getBatchTreeHelper() {
        return this.batchTreeHelper;
    }

    @Override
    protected void validate(BatchPersistenceHelper batchHelper, SampleCategoryModel sampleCategoryModel, BatchContainer<SpeciesBatch> result) {
        batchHelper.validateBenthos(sampleCategoryModel, result);
    }

    @Override
    public BatchContainer<SpeciesBatch> getRootBenthosBatch(Integer fishingOperationId, boolean validateTree) {
        return this.getRootSpeciesBatch0(fishingOperationId, validateTree);
    }

    @Override
    public SpeciesBatch createBenthosBatch(SpeciesBatch bean, Integer parentBatchId, boolean computeRankOrder) {
        return this.createSpeciesBatch0(bean, parentBatchId, computeRankOrder);
    }

    @Override
    public Collection<SpeciesBatch> createBenthosBatches(Integer fishingOperationId, Collection<SpeciesBatch> beans) {
        return this.createSpeciesBatches0(fishingOperationId, beans);
    }

    @Override
    public SpeciesBatch saveBenthosBatch(SpeciesBatch bean) {
        return this.saveSpeciesBatch0(bean);
    }

    @Override
    public void deleteBenthosBatch(Integer id) {
        this.deleteSpeciesBatch0(id);
    }

    @Override
    public void deleteBenthosSubBatch(Integer id) {
        this.deleteSpeciesSubBatch0(id);
    }

    @Override
    public void changeBenthosBatchSpecies(Integer id, Species species) {
        this.changeSpeciesBatchSpecies0(id, species);
    }

    @Override
    public List<SpeciesBatch> getAllBenthosBatchToConfirm(Integer fishingOperationId) throws InvalidBatchModelException {
        return this.getAllSpeciesBatchToConfirm0(fishingOperationId);
    }

    @Override
    public List<SpeciesBatchFrequency> getAllBenthosBatchFrequency(Integer benthosBatchId) {
        return this.getAllSpeciesBatchFrequency0(benthosBatchId);
    }

    @Override
    public Multimap<Species, SpeciesBatchFrequency> getAllBenthosBatchFrequencyForBatch(BatchContainer<SpeciesBatch> batchContainer) {
        return this.getAllSpeciesBatchFrequencyForBatch0(batchContainer);
    }

    @Override
    public List<SpeciesBatchFrequency> saveBenthosBatchFrequency(Integer benthosBatchId, List<SpeciesBatchFrequency> frequencies) {
        return this.saveSpeciesBatchFrequency0(benthosBatchId, frequencies);
    }
}

