/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.referential;

import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.TaxonCache;
import java.util.HashMap;
import java.util.Map;

public class TaxonCaches {
    public static TaxonCache createSpeciesCacheWithoutVernacularCode(TuttiPersistence persistenceService, TuttiProtocol protocol) {
        boolean noProtocol = protocol == null;
        Map<Integer, SpeciesProtocol> protocolMap = noProtocol ? new HashMap<Integer, SpeciesProtocol>() : TuttiProtocols.toSpeciesProtocolMap(protocol);
        return new TaxonCache(false, persistenceService, protocolMap);
    }

    public static TaxonCache createSpeciesCache(TuttiPersistence persistenceService, TuttiProtocol protocol) {
        boolean noProtocol = protocol == null;
        Map<Integer, SpeciesProtocol> protocolMap = noProtocol ? new HashMap<Integer, SpeciesProtocol>() : TuttiProtocols.toSpeciesProtocolMap(protocol);
        return new TaxonCache(true, persistenceService, protocolMap);
    }

    public static TaxonCache createBenthosCacheWithoutVernacularCode(TuttiPersistence persistenceService, TuttiProtocol protocol) {
        boolean noProtocol = protocol == null;
        Map<Integer, SpeciesProtocol> protocolMap = noProtocol ? new HashMap<Integer, SpeciesProtocol>() : TuttiProtocols.toBenthosProtocolMap(protocol);
        return new TaxonCache(false, persistenceService, protocolMap);
    }

    public static TaxonCache createBenthosCache(TuttiPersistence persistenceService, TuttiProtocol protocol) {
        boolean noProtocol = protocol == null;
        Map<Integer, SpeciesProtocol> protocolMap = noProtocol ? new HashMap<Integer, SpeciesProtocol>() : TuttiProtocols.toBenthosProtocolMap(protocol);
        return new TaxonCache(true, persistenceService, protocolMap);
    }
}

