/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.measure.SortingMeasurement;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmId;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxonImpl;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.FishingOperationPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.CaracteristicPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.SpeciesPersistenceService;
import fr.ifremer.tutti.persistence.service.util.BatchPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.MeasurementPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.SynchronizationStatusHelper;
import fr.ifremer.tutti.persistence.service.util.tree.SpeciesBatchTreeHelperSupport;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.springframework.dao.DataIntegrityViolationException;

public abstract class SpeciesBatchPersistenceServiceSupport
extends AbstractPersistenceService {
    private static final Log log = LogFactory.getLog(SpeciesBatchPersistenceServiceSupport.class);
    @Resource(name="speciesPersistenceService")
    private SpeciesPersistenceService speciesService;
    @Resource(name="fishingOperationPersistenceService")
    private FishingOperationPersistenceService fishingOperationPersistenceService;
    @Resource(name="caracteristicPersistenceService")
    private CaracteristicPersistenceService caracteristicService;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;
    @Resource(name="measurementPersistenceHelper")
    protected MeasurementPersistenceHelper measurementPersistenceHelper;
    @Resource(name="synchronizationStatusHelper")
    private SynchronizationStatusHelper synchronizationStatusHelper;
    private final String prefix;
    private final Supplier<SpeciesBatch> batchFactory;
    private final Supplier<SpeciesBatchFrequency> frequencyFactory;

    protected SpeciesBatchPersistenceServiceSupport(String prefix, Supplier<SpeciesBatch> batchFactory, Supplier<SpeciesBatchFrequency> frequencyFactory) {
        this.prefix = prefix;
        this.batchFactory = batchFactory;
        this.frequencyFactory = frequencyFactory;
    }

    public Set<Integer> getBatchChildIds(Integer id) {
        return this.batchHelper.getBatchIds(id);
    }

    protected abstract SpeciesBatchTreeHelperSupport getBatchTreeHelper();

    protected abstract void validate(BatchPersistenceHelper var1, SampleCategoryModel var2, BatchContainer<SpeciesBatch> var3);

    protected final BatchContainer<SpeciesBatch> getRootSpeciesBatch0(Integer fishingOperationId, boolean validateTree) throws InvalidBatchModelException {
        SortingBatch horsVracSpeciesBatch;
        Objects.requireNonNull(fishingOperationId);
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyy");
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(fishingOperationId, false);
        SortingBatch vracSpeciesBatch = this.getBatchTreeHelper().getVracAliveItemizedRootBatch(catchBatch);
        BatchContainer<SpeciesBatch> result = new BatchContainer<SpeciesBatch>();
        SampleCategoryModel sampleCategoryModel = this.getSampleCategoryModel();
        if (vracSpeciesBatch != null) {
            result.setId(vracSpeciesBatch.getId());
            for (Batch batch : vracSpeciesBatch.getChildBatchs()) {
                Species species;
                SortingBatch source = (SortingBatch)batch;
                ReferenceTaxon referenceTaxon = source.getReferenceTaxon();
                Objects.requireNonNull(referenceTaxon, "Can't have a rootSpeciesBatch with a null taxon, but was for " + batch.getId());
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Loading CatchBatch Vrac > " + this.prefix + " > Alive Itemized > " + referenceTaxon.getId() + " - " + " (batch:" + source.getId() + ")"));
                }
                if ((species = this.speciesService.getSpeciesByReferenceTaxonId(referenceTaxon.getId())) == null) {
                    FishingOperation fishingOperation = this.fishingOperationPersistenceService.getFishingOperation(fishingOperationId);
                    String fishingOperationName = fishingOperation.getStationNumber() + " - " + fishingOperation.getFishingOperationNumber() + " - " + df.format(fishingOperation.getGearShootingStartDate());
                    throw new InvalidBatchModelException(I18n.t((String)"tutti.persistence.speciesBatch.validation.unkonwn.taxon", (Object[])new Object[]{fishingOperationName, source.getId(), referenceTaxon.getId()}));
                }
                SpeciesBatch target = this.batchFactory.get();
                target.setSpecies(species);
                this.entityToBean(sampleCategoryModel, source, target);
                result.addChildren(target);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Loaded CatchBatch Vrac > " + this.prefix + " > Alive Itemized > " + target.getSpecies().getReferenceTaxonId() + ": " + target.getId()));
            }
        }
        if ((horsVracSpeciesBatch = this.getBatchTreeHelper().getHorsVracRootBatch(catchBatch)) != null) {
            for (Batch batch : horsVracSpeciesBatch.getChildBatchs()) {
                Species species;
                SortingBatch source = (SortingBatch)batch;
                ReferenceTaxon referenceTaxon = source.getReferenceTaxon();
                Objects.requireNonNull(referenceTaxon, "Can't have a rootSpeciesBatch with a null taxon, but was for " + source.getId());
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Loading CatchBatch Hors Vrac > " + this.prefix + " > " + referenceTaxon.getId() + " - " + " (batch:" + source.getId() + ")"));
                }
                if ((species = this.speciesService.getSpeciesByReferenceTaxonId(referenceTaxon.getId())) == null) {
                    FishingOperation fishingOperation = this.fishingOperationPersistenceService.getFishingOperation(fishingOperationId);
                    String fishingOperationName = fishingOperation.getStationNumber() + " - " + fishingOperation.getFishingOperationNumber() + " - " + df.format(fishingOperation.getGearShootingStartDate());
                    throw new InvalidBatchModelException(I18n.t((String)"tutti.persistence.speciesBatch.validation.unkonwn.taxon", (Object[])new Object[]{fishingOperationName, source.getId(), referenceTaxon.getId()}));
                }
                SpeciesBatch target = this.batchFactory.get();
                target.setSpecies(species);
                this.entityToBean(sampleCategoryModel, source, target);
                result.addChildren(target);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Loaded CatchBatch Hors Vrac > " + this.prefix + " > " + target.getSpecies().getReferenceTaxonId() + ": " + target.getId()));
            }
        }
        if (validateTree) {
            this.validate(this.batchHelper, sampleCategoryModel, result);
        }
        return result;
    }

    protected SpeciesBatch createSpeciesBatch0(SpeciesBatch bean, Integer parentBatchId, boolean computeRankOrder) {
        Objects.requireNonNull(bean);
        Preconditions.checkArgument((boolean)TuttiEntities.isNew(bean));
        Objects.requireNonNull(bean.getSpecies());
        Objects.requireNonNull(bean.getSpecies().getId());
        Objects.requireNonNull(bean.getFishingOperation());
        Objects.requireNonNull(bean.getFishingOperation().getId());
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(bean.getFishingOperation().getIdAsInt(), false);
        return this.createSpeciesBatch0(bean, parentBatchId, catchBatch, computeRankOrder);
    }

    protected Collection<SpeciesBatch> createSpeciesBatches0(Integer fishingOperationId, Collection<SpeciesBatch> beans) {
        Objects.requireNonNull(beans);
        Objects.requireNonNull(fishingOperationId);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByFishingOperationId(fishingOperationId, false);
        ArrayList<SpeciesBatch> result = new ArrayList<SpeciesBatch>();
        for (SpeciesBatch bean : beans) {
            SpeciesBatch created = this.createSpeciesBatch0(bean, null, catchBatch, true);
            result.add(created);
        }
        return result;
    }

    protected SpeciesBatch createSpeciesBatch0(SpeciesBatch bean, Integer parentBatchId, CatchBatch catchBatch, boolean computeRankOrder) {
        Objects.requireNonNull(bean);
        Preconditions.checkArgument((boolean)TuttiEntities.isNew(bean));
        Objects.requireNonNull(bean.getSpecies());
        Objects.requireNonNull(bean.getSpecies().getId());
        Objects.requireNonNull(bean.getFishingOperation());
        Objects.requireNonNull(bean.getFishingOperation().getId());
        SortingBatch batch = SortingBatch.Factory.newInstance();
        this.beanToEntity0(bean, batch, parentBatchId, catchBatch, computeRankOrder);
        bean = this.batchHelper.createSortingBatch(bean, catchBatch, batch);
        return bean;
    }

    protected SpeciesBatch saveSpeciesBatch0(SpeciesBatch bean) {
        Objects.requireNonNull(bean);
        Preconditions.checkArgument((!TuttiEntities.isNew(bean) ? 1 : 0) != 0);
        Integer batchId = bean.getIdAsInt();
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(batchId);
        SortingBatch batch = this.batchHelper.getSortingBatchById(catchBatch, batchId);
        Integer parentBatchId = null;
        if (bean.getParentBatch() != null) {
            parentBatchId = bean.getParentBatch().getIdAsInt();
        }
        this.beanToEntity0(bean, batch, parentBatchId, catchBatch, true);
        this.batchHelper.updateSortingBatch(batch, catchBatch);
        return bean;
    }

    protected void deleteSpeciesBatch0(Integer id) {
        Objects.requireNonNull(id);
        this.batchHelper.deleteBatch(id);
    }

    protected void deleteSpeciesSubBatch0(Integer id) {
        Objects.requireNonNull(id);
        this.deleteSpeciesSubBatch(id);
    }

    protected void changeSpeciesBatchSpecies0(Integer id, Species species) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(species);
        Objects.requireNonNull(species.getReferenceTaxonId());
        this.changeBatchSpecies(id, species);
    }

    protected List<SpeciesBatch> getAllSpeciesBatchToConfirm0(Integer fishingOperationId) throws InvalidBatchModelException {
        ArrayList<SpeciesBatch> batchesToConfirm = new ArrayList<SpeciesBatch>();
        BatchContainer<SpeciesBatch> rootSpeciesBatch = this.getRootSpeciesBatch0(fishingOperationId, false);
        for (SpeciesBatch speciesBatch : rootSpeciesBatch.getChildren()) {
            this.findSpeciesBatchesToConfirm(speciesBatch, batchesToConfirm);
        }
        return batchesToConfirm;
    }

    private void findSpeciesBatchesToConfirm(SpeciesBatch speciesBatch, List<SpeciesBatch> batchesToConfirm) {
        if (speciesBatch.isSpeciesToConfirm()) {
            batchesToConfirm.add(speciesBatch);
        } else if (!speciesBatch.isChildBatchsEmpty()) {
            for (SpeciesBatch batch : speciesBatch.getChildBatchs()) {
                this.findSpeciesBatchesToConfirm(batch, batchesToConfirm);
            }
        }
    }

    protected List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency0(Integer speciesBatchId) {
        Objects.requireNonNull(speciesBatchId);
        List<SortingBatch> frequencyChilds = this.getFrequencies(speciesBatchId);
        ArrayList<SpeciesBatchFrequency> results = new ArrayList<SpeciesBatchFrequency>();
        for (SortingBatch child : frequencyChilds) {
            SpeciesBatchFrequency target = this.frequencyFactory.get();
            this.entityToBatchFrequency(child, target);
            results.add(target);
        }
        return Collections.unmodifiableList(results);
    }

    protected Multimap<Species, SpeciesBatchFrequency> getAllSpeciesBatchFrequencyForBatch0(BatchContainer<SpeciesBatch> batchContainer) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (SpeciesBatch speciesBatch : batchContainer.getChildren()) {
            this.getAllSpeciesBatchFrequencyForBatch(speciesBatch, (Multimap<Species, SpeciesBatchFrequency>)result);
        }
        return result;
    }

    private void getAllSpeciesBatchFrequencyForBatch(SpeciesBatch batch, Multimap<Species, SpeciesBatchFrequency> result) {
        List<SpeciesBatchFrequency> speciesBatchFrequency = this.getAllSpeciesBatchFrequency0(batch.getIdAsInt());
        result.putAll((Object)batch.getSpecies(), speciesBatchFrequency);
        if (!batch.isChildBatchsEmpty()) {
            for (SpeciesBatch child : batch.getChildBatchs()) {
                this.getAllSpeciesBatchFrequencyForBatch(child, result);
            }
        }
    }

    protected List<SpeciesBatchFrequency> saveSpeciesBatchFrequency0(Integer speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        Objects.requireNonNull(speciesBatchId);
        Objects.requireNonNull(frequencies);
        ArrayList<SpeciesBatchFrequency> notNullFrequencies = new ArrayList<SpeciesBatchFrequency>();
        String pmfmId = null;
        for (SpeciesBatchFrequency source : frequencies) {
            if (source.getLengthStepCaracteristic() == null) continue;
            if (pmfmId == null) {
                pmfmId = source.getLengthStepCaracteristic().getId();
            } else if (!pmfmId.equals(source.getLengthStepCaracteristic().getId())) {
                throw new DataIntegrityViolationException("Batch frequencies under one SpeciesBatch must have all the same lengthStepCaracteristic");
            }
            notNullFrequencies.add(source);
        }
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(speciesBatchId);
        if (catchBatch == null) {
            return notNullFrequencies;
        }
        this.synchronizationStatusHelper.setDirty(catchBatch);
        SortingBatch parentBatch = this.batchHelper.getSortingBatchById(catchBatch, speciesBatchId);
        ArrayList notUpdatedChildIds = new ArrayList();
        List<SortingBatch> frequencyChilds = this.getFrequencyChilds(parentBatch);
        notUpdatedChildIds.addAll(frequencyChilds.stream().map(Batch::getId).collect(Collectors.toList()));
        short rankOrder = 0;
        ArrayList<SortingBatch> batchsToUpdate = new ArrayList<SortingBatch>();
        for (SpeciesBatchFrequency source : notNullFrequencies) {
            SortingBatch target;
            rankOrder = (short)(rankOrder + 1);
            if (source.getId() == null) {
                target = SortingBatch.Factory.newInstance();
                this.beanToEntity0(source, target, parentBatch, rankOrder);
                this.batchHelper.createSortingBatch(source, catchBatch, target);
                source.setId(target.getId());
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Create frequency sortingBatch(" + rankOrder + "): " + target.getId()));
                continue;
            }
            target = this.batchHelper.loadSortingBatch(source.getIdAsInt(), catchBatch);
            this.beanToEntity0(source, target, parentBatch, rankOrder);
            batchsToUpdate.add(target);
            notUpdatedChildIds.remove(target.getId());
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Update frequency sortingBatch(" + rankOrder + "): " + target.getId()));
        }
        if (CollectionUtils.isNotEmpty(batchsToUpdate)) {
            this.batchHelper.updateSortingBatch(batchsToUpdate, catchBatch);
        }
        if (CollectionUtils.isNotEmpty(notUpdatedChildIds)) {
            for (Integer batchId : notUpdatedChildIds) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Remove obsolete frequency sortingBatch: " + batchId));
                }
                this.batchHelper.removeWithChildren(batchId, catchBatch);
            }
        }
        return Collections.unmodifiableList(notNullFrequencies);
    }

    protected void beanToEntity0(SpeciesBatch source, SortingBatch target, Integer parentBatchId, CatchBatch catchBatch, boolean computeRankOrder) {
        Integer pmfmId;
        Objects.requireNonNull(source.getFishingOperation());
        Objects.requireNonNull(source.getFishingOperation().getId());
        if (target.getId() == null || target.getRootBatch() == null || target.getParentBatch() != null && !target.getParentBatch().getId().equals(parentBatchId)) {
            this.getBatchTreeHelper().setBatchParents(source.getSampleCategoryId(), source.getSampleCategoryValue(), target, parentBatchId, catchBatch);
        }
        if (target.getRankOrder() == null) {
            short rankOrder;
            if (computeRankOrder) {
                rankOrder = 1;
                if (source.getParentBatch() != null && CollectionUtils.isNotEmpty(source.getParentBatch().getChildBatchs())) {
                    int maxRankOrder = 0;
                    for (SpeciesBatch batch : source.getParentBatch().getChildBatchs()) {
                        Integer r = batch.getRankOrder();
                        if (r == null || r <= maxRankOrder) continue;
                        maxRankOrder = r;
                    }
                    rankOrder = (short)(rankOrder + (short)maxRankOrder);
                } else {
                    rankOrder = this.batchHelper.computeRankOrder(target);
                }
            } else {
                Preconditions.checkState((source.getRankOrder() != null ? 1 : 0) != 0, (Object)("Not using computeRankOrder requires source rankOrder to be not null, but was on batch: " + source));
                rankOrder = (short)source.getRankOrder().intValue();
            }
            target.setRankOrder(Short.valueOf(rankOrder));
        }
        target.setSubgroupCount(Float.valueOf(1.0f));
        target.setIndividualCount(source.getNumber());
        target.setComments(source.getComment());
        target.setExhaustiveInventory(Boolean.valueOf(true));
        ReferenceTaxon referenceTaxon = source.getSpecies() == null || parentBatchId != null ? null : (ReferenceTaxon)this.load(ReferenceTaxonImpl.class, source.getSpecies().getReferenceTaxonId());
        target.setReferenceTaxon(referenceTaxon);
        String qualityFlag = source.isSpeciesToConfirm() ? QualityFlagCode.DOUBTFUL.getValue() : QualityFlagCode.NOTQUALIFIED.getValue();
        target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)qualityFlag)));
        Float weight = source.getWeight();
        Float sampleCategoryWeight = source.getSampleCategoryWeight();
        this.getBatchTreeHelper().setWeightAndSampleRatio(target, weight, sampleCategoryWeight);
        Collection sortingMeasurements = target.getSortingMeasurements();
        HashSet notChangedSortingMeasurements = Sets.newHashSet();
        if (sortingMeasurements != null) {
            notChangedSortingMeasurements.addAll(sortingMeasurements);
        }
        if (source.getSampleCategoryId() != null && source.getSampleCategoryValue() != null && !(pmfmId = source.getSampleCategoryId()).equals(PmfmId.SORTED_UNSORTED.getValue())) {
            SortingMeasurement sortingMeasurement = this.measurementPersistenceHelper.setSortingMeasurement(target, pmfmId, source.getSampleCategoryValue());
            notChangedSortingMeasurements.remove(sortingMeasurement);
        }
        if (sortingMeasurements != null) {
            sortingMeasurements.removeAll(notChangedSortingMeasurements);
        }
    }

    private void beanToEntity0(SpeciesBatchFrequency source, SortingBatch target, SortingBatch parentBatch, short rankOrder) {
        Preconditions.checkNotNull((Object)source.getBatch());
        Preconditions.checkNotNull((Object)source.getBatch().getId());
        if (target.getId() == null || target.getRootBatch() == null || target.getParentBatch() != null && !target.getParentBatch().getId().equals(parentBatch.getId())) {
            target.setParentBatch((Batch)parentBatch);
            target.setRootBatch(parentBatch.getRootBatch());
        }
        target.setRankOrder(Short.valueOf(rankOrder));
        target.setIndividualCount(source.getNumber());
        target.setReferenceTaxon(null);
        target.setQualityFlag(parentBatch.getQualityFlag());
        target.setExhaustiveInventory(Boolean.valueOf(true));
        this.getBatchTreeHelper().setWeightAndSampleRatio(target, source.getWeight(), null);
        Collection sortingMeasurements = target.getSortingMeasurements();
        HashSet notChangedSortingMeasurements = Sets.newHashSet();
        if (sortingMeasurements != null) {
            notChangedSortingMeasurements.addAll(sortingMeasurements);
        }
        if (source.getLengthStepCaracteristic() != null && source.getLengthStep() != null) {
            Integer pmfmId = source.getLengthStepCaracteristic().getIdAsInt();
            SortingMeasurement sortingMeasurement = this.measurementPersistenceHelper.setSortingMeasurement(target, pmfmId, source.getLengthStep());
            notChangedSortingMeasurements.remove(sortingMeasurement);
        }
        if (sortingMeasurements != null) {
            sortingMeasurements.removeAll(notChangedSortingMeasurements);
        }
    }

    private SpeciesBatch entityToBean(SampleCategoryModel sampleCategoryModel, SortingBatch source, SpeciesBatch target) {
        QualityFlag qualityFlag;
        SortingBatch childBatch;
        boolean isFrequency;
        boolean isFrequency2;
        Preconditions.checkNotNull((Object)target.getSpecies());
        target.setId(source.getId().toString());
        target.setRankOrder((int)source.getRankOrder());
        target.setNumber(source.getIndividualCount());
        if (source.getWeight() != null && source.getWeightBeforeSampling() == null) {
            target.setSampleCategoryWeight(source.getWeight());
        } else {
            target.setWeight(source.getWeight());
            target.setSampleCategoryWeight(source.getWeightBeforeSampling());
        }
        target.setComment(source.getComments());
        SortingMeasurement sm = null;
        if (source.getSortingMeasurements().size() == 1) {
            sm = (SortingMeasurement)source.getSortingMeasurements().iterator().next();
        } else if (source.getReferenceTaxon() != null && source.getReferenceTaxon().getId() != null) {
            sm = this.measurementPersistenceHelper.getInheritedSortingMeasurement(source);
        }
        if (sm != null && !(isFrequency2 = this.isFrequencyBatch(sampleCategoryModel, source))) {
            Object qualitativeId = null;
            if (sm.getQualitativeValue() != null) {
                qualitativeId = sm.getQualitativeValue().getId();
            }
            this.setSampleCategoryQualitative(target, sm.getPmfm().getId(), sm.getNumericalValue(), sm.getAlphanumericalValue(), (Integer)qualitativeId);
        }
        if (target.getSampleCategoryId() != null) {
            ArrayList targetChilds = Lists.newArrayList();
            for (Batch batch : source.getChildBatchs()) {
                SortingBatch sourceChild = (SortingBatch)batch;
                SpeciesBatch targetChild = SpeciesBatchs.newInstance(target);
                targetChild.setSpecies(target.getSpecies());
                this.entityToBean(sampleCategoryModel, sourceChild, targetChild);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loaded CatchBatch (Vrac|Hors Vrac) > Species > " + targetChild.getSpecies().getReferenceTaxonId() + " : " + target.getId()));
                }
                if (targetChild.getSampleCategoryValue() == null) continue;
                targetChilds.add(targetChild);
                targetChild.setParentBatch(target);
            }
            target.setChildBatchs(targetChilds);
        }
        if (CollectionUtils.isNotEmpty((Collection)source.getChildBatchs()) && target.getWeight() != null && !(isFrequency = this.isFrequencyBatch(sampleCategoryModel, childBatch = (SortingBatch)Iterables.get((Iterable)source.getChildBatchs(), (int)0)))) {
            target.setWeight(null);
        }
        target.setSpeciesToConfirm((qualityFlag = source.getQualityFlag()) != null && QualityFlagCode.DOUBTFUL.getValue().equals(qualityFlag.getCode()));
        return target;
    }

    private void setSampleCategoryQualitative(SpeciesBatch target, Integer pmfmId, Float numericalvalue, String alphanumericalValue, Integer qualitativeValueId) {
        if (pmfmId == null || pmfmId.equals(SpeciesBatchTreeHelperSupport.SORTING_TYPE_ID)) {
            return;
        }
        SampleCategoryModel sampleCategoryModel = this.getSampleCategoryModel();
        boolean isSamplingCategory = sampleCategoryModel.containsCategoryId(pmfmId);
        Preconditions.checkNotNull((Object)isSamplingCategory, (Object)("Unable to find corresponding SampleCategoryEnum for PMFM.ID : " + pmfmId));
        target.setSampleCategoryId(pmfmId);
        Serializable categoryValue = this.getSampleCategoryQualitative(pmfmId, numericalvalue, alphanumericalValue, qualitativeValueId);
        target.setSampleCategoryValue(categoryValue);
    }

    private boolean isFrequencyBatch(SampleCategoryModel sampleCategoryModel, SortingBatch sortingBatch) {
        boolean result = false;
        if (sortingBatch.getSortingMeasurements().size() == 1) {
            SortingMeasurement sm = (SortingMeasurement)sortingBatch.getSortingMeasurements().iterator().next();
            Pmfm pmfm = sm.getPmfm();
            result = sortingBatch.getIndividualCount() != null && !sampleCategoryModel.containsCategoryId(pmfm.getId());
        }
        return result;
    }

    private Serializable getSampleCategoryQualitative(Integer pmfmId, Float numericalvalue, String alphanumericalValue, Integer qualitativeValueId) {
        if (numericalvalue != null) {
            return numericalvalue;
        }
        if (alphanumericalValue != null) {
            return alphanumericalValue;
        }
        Caracteristic caracteristic = this.caracteristicService.getCaracteristic(pmfmId);
        if (caracteristic == null || caracteristic.getCaracteristicType() != CaracteristicType.QUALITATIVE) {
            return null;
        }
        CaracteristicQualitativeValue value = null;
        for (CaracteristicQualitativeValue qv : caracteristic.getQualitativeValue()) {
            if (!qualitativeValueId.equals(qv.getIdAsInt())) continue;
            value = qv;
            break;
        }
        return value;
    }

    private void entityToBatchFrequency(SortingBatch source, SpeciesBatchFrequency target) {
        target.setId(source.getId());
        target.setRankOrder((int)source.getRankOrder());
        target.setNumber(source.getIndividualCount());
        target.setWeight(source.getWeight());
        Preconditions.checkState((source.getSortingMeasurements().size() == 1 ? 1 : 0) != 0, (Object)("SortingBatch [" + source.getId() + "] need exactly one sortingMeasurement (to store the length step category), but had " + source.getSortingMeasurements().size()));
        SortingMeasurement sm = (SortingMeasurement)source.getSortingMeasurements().iterator().next();
        Preconditions.checkNotNull((Object)sm.getPmfm(), (Object)("SortingMeasurement [" + sm.getId() + "] can not have a null pmfm"));
        Preconditions.checkNotNull((Object)sm.getPmfm().getId(), (Object)("SortingMeasurement [" + sm.getId() + "] can not have a pmfm with null id"));
        Caracteristic lengthStepCaracteristic = this.caracteristicService.getCaracteristic(sm.getPmfm().getId());
        target.setLengthStepCaracteristic(lengthStepCaracteristic);
        target.setLengthStep(sm.getNumericalValue());
    }

    private List<SortingBatch> getFrequencyChilds(SortingBatch sortingBatch) {
        ArrayList result = Lists.newArrayList();
        SampleCategoryModel sampleCategoryModel = this.getSampleCategoryModel();
        for (Batch batch : sortingBatch.getChildBatchs()) {
            SortingBatch child = (SortingBatch)batch;
            if (!this.isFrequencyBatch(sampleCategoryModel, child)) continue;
            result.add(child);
        }
        return result;
    }

    private List<SortingBatch> getFrequencies(Integer batchId) {
        Preconditions.checkNotNull((Object)batchId);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(batchId);
        SortingBatch sortingBatch = this.batchHelper.getSortingBatchById(catchBatch, batchId);
        return this.getFrequencyChilds(sortingBatch);
    }

    private void deleteSpeciesSubBatch(Integer speciesBatchId) {
        Preconditions.checkNotNull((Object)speciesBatchId);
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(speciesBatchId);
        this.synchronizationStatusHelper.setDirty(catchBatch);
        SortingBatch sortingBatch = this.batchHelper.getSortingBatchById(catchBatch, speciesBatchId);
        Collection childBatchs = sortingBatch.getChildBatchs();
        if (CollectionUtils.isNotEmpty((Collection)childBatchs)) {
            for (Batch childBatch : childBatchs) {
                Integer childBatchId = childBatch.getId();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Delete child [" + childBatchId + "] of species batch: " + speciesBatchId));
                }
                this.batchHelper.removeWithChildren(childBatchId);
            }
        }
    }

    private void changeBatchSpecies(Integer batchId, Species species) {
        Preconditions.checkNotNull((Object)batchId);
        Preconditions.checkNotNull((Object)species);
        Preconditions.checkNotNull((Object)species.getReferenceTaxonId());
        CatchBatch catchBatch = this.batchHelper.getRootCatchBatchByBatchId(batchId);
        this.synchronizationStatusHelper.setDirty(catchBatch);
        this.batchHelper.setSortingBatchReferenceTaxon(batchId, species);
    }
}

