/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.service.genericformat.GenericFormatArchiveInvalidLayoutException;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationIOUtil;
import org.nuiton.jaxx.application.ApplicationTechnicalException;
import org.nuiton.util.ZipUtil;

public class GenericFormatArchive
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GenericFormatArchive.class);
    private final File archiveFile;
    private final File workingDirectory;
    private final ArchiveMode archiveMode;
    private final EnumMap<ArchiveFilePath, Integer> countLines;
    private final EnumSet<ArchiveFilePath> missingPaths;

    public static GenericFormatArchive forImport(File archiveFile, File tempDirectory) {
        try {
            File workingDirectory = Files.createTempDirectory(tempDirectory.toPath(), "genericImport", new FileAttribute[0]).toFile();
            return new GenericFormatArchive(ArchiveMode.IMPORT, archiveFile, workingDirectory);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not create generic format import archive", (Throwable)e);
        }
    }

    public static GenericFormatArchive forExport(File archiveFile, File tempDirectory) {
        try {
            File workingDirectory = Files.createTempDirectory(tempDirectory.toPath(), "genericExport", new FileAttribute[0]).toFile();
            return new GenericFormatArchive(ArchiveMode.EXPORT, archiveFile, workingDirectory);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not create generic format export archive", (Throwable)e);
        }
    }

    public static GenericFormatArchive forExportFromWorkingDirectory(File archiveFile, File workingDirectory) {
        return new GenericFormatArchive(ArchiveMode.EXPORT, archiveFile, workingDirectory);
    }

    public File getWorkingDirectoryPath() {
        return this.workingDirectory;
    }

    public Path getSampleCategoryModelPath() {
        return this.getPath(ArchiveFilePath.SAMPLE_CATEGORY);
    }

    public Path getAttachmentFilePath() {
        return this.getPath(ArchiveFilePath.DATA_ATTACHMENTS);
    }

    public Path getAttachmentDataPath() {
        return this.workingDirectory.toPath().resolve("meas_files");
    }

    public boolean isProtocolExists() {
        return Files.exists(this.getProtocolPath(), new LinkOption[0]);
    }

    public boolean isTemporaryReferentialGearsPathExists() {
        return Files.exists(this.getTemporaryReferentialGearsPath(), new LinkOption[0]);
    }

    public boolean isTemporaryReferentialPersonsPathExists() {
        return Files.exists(this.getTemporaryReferentialPersonsPath(), new LinkOption[0]);
    }

    public boolean isTemporaryReferentialSpeciesPathExists() {
        return Files.exists(this.getTemporaryReferentialSpeciesPath(), new LinkOption[0]);
    }

    public boolean isTemporaryReferentialVesselsPathExists() {
        return Files.exists(this.getTemporaryReferentialVesselsPath(), new LinkOption[0]);
    }

    public Path getProtocolPath() {
        return this.getPath(ArchiveFilePath.PROTOCOL);
    }

    public Path getTemporaryReferentialGearsPath() {
        return this.getPath(ArchiveFilePath.REFERENTIAL_GEAR);
    }

    public Path getTemporaryReferentialPersonsPath() {
        return this.getPath(ArchiveFilePath.REFERENTIAL_PERSON);
    }

    public Path getTemporaryReferentialSpeciesPath() {
        return this.getPath(ArchiveFilePath.REFERENTIAL_SPECIES);
    }

    public Path getTemporaryReferentialVesselsPath() {
        return this.getPath(ArchiveFilePath.REFERENTIAL_VESSEL);
    }

    public Path getSurveyPath() {
        return this.getPath(ArchiveFilePath.DATA_SURVEY);
    }

    public Path getGearCaracteristicsPath() {
        return this.getPath(ArchiveFilePath.DATA_GEAR_CARACTERISTIC);
    }

    public Path getOperationPath() {
        return this.getPath(ArchiveFilePath.DATA_OPERATION);
    }

    public Path getIndividualObservationPath() {
        return this.getPath(ArchiveFilePath.DATA_INDIVIDUAL_OBSERVATION);
    }

    public Path getSpeciesPath() {
        return this.getPath(ArchiveFilePath.DATA_SPECIES);
    }

    public Path getCatchPath() {
        return this.getPath(ArchiveFilePath.DATA_CATCH);
    }

    public Path getAccidentalCatchPath() {
        return this.getPath(ArchiveFilePath.DATA_ACCIDENTAL_CATCH);
    }

    public Path getParameterPath() {
        return this.getPath(ArchiveFilePath.DATA_PARAMETER);
    }

    public Path getMarineLitterPath() {
        return this.getPath(ArchiveFilePath.DATA_MARINE_LITTER);
    }

    public int getSampleCategoryLineCount() {
        return this.countImportLines(ArchiveFilePath.SAMPLE_CATEGORY);
    }

    public int getSurveyLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_SURVEY);
    }

    public int getGearCaracteristicsPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_GEAR_CARACTERISTIC);
    }

    public int getOperationPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_OPERATION);
    }

    public int getIndividualObservationPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_INDIVIDUAL_OBSERVATION);
    }

    public int getSpeciesPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_SPECIES);
    }

    public int getCatchPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_CATCH);
    }

    public int getAccidentalCatchPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_ACCIDENTAL_CATCH);
    }

    public int getAttachemntsPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_ATTACHMENTS);
    }

    public int getParameterPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_PARAMETER);
    }

    public int getMarineLitterPathLineCount() {
        return this.countImportLines(ArchiveFilePath.DATA_MARINE_LITTER);
    }

    public int getTemporaryReferentialGearLineCount() {
        return this.countImportLines(ArchiveFilePath.REFERENTIAL_GEAR);
    }

    public int getTemporaryReferentialPersonLineCount() {
        return this.countImportLines(ArchiveFilePath.REFERENTIAL_PERSON);
    }

    public int getTemporaryReferentialSpeciesLineCount() {
        return this.countImportLines(ArchiveFilePath.REFERENTIAL_SPECIES);
    }

    public int getTemporaryReferentialVesselLineCount() {
        return this.countImportLines(ArchiveFilePath.REFERENTIAL_VESSEL);
    }

    public void validateArchiveLayout() throws GenericFormatArchiveInvalidLayoutException {
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        for (ArchiveFilePath archiveFilePath : ArchiveFilePath.values()) {
            if (!archiveFilePath.isMandatory() || !this.missingPaths.contains((Object)archiveFilePath)) continue;
            if (log.isErrorEnabled()) {
                log.error((Object)("Mandatory entry " + archiveFilePath.getFilename() + " not found."));
            }
            errors.add(I18n.t((String)"tutti.service.genericFormat.importError.missArchiveFile", (Object[])new Object[]{archiveFilePath.getFilename()}));
        }
        if (!errors.isEmpty()) {
            throw new GenericFormatArchiveInvalidLayoutException(this, errors);
        }
    }

    public void createZip(ProgressionModel progressionModel) {
        if (progressionModel != null) {
            progressionModel.increments(I18n.t((String)"tutti.service.genericFormat.export.buildZip", (Object[])new Object[]{this.archiveFile}));
        }
        ApplicationIOUtil.zip((File)this.workingDirectory, (File)this.archiveFile, (String)I18n.t((String)"tutti.service.genericFormat.export.zip.error", (Object[])new Object[]{this.archiveFile}));
    }

    public File extractAttachment(String path) {
        Path resolve = this.getAttachmentDataPath().resolve(path);
        return resolve.toFile();
    }

    protected GenericFormatArchive(ArchiveMode archiveMode, File archiveFile, File workingDirectory) {
        this.archiveFile = archiveFile;
        this.archiveMode = archiveMode;
        this.countLines = new EnumMap(ArchiveFilePath.class);
        if (log.isInfoEnabled()) {
            log.info((Object)("Archive zip file: " + archiveFile));
            log.info((Object)("Archive working directory: " + workingDirectory));
            log.info((Object)("Archive mode: " + (Object)((Object)archiveMode)));
        }
        if (this.isImport()) {
            this.workingDirectory = this.extractArchive(archiveFile, workingDirectory);
            this.missingPaths = this.computeMissingPaths();
        } else {
            this.workingDirectory = workingDirectory;
            this.missingPaths = null;
        }
    }

    protected File extractArchive(File archiveFile, File workingDirectory) {
        try {
            ZipUtil.uncompress((File)archiveFile, (File)workingDirectory);
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not explode zipfile " + archiveFile, (Throwable)e);
        }
        File[] files = workingDirectory.listFiles();
        if (files == null || files.length != 1) {
            throw new ApplicationTechnicalException("Archive should contains onyl one directory");
        }
        return files[0];
    }

    protected boolean isImport() {
        return ArchiveMode.IMPORT == this.archiveMode;
    }

    protected boolean isExport() {
        return ArchiveMode.EXPORT == this.archiveMode;
    }

    protected Path getPath(ArchiveFilePath archiveFilePath) {
        String filename = archiveFilePath.getFilename();
        return this.workingDirectory.toPath().resolve(filename);
    }

    protected EnumSet<ArchiveFilePath> computeMissingPaths() {
        EnumSet<ArchiveFilePath> result = EnumSet.noneOf(ArchiveFilePath.class);
        for (ArchiveFilePath archiveFilePath : ArchiveFilePath.values()) {
            Path path = this.getPath(archiveFilePath);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Check if entry " + (Object)((Object)archiveFilePath) + " exists."));
            }
            if (!Files.exists(path, new LinkOption[0])) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Entry " + (Object)((Object)archiveFilePath) + " not found."));
                }
                result.add(archiveFilePath);
                continue;
            }
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Entry " + (Object)((Object)archiveFilePath) + " found."));
        }
        return result;
    }

    protected int countImportLines(ArchiveFilePath archiveFilePath) {
        Integer result = this.countLines.get((Object)archiveFilePath);
        if (result == null) {
            Path path = this.getPath(archiveFilePath);
            if (path == null) {
                result = 0;
                this.countLines.put(archiveFilePath, 0);
            } else {
                int nbLines = GenericFormatArchive.countLines(path);
                result = nbLines - 1;
                this.countLines.put(archiveFilePath, result);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static int countLines(Path path) {
        try (LineNumberReader reader = new LineNumberReader(Files.newBufferedReader(path, Charset.forName("UTF-8")));){
            String line;
            String lastLine = null;
            while ((line = reader.readLine()) != null) {
                lastLine = line;
            }
            int cnt = reader.getLineNumber();
            if (lastLine != null && lastLine.trim().isEmpty()) {
                --cnt;
            }
            int n = cnt;
            return n;
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException("Could not read file " + path.toFile().getName(), (Throwable)e);
        }
    }

    private static enum ArchiveFilePath {
        PROTOCOL(false, "protocol.tuttiProtocol"),
        REFERENTIAL_GEAR(false, "temporaryGears.csv"),
        REFERENTIAL_PERSON(false, "temporaryPersons.csv"),
        REFERENTIAL_SPECIES(false, "temporarySpecies.csv"),
        REFERENTIAL_VESSEL(false, "temporaryVessels.csv"),
        SAMPLE_CATEGORY(true, "sampleCategory.csv"),
        DATA_SURVEY(true, "survey.csv"),
        DATA_GEAR_CARACTERISTIC(true, "gearCaracteristics.csv"),
        DATA_OPERATION(true, "operation.csv"),
        DATA_PARAMETER(true, "parameter.csv"),
        DATA_CATCH(true, "catch.csv"),
        DATA_SPECIES(false, "species.csv"),
        DATA_MARINE_LITTER(true, "marineLitter.csv"),
        DATA_ACCIDENTAL_CATCH(true, "accidentalCatch.csv"),
        DATA_INDIVIDUAL_OBSERVATION(true, "individualObservation.csv"),
        DATA_ATTACHMENTS(true, "attachments.csv");

        private final boolean mandatory;
        private final String filename;

        private ArchiveFilePath(boolean mandatory, String filename) {
            this.mandatory = mandatory;
            this.filename = filename;
        }

        public boolean isMandatory() {
            return this.mandatory;
        }

        public String getFilename() {
            return this.filename;
        }
    }

    private static enum ArchiveMode {
        IMPORT,
        EXPORT;

    }
}

