/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.toc;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;
import org.eclipse.birt.report.engine.toc.EmptyTOCView;
import org.eclipse.birt.report.engine.toc.ITreeNode;
import org.eclipse.birt.report.engine.toc.TOCComparator;
import org.eclipse.birt.report.engine.toc.TOCFormatUtil;
import org.eclipse.birt.report.engine.toc.TOCStyleUtil;
import org.eclipse.birt.report.engine.toc.ViewFilter;
import org.eclipse.birt.report.engine.toc.ViewNode;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class TOCView
implements ITOCTree {
    protected static final Logger logger = Logger.getLogger(TOCView.class.getName());
    public static final ITOCTree EMPTY_TOC_VIEW = new EmptyTOCView();
    private ViewNode root;
    private ULocale locale;
    private TimeZone timeZone;
    private TOCStyleUtil styleUtil;
    private TOCFormatUtil formatUtil;
    private String format;
    private ViewFilter filter;

    public TOCView(ITreeNode tree, ReportDesignHandle handle, ULocale locale, TimeZone timeZone, String format) {
        this(tree, handle, locale, timeZone, format, null);
    }

    public TOCView(ITreeNode tree, ReportDesignHandle handle, ULocale locale, TimeZone timeZone) {
        this(tree, handle, locale, timeZone, null, null);
    }

    public TOCView(ITreeNode tree, ULocale locale, TimeZone timeZone) {
        this(tree, null, locale, timeZone, null, null);
    }

    public TOCView(ITreeNode tree, ReportDesignHandle handle, ULocale locale, TimeZone timeZone, String format, ViewFilter filter) {
        this.format = "viewer".equals(format) ? "html" : format;
        this.filter = filter;
        this.locale = locale;
        this.timeZone = timeZone;
        this.formatUtil = new TOCFormatUtil(locale, timeZone);
        if (handle != null) {
            this.styleUtil = new TOCStyleUtil(handle);
        }
        this.root = new ViewNode(this, null, tree);
    }

    @Override
    public TOCNode getRoot() {
        return this.root;
    }

    @Override
    public TOCNode findTOC(String tocNodeId) {
        if (tocNodeId == null || tocNodeId.equals("/")) {
            return this.root;
        }
        return this.findTOC(this.root, tocNodeId, new TOCComparator());
    }

    protected TOCNode findTOC(TOCNode node, String tocNodeId, TOCComparator comparator) {
        List children = node.getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        int i = 0;
        while (i < children.size()) {
            TOCNode child = (TOCNode)children.get(i);
            int result = comparator.compare(child.getNodeID(), tocNodeId);
            if (result == 0) {
                return child;
            }
            if (result > 0) {
                if (i > 0) {
                    TOCNode prevNode = (TOCNode)children.get(i - 1);
                    return this.findTOC(prevNode, tocNodeId, comparator);
                }
                return null;
            }
            ++i;
        }
        TOCNode lastChild = (TOCNode)children.get(children.size() - 1);
        return this.findTOC(lastChild, tocNodeId, comparator);
    }

    @Override
    public List<ViewNode> findTOCByValue(Object tocValue) {
        if (tocValue == null) {
            return null;
        }
        ArrayList<ViewNode> results = new ArrayList<ViewNode>();
        this.doSearch(results, this.root, new SearchKey(tocValue));
        if (!results.isEmpty()) {
            return results;
        }
        return null;
    }

    private void doSearch(Collection<ViewNode> results, ViewNode node, SearchKey key) {
        if (this.compareTocValue(node, key)) {
            results.add(node);
        }
        List children = node.getChildren();
        for (ViewNode child : children) {
            this.doSearch(results, child, key);
        }
    }

    private boolean compareTocValue(ViewNode node, SearchKey key) {
        String label = node.getDisplayString();
        if (label != null && label.equals(key.stringValue)) {
            return true;
        }
        Object value = node.getTOCValue();
        if (value == null) {
            return value == key.tocValue;
        }
        if (value instanceof Number) {
            if (key.numberValue != null) {
                return value.equals(key.numberValue);
            }
            return false;
        }
        if (value instanceof Date) {
            if (key.dateValue != null) {
                return value.equals(key.dateValue);
            }
            return false;
        }
        if (value instanceof String && key.stringValue != null) {
            return value.equals(key.stringValue);
        }
        return value.equals(key.tocValue);
    }

    protected String localizeValue(Object value, IScriptStyle style) {
        return this.formatUtil.localizeValue(value, style);
    }

    protected IScriptStyle getTOCStyle(int level, long elementId) {
        if (this.styleUtil != null) {
            try {
                return this.styleUtil.getTOCStyle(level, elementId);
            }
            catch (ScriptException se) {
                logger.log(Level.WARNING, se.getMessage(), se);
            }
        }
        return null;
    }

    protected boolean isHidden(ITreeNode node) {
        String[] fmts;
        String formats = node.getHiddenFormats();
        if (formats == null || this.format == null) {
            return false;
        }
        if (formats.equals("all")) {
            return true;
        }
        String[] stringArray = fmts = formats.split(",");
        int n = fmts.length;
        int n2 = 0;
        while (n2 < n) {
            String fmt = stringArray[n2];
            if (this.format.equalsIgnoreCase(fmt)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean isVisible(ITreeNode node) {
        if (this.filter != null) {
            return this.filter.isVisible(node);
        }
        return true;
    }

    private class SearchKey {
        Object tocValue;
        String stringValue;
        Number numberValue;
        Date dateValue;

        SearchKey(Object value) {
            this.tocValue = value;
            if (value instanceof String) {
                this.stringValue = (String)value;
                try {
                    this.numberValue = DataTypeUtil.toDouble(value);
                }
                catch (BirtException birtException) {}
                try {
                    this.dateValue = DataTypeUtil.toDate(this.stringValue, TOCView.this.locale, TOCView.this.timeZone);
                }
                catch (BirtException birtException) {}
            }
            if (value instanceof Number) {
                this.numberValue = (Number)value;
            }
            if (value instanceof Date) {
                this.dateValue = (Date)value;
            }
        }
    }
}

