/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.program;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUI;
import fr.ifremer.tutti.ui.swing.content.program.EditProgramUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import javax.swing.JComponent;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.util.CloseableUI;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditProgramUIHandler
extends AbstractTuttiUIHandler<EditProgramUIModel, EditProgramUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(EditProgramUIHandler.class);

    public static String getTitle(boolean exist) {
        String result = exist ? I18n.t((String)"tutti.editProgram.title.edit.program", (Object[])new Object[0]) : I18n.t((String)"tutti.editProgram.title.create.program", (Object[])new Object[0]);
        return result;
    }

    public void beforeInit(EditProgramUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.getDataContext().resetValidationDataContext();
        EditProgramUIModel model = new EditProgramUIModel();
        String programId = this.getContext().getProgramId();
        if (programId == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Edit new program");
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Edit existing program " + programId));
            }
            Program program = this.getPersistenceService().getProgram(programId);
            model.fromBean(program);
        }
        this.listModelIsModify(model);
        ui.setContextValue(model);
    }

    public void afterInit(EditProgramUI ui) {
        this.initUI(ui);
        EditProgramUIModel model = (EditProgramUIModel)((Object)this.getModel());
        this.initBeanFilterableComboBox(ui.getZoneComboBox(), Lists.newArrayList((Iterable)this.getPersistenceService().getAllProgramZone()), model.getZone());
        SwingValidator<EditProgramUIModel> validator = ui.getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        this.registerValidators(validator);
        model.setModify(model.isCreate());
        JAXXUtil.applyDataBinding((JAXXObject)ui, (String[])new String[]{"resetButton.enabled"});
    }

    protected JComponent getComponentToFocus() {
        return ((EditProgramUI)this.getUI()).getNameField();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    public boolean quitUI() {
        boolean result = this.quitScreen(((EditProgramUIModel)((Object)this.getModel())).isValid(), ((EditProgramUIModel)((Object)this.getModel())).isModify(), I18n.t((String)"tutti.editProgram.askCancelEditBeforeLeaving.cancelSaveProgram", (Object[])new Object[0]), I18n.t((String)"tutti.editProgram.askSaveBeforeLeaving.saveProgram", (Object[])new Object[0]), ((EditProgramUI)this.ui).getSaveButton().getAction());
        return result;
    }

    public SwingValidator<EditProgramUIModel> getValidator() {
        return ((EditProgramUI)this.ui).getValidator();
    }

    public void reloadProgram(Program program) {
        EditProgramUIModel model = (EditProgramUIModel)((Object)this.getModel());
        model.fromEntity(program);
        ((EditProgramUIModel)((Object)this.getModel())).setModify(false);
    }
}

