/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.table.filter;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.table.filter.FilterChangeListener;
import jaxx.runtime.swing.table.filter.FilterTableHeaderRenderer;
import jaxx.runtime.swing.table.filter.TableFilter;
import jaxx.runtime.swing.table.filter.TableFilterColumnPopup;
import org.nuiton.decorator.Decorator;

public final class TableRowFilterSupport {
    private boolean searchable = false;
    private Decorator<Object> decorator;
    private final TableFilter<?> filter;
    private boolean actionsVisible = true;
    private boolean useTableRenderers = false;

    private TableRowFilterSupport(TableFilter<?> filter) {
        if (filter == null) {
            throw new NullPointerException();
        }
        this.filter = filter;
    }

    public static TableRowFilterSupport forFilter(TableFilter<?> filter) {
        return new TableRowFilterSupport(filter);
    }

    public TableRowFilterSupport actions(boolean visible) {
        this.actionsVisible = visible;
        return this;
    }

    public TableRowFilterSupport searchable(boolean searchable) {
        this.searchable = searchable;
        return this;
    }

    public TableRowFilterSupport searchDecorator(Decorator<Object> decorator) {
        this.decorator = decorator;
        return this;
    }

    public TableRowFilterSupport useTableRenderers(boolean value) {
        this.useTableRenderers = value;
        return this;
    }

    public JTable apply() {
        TableFilterColumnPopup filterPopup = new TableFilterColumnPopup(this.filter);
        filterPopup.setEnabled(true);
        filterPopup.setActionsVisible(this.actionsVisible);
        filterPopup.setSearchable(this.searchable);
        filterPopup.searchDecorator(this.decorator);
        filterPopup.setUseTableRenderers(this.useTableRenderers);
        this.setupTableHeader();
        return this.filter.getTable();
    }

    private void setupTableHeader() {
        Object table = this.filter.getTable();
        this.filter.addChangeListener(new FilterChangeListener((JTable)table){
            final /* synthetic */ JTable val$table;
            {
                this.val$table = jTable;
            }

            @Override
            public void filterChanged(TableFilter<?> filter) {
                this.val$table.getTableHeader().repaint();
            }
        });
        this.setupHeaderRenderers(((JTable)table).getModel(), true);
    }

    private void setupHeaderRenderers(TableModel newModel, boolean fullSetup) {
        Object table = this.filter.getTable();
        FilterTableHeaderRenderer headerRenderer = new FilterTableHeaderRenderer(this.filter);
        this.filter.modelChanged(newModel);
        for (TableColumn c : Collections.list(((JTable)table).getColumnModel().getColumns())) {
            c.setHeaderRenderer(headerRenderer);
        }
        if (!fullSetup) {
            return;
        }
        ((Container)table).addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                TableRowFilterSupport.this.setupHeaderRenderers((TableModel)e.getNewValue(), false);
            }
        });
    }
}

