/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.dom.AreaStyle;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.w3c.dom.css.CSSValue;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.FontManager;
import uk.co.spudsoft.birt.emitters.excel.StyleManagerUtils;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;

public class StyleManagerHUtils
extends StyleManagerUtils {
    private short paletteIndex = (short)64;
    private static short minPaletteIndex = (short)40;
    private static StyleManagerUtils.Factory factory = new StyleManagerUtils.Factory(){

        @Override
        public StyleManagerUtils create(Logger log) {
            return new StyleManagerHUtils(log);
        }
    };

    public static StyleManagerUtils.Factory getFactory() {
        return factory;
    }

    public StyleManagerHUtils(Logger log) {
        super(log);
    }

    @Override
    public RichTextString createRichTextString(String value) {
        return new HSSFRichTextString(value);
    }

    private short poiBorderStyleFromBirt(String birtBorder, String width) {
        if ("none".equals(birtBorder)) {
            return 0;
        }
        DimensionType dim = DimensionType.parserUnit(width);
        double pxWidth = 3.0;
        if (dim != null && "px".equals(dim.getUnits())) {
            pxWidth = dim.getMeasure();
        }
        if ("solid".equals(birtBorder)) {
            if (pxWidth < 2.9) {
                return 1;
            }
            if (pxWidth < 3.1) {
                return 2;
            }
            return 5;
        }
        if ("dashed".equals(birtBorder)) {
            if (pxWidth < 2.9) {
                return 3;
            }
            return 8;
        }
        if ("dotted".equals(birtBorder)) {
            return 7;
        }
        if ("double".equals(birtBorder)) {
            return 6;
        }
        if ("none".equals(birtBorder)) {
            return 0;
        }
        this.log.debug("Border style \"", birtBorder, "\" is not recognised");
        return 0;
    }

    private short getHColour(HSSFWorkbook workbook, String colour) {
        int[] rgbInt = ColorUtil.getRGBs(colour);
        if (rgbInt == null) {
            return 0;
        }
        byte[] rgbByte = new byte[]{(byte)rgbInt[0], (byte)rgbInt[1], (byte)rgbInt[2]};
        HSSFPalette palette = workbook.getCustomPalette();
        HSSFColor result = palette.findColor(rgbByte[0], rgbByte[1], rgbByte[2]);
        if (result == null) {
            if (this.paletteIndex > minPaletteIndex) {
                this.paletteIndex = (short)(this.paletteIndex - 1);
                palette.setColorAtIndex(this.paletteIndex, rgbByte[0], rgbByte[1], rgbByte[2]);
                return this.paletteIndex;
            }
            result = palette.findSimilarColor(rgbByte[0], rgbByte[1], rgbByte[2]);
        }
        return result.getIndex();
    }

    @Override
    public void applyBorderStyle(Workbook workbook, CellStyle style, XSSFCellBorder.BorderSide side, CSSValue colour, CSSValue borderStyle, CSSValue width) {
        if (colour != null || borderStyle != null || width != null) {
            String widthString;
            String colourString = colour == null ? "rgb(0,0,0)" : colour.getCssText();
            String borderStyleString = borderStyle == null ? "solid" : borderStyle.getCssText();
            String string = widthString = width == null ? "medium" : width.getCssText();
            if (style instanceof HSSFCellStyle) {
                HSSFCellStyle hStyle = (HSSFCellStyle)style;
                short hBorderStyle = this.poiBorderStyleFromBirt(borderStyleString, widthString);
                short colourIndex = this.getHColour((HSSFWorkbook)workbook, colourString);
                if (colourIndex > 0 && hBorderStyle != 0) {
                    switch (side) {
                        case TOP: {
                            hStyle.setBorderTop(hBorderStyle);
                            hStyle.setTopBorderColor(colourIndex);
                            break;
                        }
                        case LEFT: {
                            hStyle.setBorderLeft(hBorderStyle);
                            hStyle.setLeftBorderColor(colourIndex);
                            break;
                        }
                        case RIGHT: {
                            hStyle.setBorderRight(hBorderStyle);
                            hStyle.setRightBorderColor(colourIndex);
                            break;
                        }
                        case BOTTOM: {
                            hStyle.setBorderBottom(hBorderStyle);
                            hStyle.setBottomBorderColor(colourIndex);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void addColourToFont(Workbook workbook, Font font, String colour) {
        if (colour == null) {
            return;
        }
        if (IStyle.TRANSPARENT_VALUE.equals(colour)) {
            return;
        }
        if (font instanceof HSSFFont) {
            HSSFFont hFont = (HSSFFont)font;
            short colourIndex = this.getHColour((HSSFWorkbook)workbook, colour);
            if (colourIndex > 0) {
                hFont.setColor(colourIndex);
            }
        }
    }

    @Override
    public void addBackgroundColourToStyle(Workbook workbook, CellStyle style, String colour) {
        if (colour == null) {
            return;
        }
        if (IStyle.TRANSPARENT_VALUE.equals(colour)) {
            return;
        }
        if (style instanceof HSSFCellStyle) {
            HSSFCellStyle cellStyle = (HSSFCellStyle)style;
            short colourIndex = this.getHColour((HSSFWorkbook)workbook, colour);
            if (colourIndex > 0) {
                cellStyle.setFillForegroundColor(colourIndex);
                cellStyle.setFillPattern((short)1);
            }
        }
    }

    @Override
    public Font correctFontColorIfBackground(FontManager fm, Workbook wb, BirtStyle birtStyle, Font font) {
        HSSFPalette palette = ((HSSFWorkbook)wb).getCustomPalette();
        CSSValue bgColour = birtStyle.getProperty(8);
        int[] bgRgb = this.parseColour(bgColour == null ? null : bgColour.getCssText(), "white");
        short[] fgRgb = HSSFColor.BLACK.triplet;
        if (font != null && font.getColor() != Short.MAX_VALUE) {
            fgRgb = palette.getColor(font.getColor()).getTriplet();
        }
        if (fgRgb[0] == 255 && fgRgb[1] == 255 && fgRgb[2] == 255) {
            fgRgb[2] = 0;
            fgRgb[1] = 0;
            fgRgb[0] = 0;
        } else if (fgRgb[0] == 0 && fgRgb[1] == 0 && fgRgb[2] == 0) {
            fgRgb[2] = 255;
            fgRgb[1] = 255;
            fgRgb[0] = 255;
        }
        if (bgRgb[0] == fgRgb[0] && bgRgb[1] == fgRgb[1] && bgRgb[2] == fgRgb[2]) {
            AreaStyle addedStyle = new AreaStyle(fm.getCssEngine());
            addedStyle.setColor(this.contrastColour(bgRgb));
            return fm.getFontWithExtraStyle(font, addedStyle);
        }
        return font;
    }

    @Override
    public int anchorDxFromMM(double widthMM, double colWidthMM) {
        return (int)(1023.0 * widthMM / colWidthMM);
    }

    @Override
    public int anchorDyFromPoints(float height, float rowHeight) {
        return (int)(255.0 * (double)height / (double)rowHeight);
    }

    @Override
    public void prepareMarginDimensions(Sheet sheet, IPageContent page) {
        double headerHeight = 0.5;
        double footerHeight = 0.5;
        if (page.getHeaderHeight() != null && this.isAbsolute(page.getHeaderHeight())) {
            headerHeight = page.getHeaderHeight().convertTo("in");
            sheet.getPrintSetup().setHeaderMargin(headerHeight);
        }
        if (page.getFooterHeight() != null && this.isAbsolute(page.getFooterHeight())) {
            footerHeight = page.getFooterHeight().convertTo("in");
            sheet.getPrintSetup().setFooterMargin(footerHeight);
        }
        if (page.getMarginBottom() != null && this.isAbsolute(page.getMarginBottom())) {
            sheet.setMargin((short)3, footerHeight + page.getMarginBottom().convertTo("in"));
        }
        if (page.getMarginLeft() != null && this.isAbsolute(page.getMarginLeft())) {
            sheet.setMargin((short)0, page.getMarginLeft().convertTo("in"));
        }
        if (page.getMarginRight() != null && this.isAbsolute(page.getMarginRight())) {
            sheet.setMargin((short)1, page.getMarginRight().convertTo("in"));
        }
        if (page.getMarginTop() != null && this.isAbsolute(page.getMarginTop())) {
            sheet.setMargin((short)2, headerHeight + page.getMarginTop().convertTo("in"));
        }
    }
}

