/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.hibernate;

import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaDao;
import fr.ifremer.adagio.core.dao.technical.DatabaseSchemaUpdateException;
import fr.ifremer.adagio.core.dao.technical.Version;
import fr.ifremer.adagio.core.dao.technical.VersionNotFoundException;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateConnectionProvider;
import fr.ifremer.adagio.core.dao.technical.hibernate.HibernateDaoSupport;
import fr.ifremer.adagio.core.dao.technical.liquibase.Liquibase;
import java.io.IOException;
import javax.sql.DataSource;
import liquibase.exception.LiquibaseException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.stereotype.Repository;

@Repository(value="databaseSchemaDao")
public class DatabaseSchemaDaoImpl
extends HibernateDaoSupport
implements DatabaseSchemaDao {
    private static final Log log = LogFactory.getLog(DatabaseSchemaDaoImpl.class);
    @Autowired
    private ApplicationContext appContext;
    @Autowired
    private Liquibase liquibase;
    @Value(value="${hibernate.dialect}")
    private String hibernateDialect = null;
    private Dialect localDialect = null;
    private DataSource dataSource = null;

    @Autowired
    public DatabaseSchemaDaoImpl(DataSource dataSource, SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
        this.dataSource = dataSource;
    }

    @Override
    public void generateCreateSchemaFile(String filename) {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("filename could not be null or empty.");
        }
        this.generateCreateSchemaFile(filename, false, false, true);
    }

    @Override
    public void generateCreateSchemaFile(String filename, boolean doExecute, boolean withDrop, boolean withCreate) {
        Configuration cfg = this.getHibernateConfiguration();
        SchemaExport se = new SchemaExport(cfg);
        se.setDelimiter(";");
        se.setOutputFile(filename);
        se.execute(false, doExecute, !withCreate, !withDrop);
    }

    @Override
    public void generateUpdateSchemaFile(String filename) {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("filename could not be null or empty.");
        }
        this.generateUpdateSchemaFile(filename, false);
    }

    @Override
    public void generateUpdateSchemaFile(String filename, boolean doUpdate) {
        Configuration cfg = this.getHibernateConfiguration();
        SchemaUpdate su = new SchemaUpdate(cfg);
        su.setDelimiter(";");
        su.setOutputFile(filename);
        su.execute(false, false);
    }

    private Configuration getHibernateConfiguration() {
        Configuration cfg = new Configuration();
        try {
            this.addRessourceToHibernateConfiguration(cfg, Package.getPackage("fr.ifremer.adagio.core.dao"), "**/*.hbm.xml");
            this.addRessourceToHibernateConfiguration(cfg, "", "queries.hbm.xml");
            this.addRessourceToHibernateConfiguration(cfg, "", "queries-override.hbm.xml");
        }
        catch (IOException e) {
            this.logger.error((Object)"exportExtractorSchemaToFile failed", (Throwable)e);
            throw new DataAccessResourceFailureException(e.getMessage(), (Throwable)e);
        }
        cfg.setProperty("hibernate.dialect", this.hibernateDialect);
        HibernateConnectionProvider.setDataSource(this.dataSource);
        cfg.setProperty("hibernate.connection.provider_class", HibernateConnectionProvider.class.getName());
        return cfg;
    }

    private void addRessourceToHibernateConfiguration(Configuration cfg, Package aPackage, String filePattern) throws IOException {
        String packageName = aPackage.getName().replace(".", "/");
        this.addRessourceToHibernateConfiguration(cfg, packageName, "**/*.hbm.xml");
    }

    private void addRessourceToHibernateConfiguration(Configuration cfg, String classPathFolder, String filePattern) throws IOException {
        Resource[] resources;
        String fullName = null;
        fullName = classPathFolder != null && !classPathFolder.isEmpty() ? classPathFolder + "/" + filePattern : filePattern;
        for (Resource resource : resources = this.appContext.getResources("classpath*:" + fullName)) {
            int index;
            String path = resource.getURL().toString();
            if (classPathFolder != null && !classPathFolder.isEmpty()) {
                index = path.lastIndexOf(classPathFolder);
                if (index != -1) {
                    path = path.substring(index);
                }
            } else {
                index = path.lastIndexOf("/");
                if (index != -1) {
                    path = path.substring(index + 1);
                }
            }
            cfg.addResource(path);
        }
    }

    public String getHibernateDialect() {
        return this.hibernateDialect;
    }

    public void setHibernateDialect(String hibernateDialect) {
        this.hibernateDialect = hibernateDialect;
    }

    public Dialect getLocalDialect() {
        if (this.localDialect == null) {
            this.localDialect = ((SessionFactoryImplementor)this.getSessionFactory()).getSettings().getDialect();
        }
        return this.localDialect;
    }

    @Override
    public void updateSchema() throws DatabaseSchemaUpdateException {
        try {
            this.liquibase.executeUpdate();
        }
        catch (LiquibaseException le) {
            if (log.isErrorEnabled()) {
                log.error((Object)le.getMessage(), (Throwable)le);
            }
            throw new DatabaseSchemaUpdateException("Could not update schema", le);
        }
    }

    @Override
    public Version getSchemaVersion() throws VersionNotFoundException {
        String systemVersion;
        try {
            systemVersion = (String)this.queryUniqueTyped("lastSystemVersion", new Object[0]);
            if (StringUtils.isBlank((String)systemVersion)) {
                throw new VersionNotFoundException(String.format("Could not get the schema version. No version found in SYSTEM_VERSION table.", new Object[0]));
            }
        }
        catch (HibernateException he) {
            throw new VersionNotFoundException(String.format("Could not get the schema version: %s", he.getMessage()));
        }
        try {
            return Version.parseVersion(systemVersion);
        }
        catch (IllegalArgumentException iae) {
            throw new VersionNotFoundException(String.format("Could not get the schema version. Bad schema version found table SYSTEM_VERSION: %s", systemVersion));
        }
    }

    @Override
    public Version getSchemaVersionIfUpdate() {
        return this.liquibase.getMaxChangeLogFileVersion();
    }

    @Override
    public boolean shouldUpdateSchema() throws VersionNotFoundException {
        return this.getSchemaVersion().compareTo(this.getSchemaVersionIfUpdate()) >= 0;
    }
}

