/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.group;

import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.group.DayGroupCalculator;
import org.eclipse.birt.report.data.adapter.group.HourGroupCalculator;
import org.eclipse.birt.report.data.adapter.group.ICalculator;
import org.eclipse.birt.report.data.adapter.group.MinuteGroupCalculator;
import org.eclipse.birt.report.data.adapter.group.MonthGroupCalculator;
import org.eclipse.birt.report.data.adapter.group.NumericGroupCalculator;
import org.eclipse.birt.report.data.adapter.group.QuarterGroupCalculator;
import org.eclipse.birt.report.data.adapter.group.SecondGroupCalculator;
import org.eclipse.birt.report.data.adapter.group.StringGroupCalculator;
import org.eclipse.birt.report.data.adapter.group.WeekGroupCalculator;
import org.eclipse.birt.report.data.adapter.group.YearGroupCalculator;

public class GroupCalculatorFactory {
    public static ICalculator getGroupCalculator(int interval, int dataType, Object intervalStart, double intervalRange, ULocale locale, TimeZone timeZone) throws AdapterException {
        if (!GroupCalculatorFactory.isValidInterval(interval, dataType)) {
            return null;
        }
        try {
            switch (interval) {
                case 1: {
                    return new YearGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 2: {
                    return new MonthGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 3: {
                    return new QuarterGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 4: {
                    return new WeekGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 5: {
                    return new DayGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 6: {
                    return new HourGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 7: {
                    return new MinuteGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 8: {
                    return new SecondGroupCalculator(intervalStart, intervalRange, locale, timeZone);
                }
                case 99: {
                    return new NumericGroupCalculator(intervalStart, intervalRange);
                }
                case 100: {
                    return new StringGroupCalculator(intervalStart, intervalRange);
                }
            }
            throw new DataException("data.engine.group.interval.invalid");
        }
        catch (BirtException be) {
            throw new AdapterException(be.getLocalizedMessage(), be);
        }
    }

    private static boolean isValidInterval(int interval, int dataType) throws AdapterException {
        if (dataType == 0 || dataType == -1) {
            return true;
        }
        switch (interval) {
            case 0: {
                return true;
            }
            case 99: {
                if (GroupCalculatorFactory.isNumber(dataType)) {
                    return true;
                }
                throw new AdapterException("The group interval is invalid");
            }
            case 100: {
                if (GroupCalculatorFactory.isString(dataType)) {
                    return true;
                }
                throw new AdapterException("The group interval is invalid");
            }
        }
        if (GroupCalculatorFactory.isDate(dataType)) {
            return true;
        }
        throw new AdapterException("The group interval is invalid");
    }

    private static boolean isNumber(int dataType) {
        return dataType == 4 || dataType == 3 || dataType == 2;
    }

    private static boolean isDate(int dataType) {
        return dataType == 6 || dataType == 9 || dataType == 10;
    }

    private static boolean isString(int dataType) {
        return dataType == 5;
    }
}

