
package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: SaveProtocolAction.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://svn.codelutin.com/tutti/tags/tutti-3.2.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/SaveProtocolAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;

import static org.nuiton.i18n.I18n.t;

/**
 * Saves a protocol
 *
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public class SaveProtocolAction extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {

    /** Logger. */
    private static final Log log = LogFactory.getLog(SaveProtocolAction.class);

    public SaveProtocolAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    /**
     * If the event source is a TuttiScreen, then the screen changes to the source.
     * Otherwise, the screen changes to the home.
     */
    @Override
    public void doAction() throws Exception {
        EditProtocolUIModel model = getModel();
        TuttiUIContext context = getContext();

        PersistenceService persistenceService = context.getPersistenceService();

        TuttiProtocol bean = model.toBean();

        // get the species protocols from the table
        List<SpeciesProtocol> speciesProtocols = Lists.newArrayList();

        for (EditProtocolSpeciesRowModel row : model.getSpeciesRow()) {
            if (row.isValid()) {
                SpeciesProtocol protocol = row.toBean();
                speciesProtocols.add(protocol);
            }
        }
        bean.setSpecies(speciesProtocols);

        List<SpeciesProtocol> benthosProtocols = Lists.newArrayList();

        for (EditProtocolSpeciesRowModel row : model.getBenthosRow()) {
            if (row.isValid()) {
                SpeciesProtocol protocol = row.toBean();
                benthosProtocols.add(protocol);
            }
        }
        bean.setBenthos(benthosProtocols);

        if (log.isDebugEnabled()) {
            log.debug("protocol id to save: " + bean.getId());
        }

        TuttiProtocol saved;

        if (TuttiEntities.isNew(bean)) {

            saved = persistenceService.createProtocol(bean);
            model.setId(saved.getId());
            sendMessage(t("tutti.flash.info.protocolCreated", bean.getName()));
        } else {
            saved = persistenceService.saveProtocol(bean);
            sendMessage(t("tutti.flash.info.protocolSaved", bean.getName()));
        }

        context.setProtocolId(saved.getId());

        model.setModify(false);
    }

    @Override
    public void postSuccessAction() {
        getContext().getMainUI().getHandler().setBodyTitle(
                EditProtocolUIHandler.getTitle(true));
        getUI().getSaveWarningContainer().setVisible(false);

    }
}
