/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.fishing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.AbstractCaracteristicRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.fishing.AbstractCaracteristicTabUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;

public abstract class AbstractCaracteristicTabUIHandler<RM extends AbstractCaracteristicRowModel<RM>, M extends AbstractCaracteristicTabUIModel<RM, M>, TM extends AbstractApplicationTableModel<RM>, UI extends TuttiUI<M, ?>>
extends AbstractTuttiTableUIHandler<RM, M, UI> {
    private static final Log log = LogFactory.getLog(AbstractCaracteristicTabUIHandler.class);

    public AbstractCaracteristicTabUIHandler(String ... properties) {
        super(properties);
    }

    public TM getTableModel() {
        return (TM)((AbstractApplicationTableModel)this.getTable().getModel());
    }

    @Override
    protected boolean isRowValid(RM row) {
        return ((AbstractCaracteristicRowModel)((Object)row)).getValue() != null;
    }

    @Override
    protected void onRowModified(int rowIndex, RM row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        super.onRowModified(rowIndex, row, propertyName, oldValue, newValue);
        this.saveSelectedRowIfNeeded();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<RM> rowMonitor, RM row) {
        if (((AbstractTuttiBeanUIModel)((Object)row)).isValid() && rowMonitor.wasModified()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Row " + row + " was modified, will save it"));
            }
            this.saveRow(row);
        }
    }

    public SwingValidator<M> getValidator() {
        return null;
    }

    @Override
    protected void onAfterSelectedRowChanged(int oldRowIndex, RM oldRow, int newRowIndex, RM newRow) {
        super.onAfterSelectedRowChanged(oldRowIndex, oldRow, newRowIndex, newRow);
        ((AbstractCaracteristicTabUIModel)((Object)this.getModel())).setRemoveCaracteristicEnabled(newRow != null);
    }

    public void beforeInit(UI ui) {
        super.beforeInit(ui);
        M model = this.createModel();
        ui.setContextValue(model);
    }

    public void afterInit(UI ui) {
        this.initUI((ApplicationUI)ui);
        this.initBeanFilterableComboBox(this.getKeyCombo(), Lists.newArrayList(), null);
    }

    protected JComponent getComponentToFocus() {
        return this.getKeyCombo();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.getUI()));
        }
    }

    protected void saveRow(RM row) {
        if (((AbstractTuttiBeanUIModel)((Object)row)).isValid()) {
            CaracteristicMap caracteristics = ((AbstractCaracteristicTabUIModel)((Object)this.getModel())).getCaracteristicMap();
            Preconditions.checkNotNull((Object)caracteristics);
            caracteristics.put((Object)((AbstractCaracteristicRowModel)((Object)row)).getKey(), (Object)((AbstractCaracteristicRowModel)((Object)row)).getValue());
        }
    }

    protected abstract M createModel();

    protected abstract BeanFilterableComboBox<Caracteristic> getKeyCombo();

    protected abstract CaracteristicMap getCaracteristics(FishingOperation var1);

    protected abstract List<String> getProtocolPmfmIds();

    public void addRow() {
        BeanFilterableComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        Caracteristic selectedItem = (Caracteristic)keyCombo.getSelectedItem();
        TM tableModel = this.getTableModel();
        AbstractCaracteristicRowModel row = (AbstractCaracteristicRowModel)((Object)tableModel.createNewRow());
        row.setKey(selectedItem);
        ((AbstractCaracteristicTabUIModel)((Object)this.getModel())).getRows().add(row);
        int rowIndex = tableModel.getRowCount() - 1;
        tableModel.fireTableRowsInserted(rowIndex, rowIndex);
        keyCombo.getHandler().removeItem((Object)selectedItem);
        AbstractCaracteristicTabUIModel model = (AbstractCaracteristicTabUIModel)((Object)this.getModel());
        model.setModify(true);
        this.recomputeRowValidState(row);
    }

    public void reset(FishingOperation fishingOperation) {
        AbstractCaracteristicTabUIModel model = (AbstractCaracteristicTabUIModel)((Object)this.getModel());
        CaracteristicMap caracteristicMap = this.getCaracteristics(fishingOperation);
        if (caracteristicMap == null) {
            caracteristicMap = new CaracteristicMap();
        }
        model.setCaracteristicMap(caracteristicMap);
        this.updateRows();
        model.setModify(false);
    }

    public void mergeCaracteristics(FishingOperation fishingOperation) {
        CaracteristicMap caracteristicMap = this.getCaracteristics(fishingOperation);
        if (caracteristicMap != null) {
            CaracteristicMap thisCaracteristicMap = ((AbstractCaracteristicTabUIModel)((Object)this.getModel())).getCaracteristicMap();
            for (Caracteristic caracteristic : caracteristicMap.keySet()) {
                thisCaracteristicMap.put((Object)caracteristic, caracteristicMap.get((Object)caracteristic));
            }
            ((AbstractCaracteristicTabUIModel)((Object)this.getModel())).setModify(true);
            this.updateRows();
        }
    }

    protected void updateRows() {
        List<String> protocolPmfmId;
        TM tableModel = this.getTableModel();
        AbstractCaracteristicTabUIModel model = (AbstractCaracteristicTabUIModel)((Object)this.getModel());
        ArrayList pmfmIds = Lists.newArrayList();
        if (this.getDataContext().isProtocolFilled() && (protocolPmfmId = this.getProtocolPmfmIds()) != null) {
            pmfmIds.addAll(protocolPmfmId);
        }
        CaracteristicMap caracteristicMap = model.getCaracteristicMap();
        ArrayList rows = Lists.newArrayList();
        ArrayList caracteristics = Lists.newArrayList((Iterable)caracteristicMap.keySet());
        List<Caracteristic> availableCaracteristics = model.getAvailableCaracteristics();
        for (String id : pmfmIds) {
            Caracteristic caracteristic = (Caracteristic)TuttiEntities.findById(availableCaracteristics, (String)id);
            if (caracteristics.contains(caracteristic)) continue;
            caracteristics.add(caracteristic);
        }
        for (Caracteristic key : caracteristics) {
            AbstractCaracteristicRowModel newRow = (AbstractCaracteristicRowModel)((Object)tableModel.createNewRow());
            newRow.setKey(key);
            newRow.setValue((Serializable)caracteristicMap.get((Object)key));
            rows.add(newRow);
        }
        model.setRows(rows);
        ArrayList caracteristicList = Lists.newArrayList();
        for (Caracteristic caracteristic : availableCaracteristics) {
            if (caracteristics.contains(caracteristic)) continue;
            caracteristicList.add(caracteristic);
        }
        BeanFilterableComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        keyCombo.setData((List)caracteristicList);
        keyCombo.getHandler().reset();
    }

    public void removeCaracteristic() {
        int rowIndex = this.getTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant remove caracteristic if no caracteristic selected");
        AbstractCaracteristicRowModel row = (AbstractCaracteristicRowModel)((Object)this.getTableModel().getEntry(rowIndex));
        CaracteristicMap caracteristicMap = ((AbstractCaracteristicTabUIModel)((Object)this.getModel())).getCaracteristicMap();
        if (caracteristicMap != null) {
            caracteristicMap.remove((Object)row.getKey());
        }
        BeanFilterableComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        keyCombo.addItem((Object)row.getKey());
        keyCombo.getHandler().reset();
        ((AbstractCaracteristicTabUIModel)((Object)this.getModel())).getRows().remove(rowIndex);
        this.getTableModel().fireTableRowsDeleted(rowIndex, rowIndex);
        ((AbstractCaracteristicTabUIModel)((Object)this.getModel())).removeRowInError(row);
    }
}

