// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.vessel.feature.person;

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.measure.VesselPersonMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.Operation;
import fr.ifremer.adagio.core.dao.data.survey.economy.EconomicalSurvey;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.VesselPersonRole;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * <html>
 * <head>
 * <style>
 * p {padding:0px; margin:0px;}
 * </style>
 * </head>
 * <body>
 * <p>
 * Caractéristiques d'une personne physique en relation avec un Vessel
 * (usager), pour une période.
 * </p>
 * <p>
 * </p>
 * <p>
 * Dans tous les cas, il s'agit bien d'une personne physique, et <b>jamais
 * d'un regroupement de plusieurs personnes</b>. Ainsi, des variables comme
 * le &quot;<i>nombre d'hommes à bord</i>&quot; ne sera pas stocké ici,
 * mais plutot dans <i>VesselUseFeatures</i>/<i>VesselUseMesurement</i>.
 * </p>
 * </body>
 * </html>
 */
// HibernateEntity.vsl annotations merge-point
public abstract class VesselPersonFeatures
    implements Serializable, Comparable<VesselPersonFeatures>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 1699914321941843536L;

    // Generate 11 attributes
    private Integer id;

    /**
     * 
     * @return this.id Integer
     */
    public Integer getId()
    {
        return this.id;
    }

    /**
     * 
     * @param idIn Integer
     */
    public void setId(Integer idIn)
    {
        this.id = idIn;
    }

    private Date startDate;

    /**
     * 
     * @return this.startDate Date
     */
    public Date getStartDate()
    {
        return this.startDate;
    }

    /**
     * 
     * @param startDateIn Date
     */
    public void setStartDate(Date startDateIn)
    {
        this.startDate = startDateIn;
    }

    private Date endDate;

    /**
     * 
     * @return this.endDate Date
     */
    public Date getEndDate()
    {
        return this.endDate;
    }

    /**
     * 
     * @param endDateIn Date
     */
    public void setEndDate(Date endDateIn)
    {
        this.endDate = endDateIn;
    }

    private Short rankOrder;

    /**
     * Numéro d'ordre de la personne, dans le cas où il y a plusieurs personnes concernées
     * @return this.rankOrder Short
     */
    public Short getRankOrder()
    {
        return this.rankOrder;
    }

    /**
     * Numéro d'ordre de la personne, dans le cas où il y a plusieurs personnes concernées
     * @param rankOrderIn Short
     */
    public void setRankOrder(Short rankOrderIn)
    {
        this.rankOrder = rankOrderIn;
    }

    private Date creationDate;

    /**
     * 
     * @return this.creationDate Date
     */
    public Date getCreationDate()
    {
        return this.creationDate;
    }

    /**
     * 
     * @param creationDateIn Date
     */
    public void setCreationDate(Date creationDateIn)
    {
        this.creationDate = creationDateIn;
    }

    private Date controlDate;

    /**
     * 
     * @return this.controlDate Date
     */
    public Date getControlDate()
    {
        return this.controlDate;
    }

    /**
     * 
     * @param controlDateIn Date
     */
    public void setControlDate(Date controlDateIn)
    {
        this.controlDate = controlDateIn;
    }

    private Date validationDate;

    /**
     * 
     * @return this.validationDate Date
     */
    public Date getValidationDate()
    {
        return this.validationDate;
    }

    /**
     * 
     * @param validationDateIn Date
     */
    public void setValidationDate(Date validationDateIn)
    {
        this.validationDate = validationDateIn;
    }

    private Date qualificationDate;

    /**
     * 
     * @return this.qualificationDate Date
     */
    public Date getQualificationDate()
    {
        return this.qualificationDate;
    }

    /**
     * 
     * @param qualificationDateIn Date
     */
    public void setQualificationDate(Date qualificationDateIn)
    {
        this.qualificationDate = qualificationDateIn;
    }

    private String qualificationComments;

    /**
     * 
     * @return this.qualificationComments String
     */
    public String getQualificationComments()
    {
        return this.qualificationComments;
    }

    /**
     * 
     * @param qualificationCommentsIn String
     */
    public void setQualificationComments(String qualificationCommentsIn)
    {
        this.qualificationComments = qualificationCommentsIn;
    }

    private Timestamp updateDate;

    /**
     * 
     * @return this.updateDate Timestamp
     */
    public Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    /**
     * 
     * @param updateDateIn Timestamp
     */
    public void setUpdateDate(Timestamp updateDateIn)
    {
        this.updateDate = updateDateIn;
    }

    private Integer remoteId;

    /**
     * 
     * @return this.remoteId Integer
     */
    public Integer getRemoteId()
    {
        return this.remoteId;
    }

    /**
     * 
     * @param remoteIdIn Integer
     */
    public void setRemoteId(Integer remoteIdIn)
    {
        this.remoteId = remoteIdIn;
    }

    // Generate 10 associations
    private Collection<VesselPersonRole> vesselPersonRoles = new HashSet<VesselPersonRole>();

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Role de la personne en relation avec un navire.
     * </p>
     * <p>
     * </p>
     * <p>
     * Exemple :
     * </p>
     * <p>
     * - Patron de pêche (<i>Capitaine</i> ou <i>VesselMaster</i>)
     * </p>
     * <p>
     * - Actionnaire
     * </p>
     * <p>
     * - Revendeur att,
     * </p>
     * <p>
     * etc.
     * </p>
     * </body>
     * </html>
     * @return this.vesselPersonRoles Collection<VesselPersonRole>
     */
    public Collection<VesselPersonRole> getVesselPersonRoles()
    {
        return this.vesselPersonRoles;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Role de la personne en relation avec un navire.
     * </p>
     * <p>
     * </p>
     * <p>
     * Exemple :
     * </p>
     * <p>
     * - Patron de pêche (<i>Capitaine</i> ou <i>VesselMaster</i>)
     * </p>
     * <p>
     * - Actionnaire
     * </p>
     * <p>
     * - Revendeur att,
     * </p>
     * <p>
     * etc.
     * </p>
     * </body>
     * </html>
     * @param vesselPersonRolesIn Collection<VesselPersonRole>
     */
    public void setVesselPersonRoles(Collection<VesselPersonRole> vesselPersonRolesIn)
    {
        this.vesselPersonRoles = vesselPersonRolesIn;
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Role de la personne en relation avec un navire.
     * </p>
     * <p>
     * </p>
     * <p>
     * Exemple :
     * </p>
     * <p>
     * - Patron de pêche (<i>Capitaine</i> ou <i>VesselMaster</i>)
     * </p>
     * <p>
     * - Actionnaire
     * </p>
     * <p>
     * - Revendeur att,
     * </p>
     * <p>
     * etc.
     * </p>
     * </body>
     * </html>
     * @param elementToAdd VesselPersonRole
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselPersonRoles(VesselPersonRole elementToAdd)
    {
        return this.vesselPersonRoles.add(elementToAdd);
    }

    /**
     * <html>
     * <head>
     * <style>
     * p {padding:0px; margin:0px;}
     * </style>
     * </head>
     * <body>
     * <p>
     * Role de la personne en relation avec un navire.
     * </p>
     * <p>
     * </p>
     * <p>
     * Exemple :
     * </p>
     * <p>
     * - Patron de pêche (<i>Capitaine</i> ou <i>VesselMaster</i>)
     * </p>
     * <p>
     * - Actionnaire
     * </p>
     * <p>
     * - Revendeur att,
     * </p>
     * <p>
     * etc.
     * </p>
     * </body>
     * </html>
     * @param elementToRemove VesselPersonRole
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselPersonRoles(VesselPersonRole elementToRemove)
    {
        return this.vesselPersonRoles.remove(elementToRemove);
    }

    private Operation operation;

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @return this.operation Operation
     */
    public Operation getOperation()
    {
        return this.operation;
    }

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @param operationIn Operation
     */
    public void setOperation(Operation operationIn)
    {
        this.operation = operationIn;
    }

    private FishingTrip fishingTrip;

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @return this.fishingTrip FishingTrip
     */
    public FishingTrip getFishingTrip()
    {
        return this.fishingTrip;
    }

    /**
     * Voyage en mer, ayant pour vocation une activité de peche (peut etre une campagnes halieutique
     * ou une
     * marée d'un navire professionnel, etc.)
     * Un voyage peut représenter type de données :
     * - Une marée observée (en mer, au débarquement), qui désigne une marée de pêche
     * professionnelle au
     * cours de laquelle des relevés sont effectués par un observateur.
     * - Une marée déclarée. Principalement issue du log book électronique (flux SACAPT). Une marée
     * déclarée peut etre un ensemble de marée ou de sous-ensembles de marée (Exemple de la fiche de
     * peche)
     * - une sortie effectuée lors d"une campagne scientifique
     * @param fishingTripIn FishingTrip
     */
    public void setFishingTrip(FishingTrip fishingTripIn)
    {
        this.fishingTrip = fishingTripIn;
    }

    private EconomicalSurvey economicalSurvey;

    /**
     * Enquete economique.
     * Une enquete économique peut etre rattaché à un usager de la ressource (Vessel) ou encore à un
     * propriétaire de navire (aramateur).
     * @return this.economicalSurvey EconomicalSurvey
     */
    public EconomicalSurvey getEconomicalSurvey()
    {
        return this.economicalSurvey;
    }

    /**
     * Enquete economique.
     * Une enquete économique peut etre rattaché à un usager de la ressource (Vessel) ou encore à un
     * propriétaire de navire (aramateur).
     * @param economicalSurveyIn EconomicalSurvey
     */
    public void setEconomicalSurvey(EconomicalSurvey economicalSurveyIn)
    {
        this.economicalSurvey = economicalSurveyIn;
    }

    private QualityFlag qualityFlag;

    /**
     * Indice qualité d'une donnée.
     * Actuellement, les indices qualités identifiés sont :
     * 0 - Non qualifiée,
     * 1 - Bonne,
     * 2 - Hors statistiques,
     * 3 - Douteuse,
     * 4 - Fausse,
     * 5 - Corrigée,
     * 8 - Incomplète,
     * 9 - Absente.
     * @return this.qualityFlag QualityFlag
     */
    public QualityFlag getQualityFlag()
    {
        return this.qualityFlag;
    }

    /**
     * Indice qualité d'une donnée.
     * Actuellement, les indices qualités identifiés sont :
     * 0 - Non qualifiée,
     * 1 - Bonne,
     * 2 - Hors statistiques,
     * 3 - Douteuse,
     * 4 - Fausse,
     * 5 - Corrigée,
     * 8 - Incomplète,
     * 9 - Absente.
     * @param qualityFlagIn QualityFlag
     */
    public void setQualityFlag(QualityFlag qualityFlagIn)
    {
        this.qualityFlag = qualityFlagIn;
    }

    private VesselPerson vesselPerson;

    /**
     * Personne liés à une usager. Par exemple, un capitaine (patron) de navire, un marin, etc.
     * ref : flux SACAPT, SIH-INRH
     * ATTENTION :
     * - Pour Ifremer, actuellement non utilisée, pour observation de la données SACAPT avant
     * utilisation.
     * Pour le moment, la donnée est stockée dans 'Playground'.
     * @return this.vesselPerson VesselPerson
     */
    public VesselPerson getVesselPerson()
    {
        return this.vesselPerson;
    }

    /**
     * Personne liés à une usager. Par exemple, un capitaine (patron) de navire, un marin, etc.
     * ref : flux SACAPT, SIH-INRH
     * ATTENTION :
     * - Pour Ifremer, actuellement non utilisée, pour observation de la données SACAPT avant
     * utilisation.
     * Pour le moment, la donnée est stockée dans 'Playground'.
     * @param vesselPersonIn VesselPerson
     */
    public void setVesselPerson(VesselPerson vesselPersonIn)
    {
        this.vesselPerson = vesselPersonIn;
    }

    private Person person;

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.person Person
     */
    public Person getPerson()
    {
        return this.person;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param personIn Person
     */
    public void setPerson(Person personIn)
    {
        this.person = personIn;
    }

    private Program program;

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @return this.program Program
     */
    public Program getProgram()
    {
        return this.program;
    }

    /**
     * Programme d'observation à l'origine d'une collecte de données.
     * Désigne les activités qui sont à l'origine de la collecte d'un ensemble cohérent de données,
     * que ce
     * soit pour des collectes continues (marées observées en mer, SIPA) ou pour des études limitées
     * dans
     * le temps. La quantité de données rattachées à un programme peut être variable, selon qu'il
     * s'agit
     * d'une activité longue ou intensive, ou d'une opération plus ponctuelle (étude) mais toujours
     * mise en
     * œuvre selon un schéma décidé à l'avance.
     * Exemple de programmes d'observations :
     * - SIH-OBSMER (marées observées en mer)
     * - SIH-STATPECHE (enquete d'activité et d'effort...)
     * - SIPA : données déclaratives transmises par la DPMA
     * - VMS : données satellitaires
     * - OFIMER : données du SI de l'OFIMER
     * @param programIn Program
     */
    public void setProgram(Program programIn)
    {
        this.program = programIn;
    }

    private Vessel vessel;

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    private Collection<VesselPersonMeasurement> vesselPersonMeasurements = new HashSet<VesselPersonMeasurement>();

    /**
     * 
     * @return this.vesselPersonMeasurements Collection<VesselPersonMeasurement>
     */
    public Collection<VesselPersonMeasurement> getVesselPersonMeasurements()
    {
        return this.vesselPersonMeasurements;
    }

    /**
     * 
     * @param vesselPersonMeasurementsIn Collection<VesselPersonMeasurement>
     */
    public void setVesselPersonMeasurements(Collection<VesselPersonMeasurement> vesselPersonMeasurementsIn)
    {
        this.vesselPersonMeasurements = vesselPersonMeasurementsIn;
    }

    /**
     * 
     * @param elementToAdd VesselPersonMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addVesselPersonMeasurements(VesselPersonMeasurement elementToAdd)
    {
        return this.vesselPersonMeasurements.add(elementToAdd);
    }

    /**
     * 
     * @param elementToRemove VesselPersonMeasurement
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeVesselPersonMeasurements(VesselPersonMeasurement elementToRemove)
    {
        return this.vesselPersonMeasurements.remove(elementToRemove);
    }

    /**
     * Returns <code>true</code> if the argument is an VesselPersonFeatures instance and all identifiers for this entity
     * equal the identifiers of the argument entity. Returns <code>false</code> otherwise.
     */
    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof VesselPersonFeatures))
        {
            return false;
        }
        final VesselPersonFeatures that = (VesselPersonFeatures)object;
        if (this.id == null || that.getId() == null || !this.id.equals(that.getId()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    @Override
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link VesselPersonFeatures}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link VesselPersonFeatures}.
         * @return new VesselPersonFeaturesImpl()
         */
        public static VesselPersonFeatures newInstance()
        {
            return new VesselPersonFeaturesImpl();
        }

        /**
         * Constructs a new instance of {@link VesselPersonFeatures}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param startDate Date
         * @param qualityFlag QualityFlag
         * @param program Program
         * @param vessel Vessel
         * @return newInstance
         */
        public static VesselPersonFeatures newInstance(Date startDate, QualityFlag qualityFlag, Program program, Vessel vessel)
        {
            final VesselPersonFeatures entity = new VesselPersonFeaturesImpl();
            entity.setStartDate(startDate);
            entity.setQualityFlag(qualityFlag);
            entity.setProgram(program);
            entity.setVessel(vessel);
            return entity;
        }

        /**
         * Constructs a new instance of {@link VesselPersonFeatures}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param startDate Date
         * @param endDate Date
         * @param rankOrder Short
         * @param creationDate Date
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param vesselPersonRoles Collection<VesselPersonRole>
         * @param operation Operation
         * @param fishingTrip FishingTrip
         * @param economicalSurvey EconomicalSurvey
         * @param qualityFlag QualityFlag
         * @param vesselPerson VesselPerson
         * @param person Person
         * @param program Program
         * @param vessel Vessel
         * @param vesselPersonMeasurements Collection<VesselPersonMeasurement>
         * @return newInstance VesselPersonFeatures
         */
        public static VesselPersonFeatures newInstance(Date startDate, Date endDate, Short rankOrder, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Integer remoteId, Collection<VesselPersonRole> vesselPersonRoles, Operation operation, FishingTrip fishingTrip, EconomicalSurvey economicalSurvey, QualityFlag qualityFlag, VesselPerson vesselPerson, Person person, Program program, Vessel vessel, Collection<VesselPersonMeasurement> vesselPersonMeasurements)
        {
            final VesselPersonFeatures entity = new VesselPersonFeaturesImpl();
            entity.setStartDate(startDate);
            entity.setEndDate(endDate);
            entity.setRankOrder(rankOrder);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setVesselPersonRoles(vesselPersonRoles);
            entity.setOperation(operation);
            entity.setFishingTrip(fishingTrip);
            entity.setEconomicalSurvey(economicalSurvey);
            entity.setQualityFlag(qualityFlag);
            entity.setVesselPerson(vesselPerson);
            entity.setPerson(person);
            entity.setProgram(program);
            entity.setVessel(vessel);
            entity.setVesselPersonMeasurements(vesselPersonMeasurements);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(VesselPersonFeatures o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        else
        {
            if (this.getStartDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getStartDate().compareTo(o.getStartDate()));
            }
            if (this.getEndDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getEndDate().compareTo(o.getEndDate()));
            }
            if (this.getRankOrder() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRankOrder().compareTo(o.getRankOrder()));
            }
            if (this.getCreationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getCreationDate().compareTo(o.getCreationDate()));
            }
            if (this.getControlDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getControlDate().compareTo(o.getControlDate()));
            }
            if (this.getValidationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getValidationDate().compareTo(o.getValidationDate()));
            }
            if (this.getQualificationDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationDate().compareTo(o.getQualificationDate()));
            }
            if (this.getQualificationComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getQualificationComments().compareTo(o.getQualificationComments()));
            }
            if (this.getUpdateDate() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getUpdateDate().compareTo(o.getUpdateDate()));
            }
            if (this.getRemoteId() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getRemoteId().compareTo(o.getRemoteId()));
            }
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// VesselPersonFeatures.java merge-point
}