/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.report;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.service.report.ReportService;
import fr.ifremer.tutti.ui.swing.content.report.ReportUI;
import fr.ifremer.tutti.ui.swing.content.report.ReportUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import jaxx.runtime.swing.editor.FileEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.util.CloseableUI;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class ReportUIHandler
extends AbstractTuttiUIHandler<ReportUIModel, ReportUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(ReportUIHandler.class);

    public void beforeInit(ReportUI ui) {
        super.beforeInit((ApplicationUI)ui);
        ReportService reportService = this.getContext().getReportService();
        ReportUIModel model = new ReportUIModel();
        String cruiseId = this.getDataContext().getCruiseId();
        model.setCruiseId(cruiseId);
        List reports = reportService.getAvailableReports();
        model.setReports(reports);
        List fishingOperations = this.getContext().getPersistenceService().getAllFishingOperation(cruiseId);
        model.setFishingOperations(fishingOperations);
        File outputFile = reportService.getDefaultOutputFile();
        model.setOutputFile(outputFile);
        this.listModelIsModify(model);
        ui.setContextValue(model);
    }

    public void afterInit(ReportUI ui) {
        this.initUI(ui);
        ReportUIModel model = (ReportUIModel)this.getModel();
        this.initBeanFilterableComboBox(ui.getReportComboBox(), Lists.newArrayList(model.getReports()), model.getReport());
        this.initBeanFilterableComboBox(ui.getFishingOperationComboBox(), Lists.newArrayList(model.getFishingOperations()), model.getFishingOperation());
        FileEditor outputFileField = ui.getOutputFileField();
        outputFileField.setDirectoryEnabled(Boolean.valueOf(false));
        outputFileField.setFileEnabled(Boolean.valueOf(true));
        outputFileField.setExts(".pdf");
        outputFileField.setExtsDescription(I18n.t((String)"tutti.common.file.pdf", (Object[])new Object[0]));
        SwingValidator<ReportUIModel> validator = ui.getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        this.registerValidators(validator);
    }

    protected JComponent getComponentToFocus() {
        return ((ReportUI)this.getUI()).getFishingOperationComboBox();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    public boolean quitUI() {
        return true;
    }

    public SwingValidator<ReportUIModel> getValidator() {
        return ((ReportUI)this.ui).getValidator();
    }

    public void showReport() {
        File file = ((ReportUIModel)this.getModel()).getOutputFile();
        Preconditions.checkState((boolean)file.exists());
        Desktop desktop = TuttiUIUtil.getDesktopForBrowse();
        try {
            desktop.browse(file.toURI());
        }
        catch (IOException e) {
            this.getContext().getErrorHelper().showErrorDialog(I18n.t((String)"swing.error.cannot.open.file", (Object[])new Object[0]));
        }
    }
}

