package fr.ifremer.tutti.ui.swing.action;

/*
 * #%L
 * Tutti :: UI
 * $Id: RemoveAllIndividualObservationBatchAction.java 1566 2014-02-04 08:31:02Z tchemit $
 * $HeadURL: https://forge.codelutin.com/svn/tutti/tags/tutti-3.1.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/action/RemoveAllIndividualObservationBatchAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.IndividualObservationBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;

import javax.swing.JOptionPane;
import java.util.List;

import static org.nuiton.i18n.I18n.t;

/**
 * Created on 10/3/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 2.7
 */
public class RemoveAllIndividualObservationBatchAction
        extends AbstractTuttiAction<IndividualObservationBatchUIModel, IndividualObservationBatchUI, IndividualObservationBatchUIHandler> {

    private static final Log log =
            LogFactory.getLog(RemoveAllIndividualObservationBatchAction.class);

    public RemoveAllIndividualObservationBatchAction(IndividualObservationBatchUIHandler handler) {
        super(handler, false);
    }

    protected Species species;

    protected List<Integer> rowIndexToRemove;

    @Override
    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();

        rowIndexToRemove = null;
        species = null;

        int rowIndex = -1;

        if (result) {
            JXTable table = handler.getTable();

            rowIndex = table.getSelectedRow();

            Preconditions.checkState(rowIndex != -1,
                                     "Cant remove batch if none is selected");
        }

        if (result) {

            IndividualObservationBatchTableModel tableModel = handler.getTableModel();

            IndividualObservationBatchRowModel entry = tableModel.getEntry(rowIndex);

            species = entry.getSpecies();

            rowIndexToRemove = Lists.newArrayList();

            for (IndividualObservationBatchRowModel rowModel : tableModel.getRows()) {
                if (species.equals(rowModel.getSpecies())) {
                    rowIndexToRemove.add(0, tableModel.getRowIndex(rowModel));
                }
            }

            int answer = JOptionPane.showConfirmDialog(getContext().getActionUI(),
                                                       t("tutti.editIndividualObservationBatch.action.removeAllBatch.confirm.message", rowIndexToRemove.size(), decorate(species)),
                                                       t("tutti.editIndividualObservationBatch.action.removeAllBatch.confirm.title"),
                                                       JOptionPane.YES_NO_OPTION);
            result = answer == JOptionPane.YES_OPTION;
        }

        return result;
    }

    @Override
    public void doAction() throws Exception {

        Preconditions.checkNotNull(rowIndexToRemove);
        Preconditions.checkNotNull(species);

        IndividualObservationBatchTableModel tableModel = handler.getTableModel();

        for (Integer rowIndex : rowIndexToRemove) {
            IndividualObservationBatchRowModel selectedBatch = tableModel.getEntry(rowIndex);

            boolean persisted = !TuttiEntities.isNew(selectedBatch);

            if (persisted) {

                // remove it from db

                String id = selectedBatch.getId();

                if (log.isInfoEnabled()) {
                    log.info("Remove individual observation with id: " + id);
                }

                TuttiPersistence persistenceService =
                        getContext().getPersistenceService();

                persistenceService.deleteIndividualObservationBatch(id);
            }
        }

    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();

        JXTable table = handler.getTable();

        IndividualObservationBatchTableModel tableModel = handler.getTableModel();

        for (Integer rowIndex : rowIndexToRemove) {
            tableModel.removeRow(rowIndex);
        }

        TuttiUIUtil.selectFirstCellOnFirstRowAndStopEditing(table);
    }
}
