/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipStreamEncoder
extends Thread {
    private static Log log = LogFactory.getLog(ZipStreamEncoder.class);
    static final int BUFFER = 2048;
    private Map<String, InputStream> files;
    private ZipOutputStream zos;

    public ZipStreamEncoder(Map<String, InputStream> files, OutputStream os) {
        this.files = files;
        this.zos = new ZipOutputStream(os);
        this.zos.setMethod(8);
        this.zos.setLevel(9);
    }

    @Override
    public void run() {
        byte[] data = new byte[2048];
        try {
            for (Map.Entry<String, InputStream> kv : this.files.entrySet()) {
                int count;
                ZipEntry entry = new ZipEntry(kv.getKey());
                InputStream origin = kv.getValue();
                this.zos.putNextEntry(entry);
                while ((count = origin.read(data, 0, 2048)) != -1) {
                    this.zos.write(data, 0, count);
                }
                origin.close();
            }
            this.zos.close();
        }
        catch (IOException e) {
            for (Map.Entry<String, InputStream> kv : this.files.entrySet()) {
                InputStream origin = kv.getValue();
                try {
                    origin.close();
                }
                catch (IOException ioe) {
                    log.error((Object)("Impossible to close " + kv.getKey()));
                }
            }
            log.error((Object)"Impossible to compress in stream");
            throw new RuntimeException("Impossible to compress in stream");
        }
    }
}

