/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.dao.administration.programStrategy.ProgramDao;
import fr.ifremer.adagio.core.dao.administration.programStrategy.ProgramImpl;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.administration.user.PersonDao;
import fr.ifremer.adagio.core.dao.administration.user.PersonImpl;
import fr.ifremer.adagio.core.dao.data.measure.GearPhysicalMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.ObservedFishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.scientificCruise.ScientificCruise;
import fr.ifremer.adagio.core.dao.data.survey.scientificCruise.ScientificCruiseDao;
import fr.ifremer.adagio.core.dao.data.vessel.VesselDao;
import fr.ifremer.adagio.core.dao.data.vessel.VesselImpl;
import fr.ifremer.adagio.core.dao.data.vessel.feature.person.VesselPersonFeatures;
import fr.ifremer.adagio.core.dao.data.vessel.feature.physical.GearPhysicalFeatures;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagDao;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.adagio.core.dao.referential.VesselPersonRole;
import fr.ifremer.adagio.core.dao.referential.gear.GearDao;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.location.LocationDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.Pmfm;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmDao;
import fr.ifremer.adagio.core.dao.referential.pmfm.PmfmImpl;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueDao;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValueImpl;
import fr.ifremer.adagio.core.dao.technical.synchronization.SynchronizationStatus;
import fr.ifremer.tutti.TuttiBusinessException;
import fr.ifremer.tutti.persistence.dao.GearPhysicalFeaturesDaoTutti;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Cruises;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrder;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrders;
import fr.ifremer.tutti.persistence.entities.referential.Gears;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.CruisePersistenceService;
import fr.ifremer.tutti.persistence.service.FishingOperationPersistenceService;
import fr.ifremer.tutti.persistence.service.ProgramPersistenceService;
import fr.ifremer.tutti.persistence.service.ReferentialPersistenceService;
import fr.ifremer.tutti.persistence.service.VesselPersonFeaturesPersistenceHelper;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.type.IntegerType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.nuiton.i18n.I18n;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="cruisePersistenceService")
public class CruisePersistenceServiceImpl
extends AbstractPersistenceService
implements CruisePersistenceService {
    private static final Log log = LogFactory.getLog(CruisePersistenceServiceImpl.class);
    @Autowired
    protected ReferentialPersistenceService referentialService;
    @Autowired
    protected ProgramPersistenceService programService;
    @Autowired
    protected FishingOperationPersistenceService fishingOperationService;
    @Autowired
    protected VesselPersonFeaturesPersistenceHelper vesselPersonFeaturesPersistenceHelper;
    @Resource(name="scientificCruiseDao")
    protected ScientificCruiseDao scientificCruiseDao;
    @Resource(name="programDao")
    protected ProgramDao programDao;
    @Resource(name="personDao")
    protected PersonDao personDao;
    @Resource(name="vesselExtendDao")
    protected VesselDao vesselDao;
    @Resource(name="locationDao")
    protected LocationDao locationDao;
    @Resource(name="qualityFlagDao")
    protected QualityFlagDao qualityFlagDao;
    @Resource(name="pmfmDao")
    protected PmfmDao pmfmDao;
    @Resource(name="qualitativeValueDao")
    protected QualitativeValueDao qualitativeValueDao;
    @Resource(name="gearDao")
    protected GearDao gearDao;
    @Resource(name="gearPhysicalFeaturesDaoTutti")
    protected GearPhysicalFeaturesDaoTutti gearPhysicalFeaturesDao;

    @Override
    public List<Cruise> getAllCruise(String programId) {
        Iterator<Object[]> list = this.queryList("allCruises", "programCode", StringType.INSTANCE, programId);
        ArrayList result = Lists.newArrayList();
        while (list.hasNext()) {
            Object[] source = list.next();
            Cruise target = Cruises.newCruise();
            target.setId(String.valueOf(source[0]));
            target.setName((String)source[1]);
            target.setBeginDate((Date)source[2]);
            result.add(target);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Cruise getCruise(String id) {
        Object[] source = this.queryUnique("cruise", "cruiseId", IntegerType.INSTANCE, Integer.valueOf(id), "pmfmIdSurveyPart", IntegerType.INSTANCE, this.enumeration.PMFM_ID_SURVEY_PART);
        if (source == null) {
            throw new DataRetrievalFailureException("Could not retrieve cruise with id=" + id);
        }
        Cruise result = Cruises.newCruise();
        result.setId(id);
        int index = 0;
        Integer departureLocationId = (Integer)source[index++];
        TuttiLocation departureLocation = this.referentialService.getLocation(String.valueOf(departureLocationId));
        result.setDepartureLocation(departureLocation);
        Integer returnLocationId = (Integer)source[index++];
        TuttiLocation returnLocation = this.referentialService.getLocation(String.valueOf(returnLocationId));
        result.setReturnLocation(returnLocation);
        String programCode = (String)source[index++];
        Program program = this.programService.getProgram(programCode);
        result.setProgram(program);
        result.setName((String)source[index++]);
        result.setBeginDate((Date)source[index++]);
        result.setEndDate((Date)source[index++]);
        String vesselCode = (String)source[index++];
        Vessel vessel = this.referentialService.getVessel(vesselCode);
        result.setVessel(vessel);
        ArrayList headOfMissions = Lists.newArrayList();
        result.setHeadOfMission(headOfMissions);
        ArrayList headOfSortRoom = Lists.newArrayList();
        result.setHeadOfSortRoom(headOfSortRoom);
        Integer managerId = (Integer)source[index++];
        fr.ifremer.tutti.persistence.entities.referential.Person manager = this.referentialService.getPerson(managerId);
        headOfMissions.add(manager);
        result.setComment((String)source[index++]);
        result.setSurveyPart((String)source[index]);
        if (result.getGear() == null) {
            Iterator<Object[]> list = this.queryList("allCruiseGears", "cruiseId", IntegerType.INSTANCE, Integer.valueOf(id), "pmfmIdTrawlNet", IntegerType.INSTANCE, this.enumeration.PMFM_ID_MULTIRIG_NUMBER);
            ArrayList gears = Lists.newArrayList();
            int maxMultirigNumberFound = 0;
            while (list.hasNext()) {
                Object[] gearRow = list.next();
                Gear simpleGear = this.referentialService.getGear((Integer)gearRow[0]);
                Object target = GearWithOriginalRankOrders.newGearWithOriginalRankOrder(simpleGear);
                target.setRankOrder((Short)gearRow[1]);
                Float multirigNumber = (Float)gearRow[2];
                if (multirigNumber != null && multirigNumber.intValue() > maxMultirigNumberFound) {
                    maxMultirigNumberFound = multirigNumber.intValue();
                }
                gears.add(target);
            }
            result.setGear(gears);
            if (maxMultirigNumberFound > 0) {
                result.setMultirigNumber(maxMultirigNumberFound);
            }
        }
        Iterator<Object[]> vesselPersonFeaturesList = this.queryList("allCruiseVesselPersonFeatures", "cruiseId", IntegerType.INSTANCE, Integer.valueOf(id));
        while (vesselPersonFeaturesList.hasNext()) {
            Object[] vesselPersonFeatures = vesselPersonFeaturesList.next();
            Integer personId = (Integer)vesselPersonFeatures[0];
            fr.ifremer.tutti.persistence.entities.referential.Person person = this.referentialService.getPerson(personId);
            Integer roleId = (Integer)vesselPersonFeatures[1];
            if (this.enumeration.VESSEL_PERSON_ROLE_ID_SCIENTIFIC_CRUISE_MANAGER.equals(roleId)) {
                headOfMissions.add(person);
                continue;
            }
            if (!this.enumeration.VESSEL_PERSON_ROLE_ID_SORT_ROOM_MANAGER.equals(roleId)) continue;
            headOfSortRoom.add(person);
        }
        if (result.getMultirigNumber() == null) {
            log.warn((Object)MessageFormat.format("Cruise with id={0} has been load with a default multirigNumber=1, beacause not multirigNumber were found in database.", id));
            result.setMultirigNumber(1);
        }
        return result;
    }

    @Override
    public Cruise createCruise(Cruise bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0, (Object)"Cruise 'id' must be null to call createCruise().");
        Preconditions.checkNotNull((Object)bean.getProgram());
        Preconditions.checkNotNull((Object)bean.getBeginDate());
        Preconditions.checkNotNull((Object)bean.getEndDate());
        Preconditions.checkNotNull((Object)bean.getDepartureLocation());
        Preconditions.checkNotNull((Object)bean.getReturnLocation());
        Preconditions.checkNotNull((Object)bean.getVessel());
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty(bean.getHeadOfMission()));
        ScientificCruise scientificCruise = ScientificCruise.Factory.newInstance();
        this.cruiseToEntity(bean, scientificCruise);
        this.scientificCruiseDao.create(scientificCruise);
        bean.setId(String.valueOf(scientificCruise.getId()));
        return bean;
    }

    @Override
    public Cruise saveCruise(Cruise bean, boolean updateVessel, boolean updateGear) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId(), (Object)"Cruise 'id' must not be null or empty to be saved.");
        Preconditions.checkNotNull((Object)bean.getProgram());
        Preconditions.checkNotNull((Object)bean.getBeginDate());
        Preconditions.checkNotNull((Object)bean.getEndDate());
        Preconditions.checkNotNull((Object)bean.getDepartureLocation());
        Preconditions.checkNotNull((Object)bean.getReturnLocation());
        Preconditions.checkNotNull((Object)bean.getVessel());
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty(bean.getHeadOfMission()));
        ScientificCruise scientificCruise = this.scientificCruiseDao.load(Integer.valueOf(bean.getId()));
        if (scientificCruise == null) {
            throw new DataRetrievalFailureException("Could not retrieve cruise with id=" + bean.getId());
        }
        this.cruiseToEntity(bean, scientificCruise);
        this.scientificCruiseDao.update(scientificCruise);
        if (updateVessel) {
            Vessel vessel = bean.getVessel();
            if (log.isInfoEnabled()) {
                log.info((Object)("Change vessel to " + vessel.getId() + " for cruise: " + bean.getId()));
            }
            this.queryUpdate("updateOperationsVessel", "cruiseId", IntegerType.INSTANCE, scientificCruise.getId(), "vesselId", StringType.INSTANCE, scientificCruise.getVessel().getCode());
        }
        if (updateGear) {
            for (GearWithOriginalRankOrder gear : bean.getGear()) {
                Short originalRankOrder = gear.getOriginalRankOrder();
                Short newRankOrder = gear.getRankOrder();
                if (originalRankOrder == null || originalRankOrder == 0 || !ObjectUtils.notEqual((Object)originalRankOrder, (Object)newRankOrder)) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Change gear " + gear.getId() + ", old rankOrder:" + originalRankOrder + " to " + newRankOrder + " for cruise: " + bean.getId()));
                }
                this.queryUpdate("updateOperationsGear", "cruiseId", IntegerType.INSTANCE, scientificCruise.getId(), "gearId", IntegerType.INSTANCE, gear.getIdAsInt(), "oldRankOrder", ShortType.INSTANCE, originalRankOrder, "newRankOrder", ShortType.INSTANCE, newRankOrder);
            }
        }
        return bean;
    }

    @Override
    public CaracteristicMap getGearCaracteristics(String cruiseId, String gearId, short rankOrder) {
        Preconditions.checkNotNull((Object)cruiseId, (Object)"Cruise 'id' must not be null or empty");
        Preconditions.checkNotNull((Object)gearId, (Object)"Gear 'id' must not be null or empty");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Get caracteristic for gear " + gearId + " - " + rankOrder));
        }
        CaracteristicMap result = new CaracteristicMap();
        Iterator list = this.queryListTyped("gearCaracteristics", "cruiseId", IntegerType.INSTANCE, Integer.valueOf(cruiseId), "gearId", IntegerType.INSTANCE, Integer.valueOf(gearId), "rankOrder", ShortType.INSTANCE, rankOrder);
        while (list.hasNext()) {
            GearPhysicalMeasurement measurement = (GearPhysicalMeasurement)list.next();
            Integer pmfmId = measurement.getPmfm().getId();
            if (this.enumeration.PMFM_ID_MULTIRIG_NUMBER.equals(pmfmId)) continue;
            Caracteristic caracteristic = this.referentialService.getCaracteristic(pmfmId);
            Object value = null;
            switch (caracteristic.getCaracteristicType()) {
                case NUMBER: {
                    value = measurement.getNumericalValue();
                    break;
                }
                case QUALITATIVE: {
                    QualitativeValue qualitativeValue = measurement.getQualitativeValue();
                    if (qualitativeValue == null) break;
                    value = TuttiEntities.getQualitativeValue(caracteristic, qualitativeValue.getId());
                    break;
                }
                case TEXT: {
                    value = measurement.getAlphanumericalValue();
                }
            }
            result.put(caracteristic, value);
        }
        return result;
    }

    @Override
    public void saveGearCaracteristics(Gear gear, Cruise cruise) {
        CaracteristicMap caracteristicMap;
        GearPhysicalFeatures gpf;
        Preconditions.checkNotNull((Object)cruise);
        Preconditions.checkNotNull((Object)cruise.getId(), (Object)"Cruise 'id' must not be null or empty");
        Preconditions.checkNotNull((Object)gear);
        Preconditions.checkNotNull((Object)gear.getId(), (Object)"Gear 'id' must not be null or empty");
        short rankOrder = gear.getRankOrder() == null ? (short)1 : gear.getRankOrder();
        ScientificCruise scientificCruise = this.scientificCruiseDao.load(cruise.getIdAsInt());
        if (scientificCruise == null) {
            throw new DataRetrievalFailureException("Could not retrieve cruise with id=" + cruise.getId());
        }
        ObservedFishingTrip fishingTrip = (ObservedFishingTrip)scientificCruise.getFishingTrips().iterator().next();
        Preconditions.checkNotNull((Object)fishingTrip);
        ArrayList measurementsToRemove = Lists.newArrayList();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Save caracteristic for gear " + gear.getIdAsInt() + " - " + rankOrder));
        }
        if ((gpf = this.gearPhysicalFeaturesDao.getGearPhysicalfeatures((FishingTrip)fishingTrip, gear.getIdAsInt(), rankOrder, true)).getGearPhysicalMeasurements() != null) {
            for (GearPhysicalMeasurement measurement : gpf.getGearPhysicalMeasurements()) {
                Integer pmfmId = measurement.getPmfm().getId();
                if (this.enumeration.PMFM_ID_MULTIRIG_NUMBER.equals(pmfmId)) continue;
                measurementsToRemove.add(pmfmId);
            }
        }
        if ((caracteristicMap = gear.getCaracteristics()) != null) {
            for (Caracteristic caracteristic : caracteristicMap.keySet()) {
                Float numericalValue = null;
                String alphanumericalValue = null;
                Integer qualitativeValue = null;
                Object value = caracteristicMap.get(caracteristic);
                switch (caracteristic.getCaracteristicType()) {
                    case NUMBER: {
                        numericalValue = (Float)value;
                        break;
                    }
                    case QUALITATIVE: {
                        Integer qvId = null;
                        if (value instanceof CaracteristicQualitativeValue) {
                            qvId = Integer.valueOf(((CaracteristicQualitativeValue)value).getId());
                        } else if (value instanceof Integer) {
                            qvId = (Integer)value;
                        }
                        qualitativeValue = qvId;
                        break;
                    }
                    case TEXT: {
                        alphanumericalValue = (String)value;
                    }
                }
                GearPhysicalMeasurement gearPhysicalMeasurement = this.gearPhysicalFeaturesDao.setGearPhysicalMeasurement(scientificCruise, gpf, caracteristic.getIdAsInt(), numericalValue, alphanumericalValue, qualitativeValue);
                measurementsToRemove.remove(gearPhysicalMeasurement.getPmfm().getId());
            }
        }
        for (Integer pmfmId : measurementsToRemove) {
            this.gearPhysicalFeaturesDao.removeGearPhysicalMeasurement(gpf, pmfmId);
        }
        this.gearPhysicalFeaturesDao.update(gpf);
    }

    @Override
    public boolean isOperationUseGears(Integer cruiseId, Collection<Gear> gears) {
        Preconditions.checkNotNull((Object)cruiseId);
        Preconditions.checkNotNull(gears);
        boolean result = false;
        if (!gears.isEmpty()) {
            List<Integer> gearIds = TuttiEntities.toIntegerIds(gears);
            Iterator<Object[]> list = this.queryList("allFishingOperationsWithGear", "cruiseId", IntegerType.INSTANCE, cruiseId, "gearIds", IntegerType.INSTANCE, gearIds);
            while (list.hasNext()) {
                Object[] next = list.next();
                Object g = GearWithOriginalRankOrders.newGearWithOriginalRankOrder((Integer)next[0], (Short)next[1]);
                if (!gears.contains(g)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    protected void cruiseToEntity(Cruise source, ScientificCruise target) {
        ObservedFishingTrip fishingTrip;
        QualityFlag qualityFlagNotQualified = (QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED));
        if (target.getFishingTrips() == null || target.getFishingTrips().size() == 0) {
            fishingTrip = ObservedFishingTrip.Factory.newInstance();
            if (target.getFishingTrips() == null) {
                target.setFishingTrips((Collection)Lists.newArrayList((Object[])new FishingTrip[]{fishingTrip}));
                fishingTrip.setScientificCruise(target);
            } else {
                target.getFishingTrips().add(fishingTrip);
                fishingTrip.setScientificCruise(target);
            }
        } else {
            fishingTrip = (ObservedFishingTrip)target.getFishingTrips().iterator().next();
        }
        target.setName(source.getName());
        ProgramImpl program = this.load(ProgramImpl.class, (Serializable)((Object)source.getProgram().getId()));
        target.setProgram((fr.ifremer.adagio.core.dao.administration.programStrategy.Program)program);
        VesselImpl vessel = this.load(VesselImpl.class, (Serializable)((Object)source.getVessel().getId()));
        target.setVessel((fr.ifremer.adagio.core.dao.data.vessel.Vessel)vessel);
        target.setDepartureDateTime(this.dateWithNoSecondAndMiliSecond(source.getBeginDate()));
        target.setReturnDateTime(this.dateWithNoSecondAndMiliSecond(source.getEndDate()));
        target.setComments(source.getComment());
        if (target.getManagerPerson() == null) {
            target.setManagerPerson((Person)this.load(PersonImpl.class, this.enumeration.PERSON_ID_UNKNOWN_RECORDER_PERSON));
        }
        target.setSynchronizationStatus(SynchronizationStatus.DIRTY.getValue());
        if (target.getCreationDate() == null) {
            target.setCreationDate(this.newCreateDate());
        }
        if (target.getManagerPerson() != null) {
            target.setRecorderPerson(target.getManagerPerson());
            target.setRecorderDepartment(target.getManagerPerson().getDepartment());
        }
        fishingTrip.setDepartureDateTime(target.getDepartureDateTime());
        fishingTrip.setReturnDateTime(target.getReturnDateTime());
        fishingTrip.setVessel(target.getVessel());
        fishingTrip.setProgram(target.getProgram());
        fishingTrip.setRecorderPerson(target.getRecorderPerson());
        fishingTrip.setRecorderDepartment(target.getRecorderDepartment());
        fishingTrip.setCreationDate(target.getCreationDate());
        fishingTrip.setSynchronizationStatus(target.getSynchronizationStatus());
        fishingTrip.setQualityFlag(qualityFlagNotQualified);
        Location departureLocation = (Location)this.load(LocationImpl.class, Integer.valueOf(source.getDepartureLocation().getId()));
        fishingTrip.setDepartureLocation(departureLocation);
        Location returnLocation = (Location)this.load(LocationImpl.class, Integer.valueOf(source.getReturnLocation().getId()));
        fishingTrip.setReturnLocation(returnLocation);
        this.setSurveyMeasurement((FishingTrip)fishingTrip, this.enumeration.PMFM_ID_SURVEY_PART, null, source.getSurveyPart(), null);
        if (source.isGearEmpty() && fishingTrip.getGearPhysicalFeatures() != null) {
            fishingTrip.getGearPhysicalFeatures().clear();
        } else if (!source.isGearEmpty()) {
            HashSet notChangedGearPhysicalFeatures = Sets.newHashSet();
            if (fishingTrip.getGearPhysicalFeatures() != null) {
                notChangedGearPhysicalFeatures.addAll(fishingTrip.getGearPhysicalFeatures());
            }
            short gearRankOrder = 1;
            for (GearWithOriginalRankOrder gear : source.getGear()) {
                Short rankOrder = gear.getRankOrder();
                GearPhysicalFeatures guf = this.gearPhysicalFeaturesDao.getGearPhysicalfeatures((FishingTrip)fishingTrip, gear.getIdAsInt(), gear.getOriginalRankOrder(), false);
                if (guf == null) {
                    guf = this.gearPhysicalFeaturesDao.getGearPhysicalfeatures((FishingTrip)fishingTrip, gear.getIdAsInt(), rankOrder, true);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Will create guf: " + guf.getId() + " for gear: " + gear.getId() + " - " + gear.getRankOrder()));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Will update guf: " + guf.getId() + " for gear: " + gear.getId() + " - " + gear.getOriginalRankOrder() + ", new rankOrder: " + gear.getRankOrder()));
                }
                notChangedGearPhysicalFeatures.remove(guf);
                guf.setStartDate(fishingTrip.getDepartureDateTime());
                guf.setEndDate(fishingTrip.getReturnDateTime());
                guf.setVessel(fishingTrip.getVessel());
                guf.setProgram(fishingTrip.getProgram());
                guf.setCreationDate(target.getCreationDate());
                guf.setQualityFlag(qualityFlagNotQualified);
                short s = gearRankOrder;
                gearRankOrder = (short)(gearRankOrder + 1);
                guf.setRankOrder(Short.valueOf(s));
                if (source.getMultirigNumber() == null) {
                    this.gearPhysicalFeaturesDao.removeGearPhysicalMeasurement(guf, this.enumeration.PMFM_ID_MULTIRIG_NUMBER);
                    continue;
                }
                this.gearPhysicalFeaturesDao.setGearPhysicalMeasurement(target, guf, this.enumeration.PMFM_ID_MULTIRIG_NUMBER, Float.valueOf(source.getMultirigNumber().intValue()), null, null);
            }
            if (fishingTrip.getGearPhysicalFeatures() != null && notChangedGearPhysicalFeatures.size() > 0) {
                List gears = Lists.transform((List)Lists.newArrayList((Iterable)notChangedGearPhysicalFeatures), (Function)new Function<GearPhysicalFeatures, Gear>(){

                    public Gear apply(GearPhysicalFeatures input) {
                        Gear result = Gears.newGear();
                        if (input != null && input.getGear() != null) {
                            result.setRankOrder(input.getRankOrder());
                            result.setId(input.getGear().getId());
                        }
                        return result;
                    }
                });
                boolean gearRemoved = this.isOperationUseGears(target.getId(), gears);
                if (gearRemoved) {
                    throw new TuttiBusinessException(I18n._((String)"tutti.persistence.cruise.gearUsedInOperations.error", (Object[])new Object[0]));
                }
                for (GearPhysicalFeatures guf : notChangedGearPhysicalFeatures) {
                    if (guf.getGearPhysicalMeasurements() != null) {
                        guf.getGearPhysicalMeasurements().clear();
                    }
                    fishingTrip.getGearPhysicalFeatures().remove(guf);
                }
            }
        }
        LinkedHashMap vesselPersonFeaturesMap = Maps.newLinkedHashMap();
        VesselPersonRole scientificCruiseManagerRole = this.vesselPersonFeaturesPersistenceHelper.getScientificCruiseManagerRole();
        VesselPersonRole sortRoomManagerRole = this.vesselPersonFeaturesPersistenceHelper.getSortRoomManagerRole();
        short personRankOrder = 1;
        List<fr.ifremer.tutti.persistence.entities.referential.Person> persons = source.getHeadOfMission();
        target.setManagerPerson((Person)this.load(PersonImpl.class, persons.get(0).getIdAsInt()));
        for (int i = 1; i < persons.size(); ++i) {
            Integer personId = persons.get(i).getIdAsInt();
            short s = personRankOrder;
            personRankOrder = (short)(personRankOrder + 1);
            this.vesselPersonFeaturesPersistenceHelper.fillVesselPersonFeatures((Map<Integer, VesselPersonFeatures>)vesselPersonFeaturesMap, personId, (FishingTrip)fishingTrip, scientificCruiseManagerRole, s);
        }
        if (CollectionUtils.isNotEmpty(source.getHeadOfSortRoom())) {
            for (fr.ifremer.tutti.persistence.entities.referential.Person person : source.getHeadOfSortRoom()) {
                Integer personId = person.getIdAsInt();
                short s = personRankOrder;
                personRankOrder = (short)(personRankOrder + 1);
                this.vesselPersonFeaturesPersistenceHelper.fillVesselPersonFeatures((Map<Integer, VesselPersonFeatures>)vesselPersonFeaturesMap, personId, (FishingTrip)fishingTrip, sortRoomManagerRole, s);
            }
        }
        if (fishingTrip.getVesselPersonFeatures() == null) {
            fishingTrip.setVesselPersonFeatures((Collection)Sets.newHashSet());
        }
        fishingTrip.getVesselPersonFeatures().clear();
        fishingTrip.getVesselPersonFeatures().addAll(vesselPersonFeaturesMap.values());
    }

    protected SurveyMeasurement getOrCreateSurveyMeasurement(FishingTrip fishingTrip, Integer pmfmId) {
        SurveyMeasurement result = null;
        for (SurveyMeasurement vum : fishingTrip.getSurveyMeasurements()) {
            if (!pmfmId.equals(vum.getPmfm().getId())) continue;
            result = vum;
            break;
        }
        if (result == null) {
            result = SurveyMeasurement.Factory.newInstance();
            result.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)this.enumeration.QUALITY_FLAG_CODE_NOT_QUALIFIED)));
            result.setDepartment(fishingTrip.getRecorderDepartment());
            Pmfm pmfm = (Pmfm)this.load(PmfmImpl.class, pmfmId);
            result.setPmfm(pmfm);
            result.setFishingTrip(fishingTrip);
            if (fishingTrip.getSurveyMeasurements() == null) {
                fishingTrip.setSurveyMeasurements((Collection)Sets.newHashSet());
            }
            fishingTrip.getSurveyMeasurements().add(result);
        }
        return result;
    }

    protected SurveyMeasurement setSurveyMeasurement(FishingTrip fishingTrip, Integer pmfmId, Float numericalValue, String alphanumericalValue, Integer qualitativevalueId) {
        SurveyMeasurement result = this.getOrCreateSurveyMeasurement(fishingTrip, pmfmId);
        if (alphanumericalValue != null) {
            result.setAlphanumericalValue(alphanumericalValue);
        } else if (numericalValue != null) {
            result.setNumericalValue(numericalValue);
        } else if (qualitativevalueId != null) {
            result.setQualitativeValue((QualitativeValue)this.load(QualitativeValueImpl.class, qualitativevalueId));
        }
        return result;
    }
}

