/*
 * Decompiled with CFR 0.152.
 */
package liquibase.precondition.core;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.precondition.Precondition;

public class RunningAsPrecondition
implements Precondition {
    private String username = "";

    public void setUsername(String aUserName) {
        this.username = aUserName;
    }

    public String getUsername() {
        return this.username;
    }

    public Warnings warn(Database database) {
        return new Warnings();
    }

    public ValidationErrors validate(Database database) {
        return new ValidationErrors();
    }

    public void check(Database database, DatabaseChangeLog changeLog, ChangeSet changeSet) throws PreconditionFailedException, PreconditionErrorException {
        String loggedusername = database.getConnection().getConnectionUserName();
        if (loggedusername.indexOf(64) >= 0) {
            loggedusername = loggedusername.substring(0, loggedusername.indexOf(64));
        }
        if (!this.username.equalsIgnoreCase(loggedusername)) {
            throw new PreconditionFailedException("RunningAs Precondition failed: expected " + this.username + ", was " + loggedusername, changeLog, this);
        }
    }

    public String getName() {
        return "runningAs";
    }
}

