/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.TableColumnModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.sort.TableSortController;

public abstract class AbstractTuttiBatchTableUIHandler<R extends AbstractTuttiBeanUIModel, M extends AbstractTuttiBatchUIModel<R, M>, UI extends TuttiUI<M, ?>>
extends AbstractTuttiTableUIHandler<R, M, UI> {
    protected abstract ColumnIdentifier<R> getCommentIdentifier();

    protected abstract ColumnIdentifier<R> getAttachementIdentifier();

    public abstract void selectFishingOperation(FishingOperation var1);

    protected AbstractTuttiBatchTableUIHandler(TuttiUI<?, ?> parentUi, UI ui, String ... properties) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui, properties);
    }

    public final void clearTableSelection() {
        JXTable table = this.getTable();
        if (table.isEditing()) {
            table.editingCanceled(null);
        }
        table.clearSelection();
    }

    @Override
    protected void onRowModified(int rowIndex, R row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        this.saveSelectedRowIfNeeded();
    }

    protected void initBatchTable(JXTable table, TableColumnModel columnModel, AbstractTuttiTableModel<R> tableModel) {
        this.installTableKeyListener(columnModel, (JTable)table);
        TableSortController sorter = new TableSortController(tableModel);
        sorter.setSortable(false);
        table.setRowSorter((RowSorter)sorter);
        this.initTable(table);
    }

    @Override
    protected void addHighlighters(JXTable table) {
        super.addHighlighters(table);
        this.addCommentHighlighter(table, this.getCommentIdentifier());
        this.addAttachementHighlighter(table, this.getAttachementIdentifier());
    }

    protected void addCommentHighlighter(JXTable table, ColumnIdentifier identifier) {
        Color cellWithValueColor = this.getConfig().getColorCellWithValue();
        Highlighter commentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{identifier}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                String value = (String)adapter.getValue();
                return StringUtils.isNotBlank((CharSequence)value);
            }
        }}), cellWithValueColor);
        table.addHighlighter(commentHighlighter);
    }

    protected void addAttachementHighlighter(JXTable table, ColumnIdentifier identifier) {
        Color cellWithValueColor = this.getConfig().getColorCellWithValue();
        Highlighter attachmentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{identifier}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Collection attachments = (Collection)adapter.getValue();
                return CollectionUtils.isNotEmpty((Collection)attachments);
            }
        }}), cellWithValueColor);
        table.addHighlighter(attachmentHighlighter);
    }
}

