/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModel;
import fr.ifremer.tutti.persistence.entities.data.SampleCategoryModelEntry;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.WeightUnit;
import fr.ifremer.tutti.service.catches.ValidateCruiseOperationsService;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryAble;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryColumnIdentifier;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SampleCategoryComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.TableViewMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.create.CreateSpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.split.SplitSpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellEditor;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.editor.TuttiComputedOrNotDataTableCell;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUIModel;
import fr.ifremer.tutti.ui.swing.util.table.AbstractSelectTableAction;
import fr.ifremer.tutti.ui.swing.util.table.ColumnIdentifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.renderer.DecoratorListCellRenderer;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorResult;

public class SpeciesBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<SpeciesBatchRowModel, SpeciesBatchUIModel, SpeciesBatchUI> {
    private static final Log log = LogFactory.getLog(SpeciesBatchUIHandler.class);
    private final EnumMap<TableViewMode, RowFilter<SpeciesBatchTableModel, Integer>> tableFilters;
    protected ValidationService validationService;
    protected ValidateCruiseOperationsService validationCruiseService;
    protected final EditCatchesUI parentUi;
    protected final SampleCategoryModel sampleCategoryModel;
    protected final WeightUnit weightUnit;
    protected final Integer qualitative_unsorted_id;

    public SpeciesBatchUIHandler(EditCatchesUI parentUi, SpeciesBatchUI ui) {
        super(parentUi, ui, "species", "weight", "number", "comment", "attachment", "sampleCategoryWeight", "frequency", "speciesToConfirm");
        this.qualitative_unsorted_id = this.context.getPersistenceService().getEnumerationFile().QUALITATIVE_UNSORTED_ID;
        this.weightUnit = this.getConfig().getSpeciesWeightUnit();
        this.sampleCategoryModel = this.getDataContext().getSampleCategoryModel();
        this.parentUi = parentUi;
        this.tableFilters = new EnumMap(TableViewMode.class);
        this.tableFilters.put(TableViewMode.ALL, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                return true;
            }
        });
        this.tableFilters.put(TableViewMode.ROOT, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                boolean result = false;
                Integer rowIndex = entry.getIdentifier();
                if (rowIndex != null) {
                    SpeciesBatchTableModel model = entry.getModel();
                    SpeciesBatchRowModel row = (SpeciesBatchRowModel)model.getEntry(rowIndex);
                    result = row != null && row.isBatchRoot();
                }
                return result;
            }
        });
        this.tableFilters.put(TableViewMode.LEAF, new RowFilter<SpeciesBatchTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends SpeciesBatchTableModel, ? extends Integer> entry) {
                boolean result = false;
                Integer rowIndex = entry.getIdentifier();
                if (rowIndex != null) {
                    SpeciesBatchTableModel model = entry.getModel();
                    SpeciesBatchRowModel row = (SpeciesBatchRowModel)model.getEntry(rowIndex);
                    result = row != null && row.isBatchLeaf();
                }
                return result;
            }
        });
        this.validationCruiseService = this.getContext().getValidateCruiseOperationsService();
        this.validationService = this.getContext().getValidationService();
    }

    public EditCatchesUI getParentUi() {
        return this.parentUi;
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        if (empty) {
            rows = null;
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Get species batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew((TuttiEntity)bean)) {
                BatchContainer rootSpeciesBatch = this.persistenceService.getRootSpeciesBatch(bean.getId(), this.sampleCategoryModel);
                List catches = rootSpeciesBatch.getChildren();
                Integer firstCategoryId = this.sampleCategoryModel.getFirstCategoryId();
                for (SpeciesBatch aBatch : catches) {
                    Preconditions.checkState((boolean)firstCategoryId.equals(aBatch.getSampleCategoryId()), (Object)("Root species batch must be a sortedUnsorted sample category but was:" + aBatch.getSampleCategoryId()));
                    SpeciesBatchRowModel rootRow = this.loadBatch(aBatch, null, rows);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Loaded root batch " + this.decorate(rootRow.getSpecies(), "fromProtocol") + " - " + this.decorate(rootRow.getSampleCategoryById(firstCategoryId))));
                }
            }
        }
        model.setRows(rows);
    }

    public SpeciesBatchTableModel getTableModel() {
        return (SpeciesBatchTableModel)this.getTable().getModel();
    }

    @Override
    public JXTable getTable() {
        return ((SpeciesBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(SpeciesBatchRowModel row) {
        boolean result;
        SpeciesBatch batch = this.convertRowToEntity(row, true);
        NuitonValidatorResult validator = this.validationService.validateSpeciesBatch(batch);
        boolean bl = result = !validator.hasErrorMessagess();
        if (result && "validate".equals(this.getContext().getValidationContext()) && row.isBatchLeaf()) {
            List<SpeciesBatchFrequency> frequencies = SpeciesFrequencyRowModel.toEntity(row.getFrequency(), batch);
            result = this.validationCruiseService.isSpeciesBatchValid(batch, frequencies);
        }
        return result;
    }

    @Override
    protected void onRowModified(int rowIndex, SpeciesBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        if ("sampleCategoryWeight".equals(propertyName)) {
            SampleCategoryAble firstAncestorRow;
            SampleCategory sampleCategory = (SampleCategory)newValue;
            Integer sampleCategoryId = sampleCategory.getCategoryId();
            SpeciesBatchTableModel tableModel = this.getTableModel();
            int firstAncestorIndex = tableModel.getRowIndex(firstAncestorRow = row.getFirstAncestor(sampleCategory));
            if (rowIndex != firstAncestorIndex) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Sample category " + sampleCategoryId + " weight was modified, First ancestor row: " + firstAncestorIndex + " will save it"));
                }
                this.saveRow((SpeciesBatchRowModel)firstAncestorRow);
                this.cleanrRowMonitor();
                return;
            }
        }
        this.saveSelectedRowIfNeeded();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<SpeciesBatchRowModel> rowMonitor, SpeciesBatchRowModel row) {
        if (rowMonitor.wasModified()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Row " + row + " was modified, will save it"));
            }
            this.showInformationMessage("[ Captures - Esp\u00e8ces ] Sauvegarde des modifications de " + row + '.');
            rowMonitor.setBean(null);
            this.saveRow(row);
            rowMonitor.setBean(row);
            rowMonitor.clearModified();
        }
    }

    @Override
    protected void onModelRowsChanged(List<SpeciesBatchRowModel> rows) {
        super.onModelRowsChanged(rows);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setRootNumber(0);
        for (SpeciesBatchRowModel row : rows) {
            this.updateTotalFromFrequencies(row);
            if (!row.isBatchRoot()) continue;
            this.addToSpeciesUsed(row);
        }
    }

    @Override
    protected void addHighlighters(JXTable table) {
        super.addHighlighters(table);
        Color toConfirmColor = this.getConfig().getColorRowToConfirm();
        Highlighter confirmHighlighter = TuttiUIUtil.newBackgroundColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                SpeciesBatchRowModel row = (SpeciesBatchRowModel)SpeciesBatchUIHandler.this.getTableModel().getEntry(adapter.row);
                return row.isSpeciesToConfirm();
            }
        }, toConfirmColor);
        table.addHighlighter(confirmHighlighter);
        Highlighter selectedHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.IS_SELECTED, new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{SpeciesBatchTableModel.SPECIES})}), UIManager.getColor("Table[Enabled+Selected].textBackground"));
        table.addHighlighter(selectedHighlighter);
        Highlighter confirmNotEditableHighlighter = TuttiUIUtil.newBackgroundColorHighlighter(new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                SpeciesBatchRowModel row = (SpeciesBatchRowModel)SpeciesBatchUIHandler.this.getTableModel().getEntry(adapter.row);
                return row.isSpeciesToConfirm() && !adapter.isEditable();
            }
        }, toConfirmColor.darker());
        table.addHighlighter(confirmNotEditableHighlighter);
        Color cellWithValueColor = this.getConfig().getColorCellWithValue();
        Highlighter commentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{SpeciesBatchTableModel.COMMENT}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                String value = (String)adapter.getValue();
                return StringUtils.isNotBlank((CharSequence)value);
            }
        }}), cellWithValueColor);
        table.addHighlighter(commentHighlighter);
        Highlighter attachmentHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{new HighlightPredicate.IdentifierHighlightPredicate(new Object[]{SpeciesBatchTableModel.ATTACHMENT}), new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Collection attachments = (Collection)adapter.getValue();
                return CollectionUtils.isNotEmpty((Collection)attachments);
            }
        }}), cellWithValueColor);
        table.addHighlighter(attachmentHighlighter);
    }

    @Override
    protected void beforeOpenPopup(int rowIndex, int columnIndex) {
        super.beforeOpenPopup(rowIndex, columnIndex);
        boolean enableRename = false;
        boolean enableSplit = false;
        boolean enableChangeSampleCategory = false;
        boolean enableAddSampleCategory = false;
        boolean enableRemove = false;
        boolean enableRemoveSub = false;
        boolean enableCreateMelag = false;
        boolean enableEditFrequencies = false;
        if (rowIndex != -1) {
            SpeciesBatchTableModel tableModel = this.getTableModel();
            SpeciesBatchRowModel row = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
            int selectedRowCount = this.getTable().getSelectedRowCount();
            enableSplit = true;
            enableRemove = selectedRowCount == 1;
            enableRemoveSub = selectedRowCount == 1;
            enableRename = selectedRowCount == 1;
            enableCreateMelag = selectedRowCount > 1;
            enableEditFrequencies = selectedRowCount == 1;
            enableChangeSampleCategory = selectedRowCount == 1 && tableModel.isCellEditable(rowIndex, columnIndex);
            boolean bl = enableAddSampleCategory = selectedRowCount == 1 && tableModel.isCellEditable(rowIndex, columnIndex);
            if (enableSplit) {
                Integer lastSamplingId = this.sampleCategoryModel.getLastCategoryId();
                enableSplit = row.isBatchLeaf() && selectedRowCount == 1 && ObjectUtils.notEqual((Object)lastSamplingId, (Object)row.getFinestCategory().getCategoryId()) && row.getNumber() == null && (row.getComputedNumber() == null || row.getComputedNumber() == 0);
            }
            boolean firstCategory = false;
            Integer sampleCategoryId = tableModel.getSampleCategoryId(columnIndex);
            SampleCategoryModelEntry category = null;
            ArrayList available = null;
            if (sampleCategoryId != null) {
                firstCategory = this.sampleCategoryModel.getFirstCategoryId().equals(sampleCategoryId);
                category = this.sampleCategoryModel.getCategoryById(sampleCategoryId);
                SpeciesBatchRowModel firstAncestorRow = row.getFirstAncestor(sampleCategoryId);
                Set<Serializable> used = this.getSampleUsedValues(firstAncestorRow, sampleCategoryId);
                available = Lists.newArrayList((Iterable)category.getCaracteristic().getQualitativeValue());
                available.removeAll(used);
                if (firstCategory) {
                    TuttiEntities.removeQualitativeValue((Collection)available, (int)this.qualitative_unsorted_id);
                }
            }
            if (enableChangeSampleCategory) {
                if (sampleCategoryId == null) {
                    enableChangeSampleCategory = false;
                } else if (!category.getCaracteristic().isNumericType()) {
                    enableChangeSampleCategory = CollectionUtils.isNotEmpty(available);
                }
            }
            if (enableAddSampleCategory) {
                if (sampleCategoryId == null || firstCategory) {
                    enableAddSampleCategory = false;
                } else if (!category.getCaracteristic().isNumericType()) {
                    enableAddSampleCategory = CollectionUtils.isNotEmpty(available);
                }
            }
            if (enableEditFrequencies) {
                enableEditFrequencies = row.isBatchLeaf();
            }
            if (enableRename) {
                enableRename = row.isBatchRoot();
            }
            if (enableRemove) {
                // empty if block
            }
            if (enableRemoveSub) {
                boolean bl2 = enableRemoveSub = !row.isBatchLeaf();
            }
            if (enableCreateMelag) {
                int[] selectedRows;
                JXTable table = this.getTable();
                for (int selectedRowIndex : selectedRows = table.getSelectedRows()) {
                    SpeciesBatchRowModel selectedRow = (SpeciesBatchRowModel)tableModel.getEntry(selectedRowIndex);
                    if (selectedRow.isBatchRoot()) continue;
                    enableCreateMelag = false;
                    break;
                }
            }
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setSplitBatchEnabled(enableSplit);
        model.setChangeSampleCategoryEnabled(enableChangeSampleCategory);
        model.setAddSampleCategoryEnabled(enableAddSampleCategory);
        model.setRemoveBatchEnabled(enableRemove);
        model.setRemoveSubBatchEnabled(enableRemoveSub);
        model.setRenameBatchEnabled(enableRename);
        model.setCreateMelagEnabled(enableCreateMelag);
        model.setEditFrequenciesEnabled(enableEditFrequencies);
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("actions for (" + rowIndex + "," + columnIndex + "):");
            builder.append("\nenableSplit:                ").append(enableSplit);
            builder.append("\nenableChangeSampleCategory: ").append(enableChangeSampleCategory);
            builder.append("\nenableAddSampleCategory:    ").append(enableAddSampleCategory);
            builder.append("\nenableRemove:               ").append(enableRemove);
            builder.append("\nenableRemoveSub:            ").append(enableRemoveSub);
            builder.append("\nenableRename:               ").append(enableRename);
            builder.append("\nenableCreateMelag:          ").append(enableCreateMelag);
            builder.append("\nenableEditFrequencies:      ").append(enableEditFrequencies);
            log.debug((Object)builder.toString());
        }
    }

    @Override
    public SwingValidator<SpeciesBatchUIModel> getValidator() {
        return ((SpeciesBatchUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("beforeInit: " + this.ui));
        }
        EditCatchesUIModel catchesUIModel = ((SpeciesBatchUI)this.ui).getContextValue(EditCatchesUIModel.class);
        SpeciesBatchUIModel model = new SpeciesBatchUIModel(catchesUIModel);
        model.setTableViewMode(TableViewMode.ALL);
        ((SpeciesBatchUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        List samplingOrder = this.sampleCategoryModel.getSamplingOrder();
        if (log.isInfoEnabled()) {
            log.info((Object)("Will use sampling order: " + samplingOrder));
        }
        JXTable table = this.getTable();
        table.setColumnControlVisible(true);
        TableCellRenderer defaultRenderer = table.getDefaultRenderer(Object.class);
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        Decorator<CaracteristicQualitativeValue> caracteristicDecorator = this.getDecorator(CaracteristicQualitativeValue.class, null);
        Color computedDataColor = this.getConfig().getColorComputedWeights();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Species.class, "fromProtocol"), SpeciesBatchTableModel.SPECIES);
        for (SampleCategoryModelEntry sampleCategoryDef : this.sampleCategoryModel.getCategory()) {
            SampleCategoryColumnIdentifier<SpeciesBatchRowModel> columnIdentifier = SampleCategoryColumnIdentifier.newId(sampleCategoryDef.getLabel(), sampleCategoryDef.getCategoryId(), I18n.n_((String)sampleCategoryDef.getLabel(), (Object[])new Object[0]), I18n.n_((String)sampleCategoryDef.getLabel(), (Object[])new Object[0]));
            this.addSampleCategoryColumnToModel((TableColumnModel)columnModel, columnIdentifier, caracteristicDecorator, defaultRenderer, this.weightUnit);
        }
        this.addColumnToModel((TableColumnModel)columnModel, TuttiComputedOrNotDataTableCell.newEditor(Float.class, this.weightUnit, computedDataColor), TuttiComputedOrNotDataTableCell.newRender(defaultRenderer, this.weightUnit, computedDataColor), SpeciesBatchTableModel.WEIGHT, this.weightUnit);
        this.addColumnToModel((TableColumnModel)columnModel, SpeciesFrequencyCellComponent.newEditor((SpeciesBatchUI)this.ui, computedDataColor), SpeciesFrequencyCellComponent.newRender(computedDataColor), SpeciesBatchTableModel.COMPUTED_NUMBER);
        this.addColumnToModel((TableColumnModel)columnModel, CommentCellEditor.newEditor(this.ui), CommentCellRenderer.newRender(), SpeciesBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(this.ui), AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null)), SpeciesBatchTableModel.ATTACHMENT);
        this.addBooleanColumnToModel((TableColumnModel)columnModel, SpeciesBatchTableModel.SPECIES_TO_CONFIRM, (JTable)this.getTable());
        SpeciesBatchTableModel tableModel = new SpeciesBatchTableModel(this.weightUnit, this.sampleCategoryModel, (TableColumnModelExt)columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModel)columnModel, tableModel);
        ((SpeciesBatchUIModel)this.getModel()).addPropertyChangeListener("tableViewMode", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TableViewMode tableViewMode = (TableViewMode)((Object)evt.getNewValue());
                if (tableViewMode == null) {
                    tableViewMode = TableViewMode.ALL;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Will use rowfilter for viewMode: " + (Object)((Object)tableViewMode)));
                }
                RowFilter filter = (RowFilter)SpeciesBatchUIHandler.this.tableFilters.get((Object)tableViewMode);
                SpeciesBatchUIHandler.this.getTable().setRowFilter(filter);
            }
        });
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((SpeciesBatchUI)this.getUI()).getTable();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing: " + this.ui));
        }
    }

    public void createBatch() {
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        CreateSpeciesBatchUI createBatchEditor = parent.getSpeciesTabCreateBatch();
        createBatchEditor.getHandler().openUI((SpeciesBatchUIModel)this.getModel());
        parent.getHandler().setSpeciesSelectedCard("createBatch");
    }

    public void addBatch(CreateSpeciesBatchUIModel batchRootRowModel) {
        if (batchRootRowModel.isValid()) {
            SpeciesBatchTableModel tableModel = this.getTableModel();
            SpeciesBatchRowModel newRow = tableModel.createNewRow();
            Species species = batchRootRowModel.getSpecies();
            newRow.setSpecies(species);
            newRow.setNumber(batchRootRowModel.getBatchCount());
            CaracteristicQualitativeValue sampleCategory = batchRootRowModel.getSampleCategory();
            SampleCategory<?> category = newRow.getFirstSampleCategory();
            category.setCategoryValue((Serializable)sampleCategory);
            category.setCategoryWeight(batchRootRowModel.getBatchWeight());
            newRow.setSampleCategory(category);
            this.recomputeRowValidState(newRow);
            this.saveRow(newRow);
            tableModel.addNewRow(newRow);
            AbstractSelectTableAction.doSelectCell((JTable)this.getTable(), tableModel.getRowCount() - 1, 0);
            this.addToSpeciesUsed(newRow);
            if (batchRootRowModel.getBatchCount() == null && batchRootRowModel.getSelectedCategory() != null) {
                this.splitBatch(batchRootRowModel.getSelectedCategory(), batchRootRowModel.getRows(), batchRootRowModel.getSampleWeight());
            }
        }
    }

    public void editFrequencies() {
        JXTable table = this.getTable();
        int rowIndex = table.getSelectedRow();
        TableColumnModelExt columnModel = (TableColumnModelExt)this.getTable().getColumnModel();
        int columnIndex = columnModel.getColumnIndex(SpeciesBatchTableModel.COMPUTED_NUMBER);
        AbstractSelectTableAction.doSelectCell((JTable)this.getTable(), rowIndex, columnIndex);
        SpeciesFrequencyCellComponent.FrequencyCellEditor cellEditor = (SpeciesFrequencyCellComponent.FrequencyCellEditor)columnModel.getColumnExt(columnIndex).getCellEditor();
        cellEditor.startEdit();
    }

    public void splitBatch() {
        JXTable table = this.getTable();
        int rowIndex = table.getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant split batch if no batch selected");
        SpeciesBatchTableModel tableModel = this.getTableModel();
        SpeciesBatchRowModel parentBatch = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
        boolean split = true;
        if (parentBatch.getWeight() != null) {
            String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n._((String)"tutti.editSpeciesBatch.split.weightNotNull.message", (Object[])new Object[0]), I18n._((String)"tutti.editSpeciesBatch.split.weightNotNull.help", (Object[])new Object[0]));
            int i = JOptionPane.showConfirmDialog(this.getTopestUI(), htmlMessage, I18n._((String)"tutti.editSpeciesBatch.split.weightNotNull.title", (Object[])new Object[0]), 2);
            if (i == 0) {
                parentBatch.setWeight(null);
            } else {
                split = false;
            }
        }
        if (split) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Open split batch ui for row [" + rowIndex + ']'));
            }
            EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
            SplitSpeciesBatchUI splitBatchEditor = parent.getSpeciesTabSplitBatch();
            parent.getHandler().splitSpeciesBatch(parentBatch, splitBatchEditor);
        }
    }

    public void addBatchCategory() {
        SpeciesBatchTableModel tableModel = this.getTableModel();
        int rowIndex = this.getTable().getSelectedRow();
        Preconditions.checkState((rowIndex != -1 ? 1 : 0) != 0, (Object)"Cant split batch if no batch selected");
        int columnIndex = this.getTable().getSelectedColumn();
        Preconditions.checkState((columnIndex != -1 ? 1 : 0) != 0, (Object)"Cant split batch if no batch selected");
        SpeciesBatchRowModel selectedRow = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
        Integer sampleCategoryId = tableModel.getSampleCategoryId(columnIndex);
        SpeciesBatchRowModel firstAncestorRow = selectedRow.getFirstAncestor(sampleCategoryId);
        SpeciesBatchRowModel parentBatch = firstAncestorRow.getParentBatch();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Open addChangeCategory batch ui for row [" + rowIndex + "] and category " + sampleCategoryId));
        }
        EditCatchesUI parent = (EditCatchesUI)SwingUtil.getParentContainer((Object)this.ui, EditCatchesUI.class);
        SplitSpeciesBatchUI splitBatchEditor = parent.getSpeciesTabAddSampleCategoryBatch();
        parent.getHandler().addSampleCategorySpeciesBatch(parentBatch, splitBatchEditor, sampleCategoryId);
    }

    public void changeBatchCategory() {
        Number selectedItem;
        SpeciesBatchTableModel tableModel = this.getTableModel();
        int rowIndex = this.getTable().getSelectedRow();
        int columnIndex = this.getTable().getSelectedColumn();
        SpeciesBatchRowModel selectedRow = (SpeciesBatchRowModel)tableModel.getEntry(rowIndex);
        Integer sampleCategoryId = tableModel.getSampleCategoryId(columnIndex);
        SampleCategoryModelEntry sampleCategoryEntry = this.sampleCategoryModel.getCategoryById(sampleCategoryId);
        Caracteristic caracteristic = sampleCategoryEntry.getCaracteristic();
        SpeciesBatchRowModel firstAncestorRow = selectedRow.getFirstAncestor(sampleCategoryId);
        Set<Serializable> usedValues = this.getSampleUsedValues(firstAncestorRow, sampleCategoryId);
        String categoryDecorated = this.decorate(caracteristic, "parameterOnly");
        String dialogTitle = I18n._((String)"tutti.editSpeciesBatch.title.changeSampleCategoryValue", (Object[])new Object[]{categoryDecorated});
        if (caracteristic.isNumericType()) {
            NumberEditor editor = new NumberEditor();
            editor.setNumberPattern("\\d{0,6}(\\.\\d{0,3})?");
            editor.setUseSign(Boolean.valueOf(false));
            editor.setUseFloat(Boolean.valueOf(true));
            editor.setShowPopupButton(Boolean.valueOf(false));
            editor.setShowReset(Boolean.valueOf(false));
            int response = JOptionPane.showConfirmDialog((Component)this.getUI(), editor, dialogTitle, 2);
            selectedItem = response == 0 ? (Number)editor.getModel() : (Number)null;
            if (usedValues.contains(selectedItem)) {
                JOptionPane.showMessageDialog(this.getTopestUI(), I18n._((String)"tutti.editSpeciesBatch.error.sampleCategoryValue.notAvailable", (Object[])new Object[]{selectedItem, categoryDecorated}));
                selectedItem = null;
            }
        } else {
            ArrayList availableValues = Lists.newArrayList((Iterable)caracteristic.getQualitativeValue());
            boolean firstCategory = this.sampleCategoryModel.getFirstCategoryId().equals(sampleCategoryId);
            if (firstCategory) {
                TuttiEntities.removeQualitativeValue((Collection)availableValues, (int)this.qualitative_unsorted_id);
            }
            availableValues.removeAll(usedValues);
            JComboBox editor = new JComboBox();
            editor.setRenderer(new DecoratorListCellRenderer(this.getDecorator(CaracteristicQualitativeValue.class, null)));
            SwingUtil.fillComboBox(editor, (Collection)availableValues, availableValues.get(0));
            int response = JOptionPane.showConfirmDialog(this.getTopestUI(), editor, dialogTitle, 2);
            selectedItem = response == 0 ? (CaracteristicQualitativeValue)editor.getSelectedItem() : null;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("New selected category: " + selectedItem));
        }
        if (selectedItem != null) {
            tableModel.updateSampleCategorieValue(firstAncestorRow, columnIndex, selectedItem);
            this.saveRow(firstAncestorRow);
        }
    }

    public void splitBatch(SampleCategoryModelEntry sampleCategoryDef, List<SplitSpeciesBatchRowModel> rows, Float totalRowWeight) {
        JXTable table = this.getTable();
        int insertRow = table.getSelectedRow();
        SpeciesBatchTableModel tableModel = this.getTableModel();
        SpeciesBatchRowModel parentBatch = (SpeciesBatchRowModel)tableModel.getEntry(insertRow);
        Float parentWeight = parentBatch.getFinestCategory().getNotNullWeight();
        boolean subSample = parentWeight != null && totalRowWeight != null && parentWeight.floatValue() > totalRowWeight.floatValue();
        ArrayList newBatches = Lists.newArrayList();
        for (SplitSpeciesBatchRowModel row : rows) {
            if (!row.isValid()) continue;
            SpeciesBatchRowModel newBatch = tableModel.createNewRow();
            this.loadBatchRow(parentBatch, newBatch, sampleCategoryDef.getCategoryId(), row.getCategoryValue(), row.getWeight(), null);
            newBatch.getFinestCategory().setSubSample(subSample);
            this.recomputeRowValidState(newBatch);
            newBatches.add(newBatch);
            tableModel.addNewRow(++insertRow, newBatch);
            AbstractSelectTableAction.doSelectCell((JTable)this.getTable(), insertRow, 0);
        }
        parentBatch.setChildBatch(newBatches);
        this.saveRows(newBatches);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setLeafNumber(model.getLeafNumber() + newBatches.size() - 1);
    }

    public void addSampleCategoryBatch(SpeciesBatchRowModel parentBatch, SampleCategoryModelEntry sampleCategoryDef, List<SplitSpeciesBatchRowModel> rows, Float totalRowWeight) {
        SpeciesBatchTableModel tableModel = this.getTableModel();
        int insertRow = tableModel.getNextChildRowIndex(parentBatch);
        ArrayList newBatches = Lists.newArrayList();
        for (SplitSpeciesBatchRowModel row : rows) {
            if (!row.isEditable() || !row.isValid()) continue;
            SpeciesBatchRowModel newBatch = tableModel.createNewRow();
            this.loadBatchRow(parentBatch, newBatch, sampleCategoryDef.getCategoryId(), row.getCategoryValue(), row.getWeight(), null);
            this.recomputeRowValidState(newBatch);
            newBatches.add(newBatch);
            tableModel.addNewRow(insertRow++, newBatch);
        }
        List<SpeciesBatchRowModel> childBatch = parentBatch.getChildBatch();
        childBatch.addAll(newBatches);
        parentBatch.setChildBatch(childBatch);
        int categoryIndex = this.sampleCategoryModel.indexOf(sampleCategoryDef);
        Float parentWeight = parentBatch.getSampleCategoryByIndex(categoryIndex - 1).getNotNullWeight();
        boolean subSample = parentWeight != null && totalRowWeight != null && parentWeight.floatValue() > totalRowWeight.floatValue();
        HashSet shell = Sets.newHashSet();
        parentBatch.collectShell(shell);
        for (SpeciesBatchRowModel rowModel : shell) {
            rowModel.getSampleCategoryByIndex(categoryIndex).setSubSample(subSample);
        }
        this.saveRows(newBatches);
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.setLeafNumber(model.getLeafNumber() + newBatches.size() - 1);
        tableModel.updateShell(shell, this.getTable().getSelectedColumn());
    }

    public void updateTotalFromFrequencies(SpeciesBatchRowModel row) {
        List<SpeciesFrequencyRowModel> frequency = row.getFrequency();
        Integer totalNumber = 0;
        boolean onlyOneFrequency = false;
        if (CollectionUtils.isNotEmpty(frequency)) {
            for (SpeciesFrequencyRowModel frequencyModel : frequency) {
                if (frequencyModel.getNumber() == null) continue;
                totalNumber = totalNumber + frequencyModel.getNumber();
            }
            onlyOneFrequency = frequency.size() == 1;
        }
        row.setComputedNumber(totalNumber);
        row.getFinestCategory().setOnlyOneFrequency(onlyOneFrequency);
    }

    public void saveRows(Iterable<SpeciesBatchRowModel> rows) {
        for (SpeciesBatchRowModel row : rows) {
            this.recomputeRowValidState(row);
            this.saveRow(row);
        }
    }

    public String getFilterSpeciesBatchRootButtonText(int rootNumber) {
        return I18n._((String)"tutti.editSpeciesBatch.filterBatch.mode.root", (Object[])new Object[]{rootNumber});
    }

    public void collectChildren(SpeciesBatchRowModel row, Set<SpeciesBatchRowModel> collectedRows) {
        if (!row.isBatchLeaf()) {
            for (SpeciesBatchRowModel batchChild : row.getChildBatch()) {
                collectedRows.add(batchChild);
                this.collectChildren(batchChild, collectedRows);
            }
        }
    }

    public SpeciesBatchRowModel loadBatch(SpeciesBatch aBatch, SpeciesBatchRowModel parentRow, List<SpeciesBatchRowModel> rows) {
        List speciesList;
        int i;
        String id = aBatch.getId();
        List frequencies = this.persistenceService.getAllSpeciesBatchFrequency(id);
        SpeciesBatchRowModel newRow = new SpeciesBatchRowModel(this.weightUnit, this.sampleCategoryModel, aBatch, frequencies);
        List attachments = this.persistenceService.getAllAttachments(newRow.getObjectType(), newRow.getObjectId());
        newRow.addAllAttachment(attachments);
        if (parentRow == null && this.context.isProtocolFilled() && (i = (speciesList = this.getDataContext().getReferentSpeciesWithSurveyCode()).indexOf(newRow.getSpecies())) > -1) {
            newRow.setSpecies((Species)speciesList.get(i));
        }
        Integer sampleCategoryId = aBatch.getSampleCategoryId();
        Preconditions.checkNotNull((Object)sampleCategoryId, (Object)("Can't have a batch with no sample category, but was: " + aBatch));
        this.loadBatchRow(parentRow, newRow, sampleCategoryId, aBatch.getSampleCategoryValue(), this.weightUnit.fromEntity(aBatch.getSampleCategoryWeight()), this.weightUnit.fromEntity(aBatch.getSampleCategoryComputedWeight()));
        rows.add(newRow);
        if (!aBatch.isChildBatchsEmpty()) {
            ArrayList batchChilds = Lists.newArrayListWithCapacity((int)aBatch.sizeChildBatchs());
            Float childrenWeights = Float.valueOf(0.0f);
            for (SpeciesBatch childBatch : aBatch.getChildBatchs()) {
                SpeciesBatchRowModel childRow = this.loadBatch(childBatch, newRow, rows);
                if (childrenWeights != null) {
                    Float weight = childRow.getFinestCategory().getNotNullWeight();
                    childrenWeights = weight == null ? null : Float.valueOf(childrenWeights.floatValue() + weight.floatValue());
                }
                batchChilds.add(childRow);
            }
            Float rowWeight = newRow.getFinestCategory().getNotNullWeight();
            boolean subSample = rowWeight != null && childrenWeights != null && childrenWeights.floatValue() < rowWeight.floatValue();
            for (SpeciesBatchRowModel childRow : batchChilds) {
                childRow.getFinestCategory().setSubSample(subSample);
            }
            newRow.setChildBatch(batchChilds);
        }
        return newRow;
    }

    public void removeFromSpeciesUsed(SpeciesBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getSpecies());
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        CaracteristicQualitativeValue categoryValue = (CaracteristicQualitativeValue)firstSampleCategory.getCategoryValue();
        Preconditions.checkNotNull(firstSampleCategory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Remove from speciesUsed: " + this.decorate(categoryValue) + " - " + this.decorate(row.getSpecies())));
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.getSpeciesUsed().remove((Object)categoryValue, (Object)row.getSpecies());
        if (row.isBatchRoot()) {
            model.setRootNumber(model.getRootNumber() - 1);
        }
    }

    public Species openAddSpeciesDialog(String title, List<Species> species) {
        SelectSpeciesUI dialogContent = new SelectSpeciesUI(this.ui);
        SelectSpeciesUIModel model = dialogContent.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);
        this.openDialog(dialogContent, title, new Dimension(400, 130));
        return model.getSelectedSpecies();
    }

    protected void saveRow(SpeciesBatchRowModel row) {
        FishingOperation fishingOperation = ((SpeciesBatchUIModel)this.getModel()).getFishingOperation();
        Preconditions.checkNotNull((Object)fishingOperation);
        Preconditions.checkNotNull((Object)row.getSpecies());
        SampleCategory sampleCategory = row.getFinestCategory();
        Preconditions.checkNotNull((Object)sampleCategory);
        Preconditions.checkNotNull((Object)sampleCategory.getCategoryId());
        Preconditions.checkNotNull((Object)sampleCategory.getCategoryValue());
        SpeciesBatch catchBean = (SpeciesBatch)row.toBean();
        Float weight = catchBean.getWeight();
        catchBean.setWeight(this.weightUnit.toEntity(weight));
        catchBean.setFishingOperation(fishingOperation);
        SpeciesBatchRowModel parent = row.getParentBatch();
        if (parent != null) {
            catchBean.setParentBatch((SpeciesBatch)parent.toBean());
        }
        catchBean.setSampleCategoryId(sampleCategory.getCategoryId());
        catchBean.setSampleCategoryValue(sampleCategory.getCategoryValue());
        Float categoryWeight = sampleCategory.getCategoryWeight();
        catchBean.setSampleCategoryWeight(this.weightUnit.toEntity(categoryWeight));
        if (TuttiEntities.isNew((TuttiEntity)catchBean)) {
            String parentBatchId = null;
            if (parent != null) {
                parentBatchId = parent.getId();
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Persist new species batch with parentId: " + parentBatchId));
            }
            catchBean = this.persistenceService.createSpeciesBatch(catchBean, parentBatchId);
            row.setId(catchBean.getId());
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Persist existing species batch: " + catchBean.getId() + " (parent : " + catchBean.getParentBatch() + ")"));
            }
            this.persistenceService.saveSpeciesBatch(catchBean);
        }
        List<SpeciesFrequencyRowModel> frequencyRows = row.getFrequency();
        List frequency = SpeciesFrequencyRowModel.toEntity(frequencyRows, catchBean);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will save " + frequency.size() + " frequencies."));
        }
        frequency = this.persistenceService.saveSpeciesBatchFrequency(catchBean.getId(), frequency);
        frequencyRows = SpeciesFrequencyRowModel.fromEntity(this.weightUnit, frequency);
        row.setFrequency(frequencyRows);
        ((SpeciesBatchUIModel)this.getModel()).fireBatchUpdated(row);
    }

    protected void loadBatchRow(SpeciesBatchRowModel parentRow, SpeciesBatchRowModel newRow, Integer sampleCategoryId, Serializable categoryValue, Float categoryWeight, Float categoryComputedWeight) {
        SampleCategory<?> sampleCategory = newRow.getSampleCategoryById(sampleCategoryId);
        sampleCategory.setCategoryValue(categoryValue);
        sampleCategory.setCategoryWeight(categoryWeight);
        sampleCategory.setComputedWeight(categoryComputedWeight);
        newRow.setSampleCategory(sampleCategory);
        if (parentRow != null) {
            newRow.setSpecies(parentRow.getSpecies());
            newRow.setSpeciesToConfirm(parentRow.isSpeciesToConfirm());
            newRow.setParentBatch(parentRow);
            newRow.setSpecies(parentRow.getSpecies());
            for (Integer id : this.sampleCategoryModel.getSamplingOrder()) {
                if (id.equals(sampleCategoryId)) continue;
                newRow.setSampleCategory(parentRow.getSampleCategoryById(id));
            }
        }
    }

    protected <C extends Serializable> void addSampleCategoryColumnToModel(TableColumnModel columnModel, ColumnIdentifier<SpeciesBatchRowModel> columnIdentifier, Decorator<C> decorator, TableCellRenderer defaultRenderer, WeightUnit weightUnit) {
        this.addColumnToModel(columnModel, SampleCategoryComponent.newEditor(decorator, weightUnit), SampleCategoryComponent.newRender(defaultRenderer, decorator, this.getConfig().getColorComputedWeights()), columnIdentifier, weightUnit);
    }

    protected void addToSpeciesUsed(SpeciesBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getSpecies());
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        Preconditions.checkNotNull(firstSampleCategory);
        CaracteristicQualitativeValue categoryValue = (CaracteristicQualitativeValue)firstSampleCategory.getCategoryValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add to speciesUsed: " + this.decorate(categoryValue) + " - " + this.decorate(row.getSpecies())));
        }
        SpeciesBatchUIModel model = (SpeciesBatchUIModel)this.getModel();
        model.getSpeciesUsed().put((Object)categoryValue, (Object)row.getSpecies());
        model.setRootNumber(model.getRootNumber() + 1);
    }

    protected SpeciesBatch convertRowToEntity(SpeciesBatchRowModel row, boolean convertParent) {
        Preconditions.checkNotNull((Object)row.getFinestCategory());
        Preconditions.checkNotNull((Object)row.getFinestCategory().getCategoryId());
        Preconditions.checkNotNull((Object)row.getFinestCategory().getCategoryValue());
        SpeciesBatch catchBean = row.toEntity();
        if (convertParent && row.getParentBatch() != null) {
            SpeciesBatch parent = this.convertRowToEntity(row.getParentBatch(), true);
            catchBean.setParentBatch(parent);
        }
        return catchBean;
    }

    protected Set<Serializable> getSampleUsedValues(SpeciesBatchRowModel row, int sampleCategoryId) {
        List<Object> childs;
        HashSet usedValues = Sets.newHashSet();
        if (row.isBatchRoot()) {
            Species species = row.getSpecies();
            childs = Lists.newArrayList();
            for (SpeciesBatchRowModel rowToScan : ((SpeciesBatchUIModel)this.getModel()).getRows()) {
                if (!rowToScan.isBatchRoot() || !species.equals(rowToScan.getSpecies())) continue;
                childs.add(rowToScan);
            }
        } else {
            SpeciesBatchRowModel parentBatch = row.getParentBatch();
            childs = parentBatch.getChildBatch();
        }
        for (SpeciesBatchRowModel speciesBatchRowModel : childs) {
            SampleCategory<?> category = speciesBatchRowModel.getSampleCategoryById(sampleCategoryId);
            usedValues.add(category.getCategoryValue());
        }
        return usedValues;
    }
}

