/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.typeconversion.core;

import java.text.ParseException;
import liquibase.database.Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.structure.type.BooleanType;
import liquibase.database.structure.type.DateTimeType;
import liquibase.database.structure.type.NumberType;
import liquibase.database.structure.type.TinyIntType;
import liquibase.database.typeconversion.core.AbstractTypeConverter;
import liquibase.exception.DatabaseException;

public class DerbyTypeConverter
extends AbstractTypeConverter {
    private BooleanType booleanType;

    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        boolean supports = database instanceof DerbyDatabase;
        if (supports) {
            try {
                if (database.getDatabaseMajorVersion() >= 10 && database.getDatabaseMinorVersion() >= 7) {
                    this.booleanType = new BooleanType("BOOLEAN");
                }
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
        return supports;
    }

    public Object convertDatabaseValueToObject(Object defaultValue, int dataType, int columnSize, int decimalDigits, Database database) throws ParseException {
        if (defaultValue != null && defaultValue instanceof String) {
            if (dataType == 93) {
                defaultValue = ((String)defaultValue).replaceFirst("^TIMESTAMP\\('", "").replaceFirst("'\\)", "");
            } else if (dataType == 91) {
                defaultValue = ((String)defaultValue).replaceFirst("^DATE\\('", "").replaceFirst("'\\)", "");
            } else if (dataType == 92) {
                defaultValue = ((String)defaultValue).replaceFirst("^TIME\\('", "").replaceFirst("'\\)", "");
            }
        }
        return super.convertDatabaseValueToObject(defaultValue, dataType, columnSize, decimalDigits, database);
    }

    public DateTimeType getDateTimeType() {
        return new DateTimeType("TIMESTAMP");
    }

    public NumberType getNumberType() {
        return new NumberType("NUMERIC");
    }

    public TinyIntType getTinyIntType() {
        return new TinyIntType("SMALLINT");
    }

    public BooleanType getBooleanType() {
        if (this.booleanType != null) {
            return this.booleanType;
        }
        return new BooleanType.NumericBooleanType("SMALLINT");
    }
}

