package fr.ifremer.tutti.ui.swing.content.cruise;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class EditCruiseUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<EditCruiseUIModel, EditCruiseUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ATTACHMENTS_BUTTON_ENABLED = "attachmentsButton.enabled";
    public static final String BINDING_BEGIN_DATE_FIELD_DATE = "beginDateField.date";
    public static final String BINDING_COMMENT_FIELD_TEXT = "commentField.text";
    public static final String BINDING_DEPARTURE_LOCATION_COMBO_BOX_SELECTED_ITEM = "departureLocationComboBox.selectedItem";
    public static final String BINDING_END_DATE_FIELD_DATE = "endDateField.date";
    public static final String BINDING_FILTER_VESSEL_ALL_BUTTON_SELECTED = "filterVesselAllButton.selected";
    public static final String BINDING_FILTER_VESSEL_FISHING_BUTTON_SELECTED = "filterVesselFishingButton.selected";
    public static final String BINDING_FILTER_VESSEL_SCIENTIFIC_BUTTON_SELECTED = "filterVesselScientificButton.selected";
    public static final String BINDING_GENERATE_NAME_BUTTON_ENABLED = "generateNameButton.enabled";
    public static final String BINDING_MULTIRIG_NUMBER_FIELD_MODEL = "multirigNumberField.model";
    public static final String BINDING_NAME_FIELD_TEXT = "nameField.text";
    public static final String BINDING_PROGRAM_COMBO_BOX_SELECTED_ITEM = "programComboBox.selectedItem";
    public static final String BINDING_RETURN_LOCATION_COMBO_BOX_SELECTED_ITEM = "returnLocationComboBox.selectedItem";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SURVEY_PART_FIELD_TEXT = "surveyPartField.text";
    public static final String BINDING_VESSEL_COMBO_BOX_SELECTED_ITEM = "vesselComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected ButtonAttachment attachmentsButton;
    @ValidatorField( validatorId = "validator",  propertyName = "beginDate",  editorName = "beginDateField")
    protected JXDatePicker beginDateField;
    protected JLabel beginDateLabel;
    protected TuttiHelpBroker broker;
    protected JButton closeButton;
    protected JTextArea commentField;
    @ValidatorField( validatorId = "validator",  propertyName = "comment",  editorName = "commentPane")
    protected JScrollPane commentPane;
    protected JScrollPane cruiseScrollPane;
    @ValidatorField( validatorId = "validator",  propertyName = "departureLocation",  editorName = "departureLocationComboBox")
    protected BeanFilterableComboBox<TuttiLocation> departureLocationComboBox;
    protected JLabel departureLocationLabel;
    protected EditCruiseUI editCruiseTopPanel = this;
    protected JMenuItem editGearCaracteristicsItem;
    @ValidatorField( validatorId = "validator",  propertyName = "endDate",  editorName = "endDateField")
    protected JXDatePicker endDateField;
    protected JLabel endDateLabel;
    protected JRadioButton filterVesselAllButton;
    protected JRadioButton filterVesselFishingButton;
    protected JLabel filterVesselLabel;
    protected JRadioButton filterVesselScientificButton;
    protected JAXXButtonGroup filterVesselType;
    protected GearCaracteristicsEditorUI gearCaracteristicsEditor;
    protected JXTitledPanel gearCaracteristicsEditorTitledPanel;
    @ValidatorField( validatorId = "validator",  propertyName = "gear",  editorName = "gearList")
    protected BeanDoubleList<Gear> gearList;
    protected JPopupMenu gearMenuPopup;
    protected JButton generateNameButton;
    protected EditCruiseUIHandler handler;
    @ValidatorField( validatorId = "validator",  propertyName = "headOfMission",  editorName = "headOfMissionList")
    protected BeanDoubleList<Person> headOfMissionList;
    @ValidatorField( validatorId = "validator",  propertyName = "headOfSortRoom",  editorName = "headOfSortRoomList")
    protected BeanDoubleList<Person> headOfSortRoomList;
    protected CardLayout2Ext mainPanelLayout;
    protected EditCruiseUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "multirigNumber",  editorName = "multirigNumberField")
    protected NumberEditor multirigNumberField;
    protected JLabel multirigNumberLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "name",  editorName = "nameField")
    protected JTextField nameField;
    protected JLabel nameLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "programComboBox")
    protected BeanFilterableComboBox<Program> programComboBox;
    protected JLabel programLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "returnLocation",  editorName = "returnLocationComboBox")
    protected BeanFilterableComboBox<TuttiLocation> returnLocationComboBox;
    protected JLabel returnLocationLabel;
    protected JButton saveButton;
    @ValidatorField( validatorId = "validator",  propertyName = "surveyPart",  editorName = "surveyPartField")
    protected JTextField surveyPartField;
    protected JLabel surveyPartLabel;
    protected JToolBar topToolBar;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCruiseUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    @ValidatorField( validatorId = "validator",  propertyName = "vessel",  editorName = "vesselComboBox")
    protected BeanFilterableComboBox<Vessel> vesselComboBox;
    protected JPanel vesselFilterPane;
    protected JLabel vesselLabel;
    protected JMenuItem viewGearCaracteristicsItem;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JSeparator $JSeparator0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCruiseUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  EditCruiseUIHandler handler = new EditCruiseUIHandler(parentUI, this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public EditCruiseUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCruiseUI() {
        $initialize();
    }

    public EditCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__beginDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "beginDate");
    }

    public void doActionPerformed__on__endDateField(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDate(event, "endDate");
    }

    public void doActionPerformed__on__filterVesselAllButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.ALL);
    }

    public void doActionPerformed__on__filterVesselFishingButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.FISHING);
    }

    public void doActionPerformed__on__filterVesselScientificButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setVesselType(VesselTypeEnum.SCIENTIFIC);
    }

    public void doActionPerformed__on__generateNameButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.generateCampaignName();
    }

    public void doFocusGained__on__commentPane(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        commentField.requestFocus();
    }

    public void doKeyReleased__on__commentField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "comment");
    }

    public void doKeyReleased__on__nameField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "name");
    }

    public void doKeyReleased__on__surveyPartField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setText(event, "surveyPart");
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public ButtonAttachment getAttachmentsButton() {
        return attachmentsButton;
    }

    public JXDatePicker getBeginDateField() {
        return beginDateField;
    }

    public JLabel getBeginDateLabel() {
        return beginDateLabel;
    }

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloseButton() {
        return closeButton;
    }

    public JTextArea getCommentField() {
        return commentField;
    }

    public JScrollPane getCommentPane() {
        return commentPane;
    }

    public JScrollPane getCruiseScrollPane() {
        return cruiseScrollPane;
    }

    public BeanFilterableComboBox<TuttiLocation> getDepartureLocationComboBox() {
        return departureLocationComboBox;
    }

    public JLabel getDepartureLocationLabel() {
        return departureLocationLabel;
    }

    public JMenuItem getEditGearCaracteristicsItem() {
        return editGearCaracteristicsItem;
    }

    public JXDatePicker getEndDateField() {
        return endDateField;
    }

    public JLabel getEndDateLabel() {
        return endDateLabel;
    }

    public JRadioButton getFilterVesselAllButton() {
        return filterVesselAllButton;
    }

    public JRadioButton getFilterVesselFishingButton() {
        return filterVesselFishingButton;
    }

    public JLabel getFilterVesselLabel() {
        return filterVesselLabel;
    }

    public JRadioButton getFilterVesselScientificButton() {
        return filterVesselScientificButton;
    }

    public JAXXButtonGroup getFilterVesselType() {
        return filterVesselType;
    }

    public GearCaracteristicsEditorUI getGearCaracteristicsEditor() {
        return gearCaracteristicsEditor;
    }

    public JXTitledPanel getGearCaracteristicsEditorTitledPanel() {
        return gearCaracteristicsEditorTitledPanel;
    }

    public BeanDoubleList<Gear> getGearList() {
        return gearList;
    }

    public JPopupMenu getGearMenuPopup() {
        return gearMenuPopup;
    }

    public JButton getGenerateNameButton() {
        return generateNameButton;
    }

    public EditCruiseUIHandler getHandler() {
        return handler;
    }

    public BeanDoubleList<Person> getHeadOfMissionList() {
        return headOfMissionList;
    }

    public BeanDoubleList<Person> getHeadOfSortRoomList() {
        return headOfSortRoomList;
    }

    public CardLayout2Ext getMainPanelLayout() {
        return mainPanelLayout;
    }

    public EditCruiseUIModel getModel() {
        return model;
    }

    public NumberEditor getMultirigNumberField() {
        return multirigNumberField;
    }

    public JLabel getMultirigNumberLabel() {
        return multirigNumberLabel;
    }

    public JTextField getNameField() {
        return nameField;
    }

    public JLabel getNameLabel() {
        return nameLabel;
    }

    public BeanFilterableComboBox<Program> getProgramComboBox() {
        return programComboBox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public BeanFilterableComboBox<TuttiLocation> getReturnLocationComboBox() {
        return returnLocationComboBox;
    }

    public JLabel getReturnLocationLabel() {
        return returnLocationLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JTextField getSurveyPartField() {
        return surveyPartField;
    }

    public JLabel getSurveyPartLabel() {
        return surveyPartLabel;
    }

    public JToolBar getTopToolBar() {
        return topToolBar;
    }

    public SwingValidator<EditCruiseUIModel> getValidator() {
        return validator;
    }

    public BeanFilterableComboBox<Vessel> getVesselComboBox() {
        return vesselComboBox;
    }

    public JPanel getVesselFilterPane() {
        return vesselFilterPane;
    }

    public JLabel getVesselLabel() {
        return vesselLabel;
    }

    public JMenuItem getViewGearCaracteristicsItem() {
        return viewGearCaracteristicsItem;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToCommentPane() {
        if (!allComponentsCreated) {
            return;
        }
        commentPane.getViewport().add(commentField);
    }

    protected void addChildrenToCruiseScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        cruiseScrollPane.getViewport().add($Table0);
    }

    protected void addChildrenToEditCruiseTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(topToolBar);
        add($JPanel0, EditCruiseUIHandler.CRUISE_CARD);
        add(gearCaracteristicsEditorTitledPanel, EditCruiseUIHandler.GEAR_CARACTERISTICS_CARD);
    }

    protected void addChildrenToFilterVesselAllButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselAllButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselAllButton); }
    }

    protected void addChildrenToFilterVesselFishingButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselFishingButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselFishingButton); }
    }

    protected void addChildrenToFilterVesselScientificButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = filterVesselType; filterVesselScientificButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(filterVesselScientificButton); }
    }

    protected void addChildrenToGearCaracteristicsEditorTitledPanel() {
        if (!allComponentsCreated) {
            return;
        }
        gearCaracteristicsEditorTitledPanel.add(gearCaracteristicsEditor);
    }

    protected void addChildrenToGearMenuPopup() {
        if (!allComponentsCreated) {
            return;
        }
        gearMenuPopup.add(editGearCaracteristicsItem);
        gearMenuPopup.add(viewGearCaracteristicsItem);
    }

    protected void addChildrenToTopToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        topToolBar.add(attachmentsButton);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void addChildrenToVesselFilterPane() {
        if (!allComponentsCreated) {
            return;
        }
        vesselFilterPane.add(filterVesselLabel);
        vesselFilterPane.add(filterVesselAllButton);
        vesselFilterPane.add(filterVesselScientificButton);
        vesselFilterPane.add(filterVesselFishingButton);
    }

    protected void createAttachmentsButton() {
        $objectMap.put("attachmentsButton", attachmentsButton = new ButtonAttachment(getHandler().getContext(), getModel()));
        
        attachmentsButton.setName("attachmentsButton");
    }

    protected void createBeginDateField() {
        $objectMap.put("beginDateField", beginDateField = new JXDatePicker());
        
        beginDateField.setName("beginDateField");
        beginDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__beginDateField"));
        beginDateField.putClientProperty("validatorLabel", _("tutti.editCruise.field.beginDate"));
        beginDateField.putClientProperty("selectOnFocus", true);
    }

    protected void createBeginDateLabel() {
        $objectMap.put("beginDateLabel", beginDateLabel = new JLabel());
        
        beginDateLabel.setName("beginDateLabel");
        beginDateLabel.setText(_("tutti.editCruise.field.beginDate"));
        beginDateLabel.setToolTipText(_("tutti.editCruise.field.beginDate.tip"));
        beginDateLabel.putClientProperty("help", "tutti.editCruise.field.beginDate.help");
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.editCruise.help"));
    }

    protected void createCloseButton() {
        $objectMap.put("closeButton", closeButton = new JButton());
        
        closeButton.setName("closeButton");
        closeButton.setText(_("tutti.editCruise.action.closeEditCruise"));
        closeButton.setToolTipText(_("tutti.editCruise.action.closeEditCruise.tip"));
        closeButton.putClientProperty("help", "tutti.editCruise.action.close.help");
        closeButton.putClientProperty("tuttiAction", fr.ifremer.tutti.ui.swing.content.SelectCruiseAction.class);
    }

    protected void createCommentField() {
        $objectMap.put("commentField", commentField = new JTextArea());
        
        commentField.setName("commentField");
        commentField.setColumns(15);
        commentField.setLineWrap(true);
        commentField.setWrapStyleWord(true);
        commentField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__commentField"));
        commentField.putClientProperty("validatorLabel", _("tutti.editCruise.field.comment"));
    }

    protected void createCommentPane() {
        $objectMap.put("commentPane", commentPane = new JScrollPane());
        
        commentPane.setName("commentPane");
        commentPane.setToolTipText(_("tutti.editCruise.field.comment.tip"));
        commentPane.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusGained", this, "doFocusGained__on__commentPane"));
        commentPane.putClientProperty("help", "tutti.editCruise.field.comment.help");
    }

    protected void createCruiseScrollPane() {
        $objectMap.put("cruiseScrollPane", cruiseScrollPane = new JScrollPane());
        
        cruiseScrollPane.setName("cruiseScrollPane");
        cruiseScrollPane.putClientProperty("onlyVerticalScrollable", true);
    }

    protected void createDepartureLocationComboBox() {
        $objectMap.put("departureLocationComboBox", departureLocationComboBox = new BeanFilterableComboBox<TuttiLocation>(this));
        
        departureLocationComboBox.setName("departureLocationComboBox");
        departureLocationComboBox.setI18nPrefix("tutti.property.");
        departureLocationComboBox.setProperty("departureLocation");
        departureLocationComboBox.setShowReset(true);
        departureLocationComboBox.putClientProperty("validatorLabel", _("tutti.editCruise.field.departureLocation"));
    }

    protected void createDepartureLocationLabel() {
        $objectMap.put("departureLocationLabel", departureLocationLabel = new JLabel());
        
        departureLocationLabel.setName("departureLocationLabel");
        departureLocationLabel.setText(_("tutti.editCruise.field.departureLocation"));
        departureLocationLabel.setToolTipText(_("tutti.editCruise.field.departureLocation.tip"));
        departureLocationLabel.putClientProperty("help", "tutti.editCruise.field.departureLocation.help");
    }

    protected void createEditGearCaracteristicsItem() {
        $objectMap.put("editGearCaracteristicsItem", editGearCaracteristicsItem = new JMenuItem());
        
        editGearCaracteristicsItem.setName("editGearCaracteristicsItem");
        editGearCaracteristicsItem.setText(_("tutti.editCruise.action.editGearCaracteristics"));
        editGearCaracteristicsItem.setToolTipText(_("tutti.editCruise.action.editGearCaracteristics.tip"));
        editGearCaracteristicsItem.putClientProperty("help", "tutti.editCruise.action.editGearCaracteristics.help");
        editGearCaracteristicsItem.putClientProperty("tuttiAction", EditGearCaracteristicsAction.class);
    }

    protected void createEndDateField() {
        $objectMap.put("endDateField", endDateField = new JXDatePicker());
        
        endDateField.setName("endDateField");
        endDateField.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__endDateField"));
        endDateField.putClientProperty("validatorLabel", _("tutti.editCruise.field.endDate"));
        endDateField.putClientProperty("selectOnFocus", true);
    }

    protected void createEndDateLabel() {
        $objectMap.put("endDateLabel", endDateLabel = new JLabel());
        
        endDateLabel.setName("endDateLabel");
        endDateLabel.setText(_("tutti.editCruise.field.endDate"));
        endDateLabel.setToolTipText(_("tutti.editCruise.field.endDate.tip"));
        endDateLabel.putClientProperty("help", "tutti.editCruise.field.endDate.help");
    }

    protected void createFilterVesselAllButton() {
        $objectMap.put("filterVesselAllButton", filterVesselAllButton = new JRadioButton());
        
        filterVesselAllButton.setName("filterVesselAllButton");
        filterVesselAllButton.setText(_("tutti.editCruise.filterVesselType.all"));
        { filterVesselAllButton.putClientProperty("$value", "all");  Object $buttonGroup = filterVesselAllButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselAllButton.setToolTipText(_("tutti.editCruise.filterVesselType.all.tip"));
        filterVesselAllButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselAllButton"));
    }

    protected void createFilterVesselFishingButton() {
        $objectMap.put("filterVesselFishingButton", filterVesselFishingButton = new JRadioButton());
        
        filterVesselFishingButton.setName("filterVesselFishingButton");
        filterVesselFishingButton.setText(_("tutti.editCruise.filterVesselType.fishing"));
        { filterVesselFishingButton.putClientProperty("$value", "fishing");  Object $buttonGroup = filterVesselFishingButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselFishingButton.setToolTipText(_("tutti.editCruise.filterVesselType.fishing.tip"));
        filterVesselFishingButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselFishingButton"));
    }

    protected void createFilterVesselLabel() {
        $objectMap.put("filterVesselLabel", filterVesselLabel = new JLabel());
        
        filterVesselLabel.setName("filterVesselLabel");
        filterVesselLabel.setText(_("tutti.editCruise.filterVesselType"));
        filterVesselLabel.setToolTipText(_("tutti.editCruise.filterVessel.tip"));
        filterVesselLabel.putClientProperty("help", "tutti.editCruise.filterVessel.help");
        filterVesselLabel.putClientProperty("strongStyle", true);
    }

    protected void createFilterVesselScientificButton() {
        $objectMap.put("filterVesselScientificButton", filterVesselScientificButton = new JRadioButton());
        
        filterVesselScientificButton.setName("filterVesselScientificButton");
        filterVesselScientificButton.setText(_("tutti.editCruise.filterVesselType.scientific"));
        { filterVesselScientificButton.putClientProperty("$value", "scientific");  Object $buttonGroup = filterVesselScientificButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        filterVesselScientificButton.setToolTipText(_("tutti.editCruise.filterVesselType.scientific.tip"));
        filterVesselScientificButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__filterVesselScientificButton"));
    }

    protected void createFilterVesselType() {
        $objectMap.put("filterVesselType", filterVesselType = new JAXXButtonGroup());
    }

    protected void createGearCaracteristicsEditor() {
        $objectMap.put("gearCaracteristicsEditor", gearCaracteristicsEditor = new GearCaracteristicsEditorUI(this));
        
        gearCaracteristicsEditor.setName("gearCaracteristicsEditor");
    }

    protected void createGearCaracteristicsEditorTitledPanel() {
        $objectMap.put("gearCaracteristicsEditorTitledPanel", gearCaracteristicsEditorTitledPanel = new JXTitledPanel());
        
        gearCaracteristicsEditorTitledPanel.setName("gearCaracteristicsEditorTitledPanel");
        gearCaracteristicsEditorTitledPanel.setTitle(_("tutti.editCruise.gearCaracteristics.title"));
    }

    protected void createGearList() {
        $objectMap.put("gearList", gearList = new BeanDoubleList<Gear>());
        
        gearList.setName("gearList");
        gearList.setI18nPrefix("tutti.property.");
        gearList.setProperty("gear");
        gearList.setShowReset(true);
        gearList.setToolTipText(_("tutti.editCruise.field.gear.tip"));
        gearList.putClientProperty("help", "tutti.editCruise.field.gear.help");
        gearList.putClientProperty("validatorLabel", _("tutti.editCruise.field.gear"));
    }

    protected void createGearMenuPopup() {
        $objectMap.put("gearMenuPopup", gearMenuPopup = new JPopupMenu());
        
        gearMenuPopup.setName("gearMenuPopup");
    }

    protected void createGenerateNameButton() {
        $objectMap.put("generateNameButton", generateNameButton = new JButton());
        
        generateNameButton.setName("generateNameButton");
        generateNameButton.setText(_("tutti.editCruise.action.generateCampaignName"));
        generateNameButton.setToolTipText(_("tutti.editCruise.action.generateName.tip"));
        generateNameButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__generateNameButton"));
        generateNameButton.putClientProperty("help", "tutti.editCruise.action.generateName.help");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditCruiseUIHandler.class));
    }

    protected void createHeadOfMissionList() {
        $objectMap.put("headOfMissionList", headOfMissionList = new BeanDoubleList<Person>());
        
        headOfMissionList.setName("headOfMissionList");
        headOfMissionList.setI18nPrefix("tutti.property.");
        headOfMissionList.setProperty("headOfMission");
        headOfMissionList.setShowReset(true);
        headOfMissionList.setToolTipText(_("tutti.editCruise.field.headOfMission.tip"));
        headOfMissionList.putClientProperty("help", "tutti.editCruise.field.headOfMission.help");
        headOfMissionList.putClientProperty("validatorLabel", _("tutti.editCruise.field.headOfMission"));
    }

    protected void createHeadOfSortRoomList() {
        $objectMap.put("headOfSortRoomList", headOfSortRoomList = new BeanDoubleList<Person>());
        
        headOfSortRoomList.setName("headOfSortRoomList");
        headOfSortRoomList.setI18nPrefix("tutti.property.");
        headOfSortRoomList.setProperty("headOfSortRoom");
        headOfSortRoomList.setShowReset(true);
        headOfSortRoomList.setToolTipText(_("tutti.editCruise.field.headOfSortRoom.tip"));
        headOfSortRoomList.putClientProperty("help", "tutti.editCruise.field.headOfSortRoom.help");
        headOfSortRoomList.putClientProperty("validatorLabel", _("tutti.editCruise.field.headOfSortRoom"));
    }

    protected void createMainPanelLayout() {
        $objectMap.put("mainPanelLayout", mainPanelLayout = new CardLayout2Ext(this, "editCruiseTopPanel"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCruiseUIModel.class));
    }

    protected void createMultirigNumberField() {
        $objectMap.put("multirigNumberField", multirigNumberField = new NumberEditor(this));
        
        multirigNumberField.setName("multirigNumberField");
        multirigNumberField.setProperty("multirigNumber");
        multirigNumberField.setUseFloat(false);
        multirigNumberField.setShowReset(true);
        multirigNumberField.putClientProperty("validatorLabel", _("tutti.editCruise.field.multirigNumber"));
        multirigNumberField.putClientProperty("selectOnFocus", true);
    }

    protected void createMultirigNumberLabel() {
        $objectMap.put("multirigNumberLabel", multirigNumberLabel = new JLabel());
        
        multirigNumberLabel.setName("multirigNumberLabel");
        multirigNumberLabel.setText(_("tutti.editCruise.field.multirigNumber"));
        multirigNumberLabel.setToolTipText(_("tutti.editCruise.field.multirigNumber.tip"));
        multirigNumberLabel.putClientProperty("help", "tutti.editCruise.field.multirigNumber.help");
    }

    protected void createNameField() {
        $objectMap.put("nameField", nameField = new JTextField());
        
        nameField.setName("nameField");
        nameField.setColumns(15);
        nameField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__nameField"));
        nameField.putClientProperty("validatorLabel", _("tutti.editCruise.field.name"));
        nameField.putClientProperty("selectOnFocus", true);
    }

    protected void createNameLabel() {
        $objectMap.put("nameLabel", nameLabel = new JLabel());
        
        nameLabel.setName("nameLabel");
        nameLabel.setText(_("tutti.editCruise.field.name"));
        nameLabel.setToolTipText(_("tutti.editCruise.field.name.tip"));
        nameLabel.putClientProperty("help", "tutti.editCruise.field.name.help");
    }

    protected void createProgramComboBox() {
        $objectMap.put("programComboBox", programComboBox = new BeanFilterableComboBox<Program>(this));
        
        programComboBox.setName("programComboBox");
        programComboBox.setI18nPrefix("tutti.property.");
        programComboBox.setProperty("program");
        programComboBox.setShowReset(true);
        programComboBox.putClientProperty("validatorLabel", _("tutti.editCruise.field.program"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(_("tutti.editCruise.field.program"));
        programLabel.setToolTipText(_("tutti.editCruise.field.program.tip"));
        programLabel.putClientProperty("help", "tutti.editCruise.field.program.help");
    }

    protected void createReturnLocationComboBox() {
        $objectMap.put("returnLocationComboBox", returnLocationComboBox = new BeanFilterableComboBox<TuttiLocation>(this));
        
        returnLocationComboBox.setName("returnLocationComboBox");
        returnLocationComboBox.setI18nPrefix("tutti.property.");
        returnLocationComboBox.setProperty("returnLocation");
        returnLocationComboBox.setShowReset(true);
        returnLocationComboBox.putClientProperty("validatorLabel", _("tutti.editCruise.field.returnLocation"));
    }

    protected void createReturnLocationLabel() {
        $objectMap.put("returnLocationLabel", returnLocationLabel = new JLabel());
        
        returnLocationLabel.setName("returnLocationLabel");
        returnLocationLabel.setText(_("tutti.editCruise.field.returnLocation"));
        returnLocationLabel.setToolTipText(_("tutti.editCruise.field.returnLocation.tip"));
        returnLocationLabel.putClientProperty("help", "tutti.editCruise.field.returnLocation.help");
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.editCruise.action.saveCruise"));
        saveButton.setToolTipText(_("tutti.editCruise.action.saveCruise.tip"));
        saveButton.putClientProperty("help", "tutti.editCruise.action.save.help");
        saveButton.putClientProperty("tuttiAction", SaveCruiseAction.class);
    }

    protected void createSurveyPartField() {
        $objectMap.put("surveyPartField", surveyPartField = new JTextField());
        
        surveyPartField.setName("surveyPartField");
        surveyPartField.setColumns(15);
        surveyPartField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__surveyPartField"));
        surveyPartField.putClientProperty("validatorLabel", _("tutti.editCruise.field.surveyPart"));
        surveyPartField.putClientProperty("selectOnFocus", true);
    }

    protected void createSurveyPartLabel() {
        $objectMap.put("surveyPartLabel", surveyPartLabel = new JLabel());
        
        surveyPartLabel.setName("surveyPartLabel");
        surveyPartLabel.setText(_("tutti.editCruise.field.surveyPart"));
        surveyPartLabel.setToolTipText(_("tutti.editCruise.field.surveyPart.tip"));
        surveyPartLabel.putClientProperty("help", "tutti.editCruise.field.surveyPart.help");
    }

    protected void createTopToolBar() {
        $objectMap.put("topToolBar", topToolBar = new JToolBar());
        
        topToolBar.setName("topToolBar");
        topToolBar.setFloatable(false);
        topToolBar.setOpaque(false);
        topToolBar.setBorderPainted(false);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCruiseUIModel.class, null));
    }

    protected void createVesselComboBox() {
        $objectMap.put("vesselComboBox", vesselComboBox = new BeanFilterableComboBox<Vessel>(this));
        
        vesselComboBox.setName("vesselComboBox");
        vesselComboBox.setI18nPrefix("tutti.property.");
        vesselComboBox.setProperty("vessel");
        vesselComboBox.setShowReset(true);
        vesselComboBox.setToolTipText(_("tutti.editCruise.field.vessel.tip"));
        vesselComboBox.putClientProperty("help", "tutti.editCruise.field.vessel.help");
        vesselComboBox.putClientProperty("validatorLabel", _("tutti.editCruise.field.vessel"));
    }

    protected void createVesselFilterPane() {
        $objectMap.put("vesselFilterPane", vesselFilterPane = new JPanel());
        
        vesselFilterPane.setName("vesselFilterPane");
    }

    protected void createVesselLabel() {
        $objectMap.put("vesselLabel", vesselLabel = new JLabel());
        
        vesselLabel.setName("vesselLabel");
        vesselLabel.setText(_("tutti.editCruise.field.vessel"));
        vesselLabel.setToolTipText(_("tutti.editCruise.field.vessel.tip"));
        vesselLabel.putClientProperty("help", "tutti.editCruise.field.vessel.help");
    }

    protected void createViewGearCaracteristicsItem() {
        $objectMap.put("viewGearCaracteristicsItem", viewGearCaracteristicsItem = new JMenuItem());
        
        viewGearCaracteristicsItem.setName("viewGearCaracteristicsItem");
        viewGearCaracteristicsItem.setText(_("tutti.editCruise.action.viewGearCaracteristics"));
        viewGearCaracteristicsItem.setToolTipText(_("tutti.editCruise.action.viewGearCaracteristics.tip"));
        viewGearCaracteristicsItem.putClientProperty("help", "tutti.editCruise.action.viewGearCaracteristics.help");
        viewGearCaracteristicsItem.putClientProperty("tuttiAction", ViewGearCaracteristicsAction.class);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEditCruiseTopPanel();
        addChildrenToValidator();
        addChildrenToTopToolBar();
        addChildrenToGearMenuPopup();
        // inline complete setup of $JPanel0
        $JPanel0.add(cruiseScrollPane, BorderLayout.CENTER);
        $JPanel0.add($JPanel2, BorderLayout.SOUTH);
        addChildrenToCruiseScrollPane();
        // inline complete setup of $Table0
        $Table0.add(programLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(programComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(surveyPartLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(surveyPartField), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(departureLocationLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(departureLocationComboBox), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(beginDateLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(beginDateField), new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(returnLocationLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(returnLocationComboBox), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(endDateLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(endDateField), new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(nameLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(nameField), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(generateNameButton, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(multirigNumberLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(multirigNumberField), new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel0, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JSeparator0, new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vesselFilterPane, new GridBagConstraints(0, 6, 4, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(vesselLabel, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(vesselComboBox), new GridBagConstraints(1, 7, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(gearList), new GridBagConstraints(0, 8, 4, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(0, 9, 4, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(commentPane), new GridBagConstraints(0, 10, 4, 1, 0.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToVesselFilterPane();
        addChildrenToFilterVesselAllButton();
        addChildrenToFilterVesselScientificButton();
        addChildrenToFilterVesselFishingButton();
        // inline complete setup of $JPanel1
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(headOfMissionList));
        $JPanel1.add(SwingUtil.boxComponentWithJxLayer(headOfSortRoomList));
        addChildrenToCommentPane();
        // inline complete setup of $JPanel2
        $JPanel2.add(closeButton);
        $JPanel2.add(saveButton);
        addChildrenToGearCaracteristicsEditorTitledPanel();
        
        // apply 16 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 44 property setters
        programComboBox.setBeanType(Program.class);
        departureLocationComboBox.setBeanType(TuttiLocation.class);
        returnLocationComboBox.setBeanType(TuttiLocation.class);
        vesselComboBox.setBeanType(Vessel.class);
        gearList.setBeanType(Gear.class);
        headOfMissionList.setBeanType(Person.class);
        headOfSortRoomList.setBeanType(Person.class);
        editGearCaracteristicsItem.setIcon(SwingUtil.createActionIcon("edit"));
        viewGearCaracteristicsItem.setIcon(SwingUtil.createActionIcon("show-frequency"));
        programLabel.setLabelFor(programComboBox);
        programComboBox.setBean(model);
        surveyPartLabel.setLabelFor(surveyPartField);
        departureLocationLabel.setLabelFor(departureLocationComboBox);
        departureLocationComboBox.setBean(model);
        beginDateLabel.setLabelFor(beginDateField);
        returnLocationLabel.setLabelFor(returnLocationComboBox);
        returnLocationComboBox.setBean(model);
        endDateLabel.setLabelFor(endDateField);
        nameLabel.setLabelFor(nameField);
        generateNameButton.setIcon(SwingUtil.createActionIcon("generate"));
        generateNameButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCruise.action.generateCampaignName.mnemonic"),'Z'));
        multirigNumberLabel.setLabelFor(multirigNumberField);
        multirigNumberField.setBean(model);
        multirigNumberField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        multirigNumberField.setNumberPattern(INT_1_DIGITS_PATTERN);
        multirigNumberField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        filterVesselLabel.setIcon(SwingUtil.createActionIcon("filter"));
        vesselLabel.setLabelFor(vesselComboBox);
        vesselComboBox.setBean(model);
        gearList.setBean(model);
        gearList.setBorder(BorderFactory.createTitledBorder(_("tutti.editCruise.field.gear")));
        headOfMissionList.setBean(model);
        headOfMissionList.setBorder(BorderFactory.createTitledBorder(_("tutti.editCruise.field.headOfMission")));
        headOfSortRoomList.setBean(model);
        headOfSortRoomList.setBorder(BorderFactory.createTitledBorder(_("tutti.editCruise.field.headOfSortRoom")));
        commentPane.setBorder(BorderFactory.createTitledBorder(_("tutti.editCruise.field.comment")));
        closeButton.setIcon(SwingUtil.createActionIcon("cancel"));
        closeButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCruise.action.closeEditCruise.mnemonic"),'Z'));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        saveButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.editCruise.action.saveCruise.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, editCruiseTopPanel, "tutti.editCruise.help");
        registerHelpId(_broker, editGearCaracteristicsItem, "tutti.editCruise.action.editGearCaracteristics.help");
        registerHelpId(_broker, viewGearCaracteristicsItem, "tutti.editCruise.action.viewGearCaracteristics.help");
        registerHelpId(_broker, programLabel, "tutti.editCruise.field.program.help");
        registerHelpId(_broker, surveyPartLabel, "tutti.editCruise.field.surveyPart.help");
        registerHelpId(_broker, departureLocationLabel, "tutti.editCruise.field.departureLocation.help");
        registerHelpId(_broker, beginDateLabel, "tutti.editCruise.field.beginDate.help");
        registerHelpId(_broker, returnLocationLabel, "tutti.editCruise.field.returnLocation.help");
        registerHelpId(_broker, endDateLabel, "tutti.editCruise.field.endDate.help");
        registerHelpId(_broker, nameLabel, "tutti.editCruise.field.name.help");
        registerHelpId(_broker, generateNameButton, "tutti.editCruise.action.generateName.help");
        registerHelpId(_broker, multirigNumberLabel, "tutti.editCruise.field.multirigNumber.help");
        registerHelpId(_broker, filterVesselLabel, "tutti.editCruise.filterVessel.help");
        registerHelpId(_broker, vesselLabel, "tutti.editCruise.field.vessel.help");
        registerHelpId(_broker, vesselComboBox, "tutti.editCruise.field.vessel.help");
        registerHelpId(_broker, gearList, "tutti.editCruise.field.gear.help");
        registerHelpId(_broker, headOfMissionList, "tutti.editCruise.field.headOfMission.help");
        registerHelpId(_broker, headOfSortRoomList, "tutti.editCruise.field.headOfSortRoom.help");
        registerHelpId(_broker, commentPane, "tutti.editCruise.field.comment.help");
        registerHelpId(_broker, closeButton, "tutti.editCruise.action.close.help");
        registerHelpId(_broker, saveButton, "tutti.editCruise.action.save.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("editCruiseTopPanel", editCruiseTopPanel);
        createHandler();
        createModel();
        createValidator();
        createMainPanelLayout();
        createBroker();
        createTopToolBar();
        createAttachmentsButton();
        createGearMenuPopup();
        createEditGearCaracteristicsItem();
        createViewGearCaracteristicsItem();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createCruiseScrollPane();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createProgramLabel();
        createProgramComboBox();
        createSurveyPartLabel();
        createSurveyPartField();
        createDepartureLocationLabel();
        createDepartureLocationComboBox();
        createBeginDateLabel();
        createBeginDateField();
        createReturnLocationLabel();
        createReturnLocationComboBox();
        createEndDateLabel();
        createEndDateField();
        createNameLabel();
        createNameField();
        createGenerateNameButton();
        createMultirigNumberLabel();
        createMultirigNumberField();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator(SwingConstants.HORIZONTAL));
        
        $JSeparator0.setName("$JSeparator0");
        createVesselFilterPane();
        createFilterVesselLabel();
        createFilterVesselAllButton();
        createFilterVesselScientificButton();
        createFilterVesselFishingButton();
        createVesselLabel();
        createVesselComboBox();
        createGearList();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1, 0));
        createHeadOfMissionList();
        createHeadOfSortRoomList();
        createCommentPane();
        createCommentField();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1, 0));
        createCloseButton();
        createSaveButton();
        createGearCaracteristicsEditorTitledPanel();
        createGearCaracteristicsEditor();
        createFilterVesselType();
        // inline creation of editCruiseTopPanel
        setName("editCruiseTopPanel");
        setLayout(mainPanelLayout);
        editCruiseTopPanel.putClientProperty("help", "tutti.editCruise.help");
        
        // registers 16 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 16 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_ATTACHMENTS_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("id", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    attachmentsButton.setEnabled(model.getId() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("id", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programComboBox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SURVEY_PART_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("surveyPart", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(surveyPartField, model.getSurveyPart());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("surveyPart", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DEPARTURE_LOCATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("departureLocation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    departureLocationComboBox.setSelectedItem(model.getDepartureLocation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("departureLocation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BEGIN_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("beginDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    beginDateField.setDate(model.getBeginDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("beginDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RETURN_LOCATION_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("returnLocation", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    returnLocationComboBox.setSelectedItem(model.getReturnLocation());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("returnLocation", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_END_DATE_FIELD_DATE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("endDate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    endDateField.setDate(model.getEndDate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("endDate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NAME_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("name", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(nameField, model.getName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("name", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_NAME_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canGenerateName", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateNameButton.setEnabled(model.isCanGenerateName());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canGenerateName", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MULTIRIG_NUMBER_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("multirigNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    multirigNumberField.setModel(model.getMultirigNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("multirigNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_ALL_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeAll", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselAllButton.setSelected(model.isVesselTypeAll());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeAll", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_SCIENTIFIC_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeScientific", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselScientificButton.setSelected(model.isVesselTypeScientific());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeScientific", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_FILTER_VESSEL_FISHING_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vesselTypeFishing", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    filterVesselFishingButton.setSelected(model.isVesselTypeFishing());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vesselTypeFishing", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VESSEL_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("vessel", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    vesselComboBox.setSelectedItem(model.getVessel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("vessel", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_COMMENT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("comment", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(commentField, model.getComment());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("comment", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isModify() && model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("modify", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}