package fr.ifremer.tutti.ui.swing.content.home;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.ui.swing.TuttiHelpBroker;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.ActionListCellRenderer;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.swing.help.JAXXHelpUI;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n._;

public class SelectCruiseUI extends JPanel implements JAXXHelpUI<TuttiHelpBroker>, TuttiUI<SelectCruiseUIModel, SelectCruiseUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_CRUISE_COMBOBOX_ENABLED = "cruiseCombobox.enabled";
    public static final String BINDING_CRUISE_COMBOBOX_SELECTED_ITEM = "cruiseCombobox.selectedItem";
    public static final String BINDING_EDIT_CATCHES_BUTTON_ENABLED = "editCatchesButton.enabled";
    public static final String BINDING_EDIT_CRUISE_COMBO_BOX_ENABLED = "editCruiseComboBox.enabled";
    public static final String BINDING_EDIT_PROGRAM_COMBO_BOX_ENABLED = "editProgramComboBox.enabled";
    public static final String BINDING_EDIT_PROTOCOL_COMBO_BOX_ENABLED = "editProtocolComboBox.enabled";
    public static final String BINDING_NEW_CRUISE_BUTTON_ENABLED = "newCruiseButton.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_ENABLED = "programCombobox.enabled";
    public static final String BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM = "programCombobox.selectedItem";
    public static final String BINDING_PROTOCOL_COMBOBOX_ENABLED = "protocolCombobox.enabled";
    public static final String BINDING_PROTOCOL_COMBOBOX_SELECTED_ITEM = "protocolCombobox.selectedItem";
    public static final String BINDING_VALIDATE_CATCHES_BUTTON_ENABLED = "validateCatchesButton.enabled";
    public static final String BINDING_WARNING_CONTAINER_VISIBLE = "warningContainer.visible";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SelectCruiseUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiHelpBroker broker;
    protected JButton cloneProtocolButton;
    @ValidatorField( validatorId = "validator",  propertyName = "cruise",  editorName = "cruiseCombobox")
    protected BeanFilterableComboBox<Cruise> cruiseCombobox;
    protected JLabel cruiseLabel;
    protected JButton deleteProtocolButton;
    protected JButton editCatchesButton;
    protected JButton editCruiseButton;
    protected JComboBox editCruiseComboBox;
    protected JButton editProgramButton;
    protected JComboBox editProgramComboBox;
    protected JButton editProtocolButton;
    protected JComboBox editProtocolComboBox;
    protected JButton exportCruiseButton;
    protected JButton exportCruiseForSumatraButton;
    protected JButton exportProgramButton;
    protected JButton exportProtocolButton;
    protected SelectCruiseUIHandler handler;
    protected JButton importProtocolButton;
    protected SelectCruiseUIModel model;
    protected JButton newCruiseButton;
    protected JButton newProgramButton;
    protected JButton newProtocolButton;
    protected JComboBox newProtocolComboBox;
    @ValidatorField( validatorId = "validator",  propertyName = "program",  editorName = "programCombobox")
    protected BeanFilterableComboBox<Program> programCombobox;
    protected JLabel programLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "protocol",  editorName = "protocolCombobox")
    protected BeanFilterableComboBox<TuttiProtocol> protocolCombobox;
    protected JLabel protocolLabel;
    protected SelectCruiseUI selectCruiseTopPanel = this;
    protected JButton sendCruiseReportButton;
    protected JButton validateCatchesButton;
    @Validator( validatorId = "validator")
    protected SwingValidator<SelectCruiseUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();
    protected JPanel warningContainer;
    protected JLabel warningLabel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JPanel $JPanel3;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected TuttiUIContext uiContext;
    
    
        protected void $afterCompleteSetup() {
            handler.afterInitUI();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SelectCruiseUI(TuttiUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                uiContext = parentUI.getHandler().getContext();
                SelectCruiseUIHandler handler =
                                     new SelectCruiseUIHandler(parentUI, this);
                setContextValue(handler);
                handler.beforeInitUI();
            $initialize();
    }

    public SelectCruiseUI() {
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SelectCruiseUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SelectCruiseUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__editCruiseComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startEditCruiseAction(event);
    }

    public void doActionPerformed__on__editProgramComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startEditProgramAction(event);
    }

    public void doActionPerformed__on__editProtocolComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startExistingProtocolAction(event);
    }

    public void doActionPerformed__on__newProtocolComboBox(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startNewProtocolAction(event);
    }

    public void doMouseClicked__on__editCruiseComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editCruiseComboBox.isEnabled()) { handler.startEditCruiseAction(event); }
    }

    public void doMouseClicked__on__editProgramComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProgramComboBox.isEnabled()) { handler.startEditProgramAction(event); }
    }

    public void doMouseClicked__on__editProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProtocolComboBox.isEnabled()) { handler.startExistingProtocolAction(event); }
    }

    public void doMouseClicked__on__newProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.startNewProtocolAction(event);
    }

    public void doMouseEntered__on__editCruiseComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editCruiseComboBox.isEnabled()) { editCruiseComboBox.showPopup(); }
    }

    public void doMouseEntered__on__editProgramComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProgramComboBox.isEnabled()) { editProgramComboBox.showPopup(); }
    }

    public void doMouseEntered__on__editProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        if (editProtocolComboBox.isEnabled()) { editProtocolComboBox.showPopup(); }
    }

    public void doMouseEntered__on__newProtocolComboBox(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        newProtocolComboBox.showPopup();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TuttiHelpBroker getBroker() {
        return broker;
    }

    public JButton getCloneProtocolButton() {
        return cloneProtocolButton;
    }

    public BeanFilterableComboBox<Cruise> getCruiseCombobox() {
        return cruiseCombobox;
    }

    public JLabel getCruiseLabel() {
        return cruiseLabel;
    }

    public JButton getDeleteProtocolButton() {
        return deleteProtocolButton;
    }

    public JButton getEditCatchesButton() {
        return editCatchesButton;
    }

    public JButton getEditCruiseButton() {
        return editCruiseButton;
    }

    public JComboBox getEditCruiseComboBox() {
        return editCruiseComboBox;
    }

    public JButton getEditProgramButton() {
        return editProgramButton;
    }

    public JComboBox getEditProgramComboBox() {
        return editProgramComboBox;
    }

    public JButton getEditProtocolButton() {
        return editProtocolButton;
    }

    public JComboBox getEditProtocolComboBox() {
        return editProtocolComboBox;
    }

    public JButton getExportCruiseButton() {
        return exportCruiseButton;
    }

    public JButton getExportCruiseForSumatraButton() {
        return exportCruiseForSumatraButton;
    }

    public JButton getExportProgramButton() {
        return exportProgramButton;
    }

    public JButton getExportProtocolButton() {
        return exportProtocolButton;
    }

    public SelectCruiseUIHandler getHandler() {
        return handler;
    }

    public JButton getImportProtocolButton() {
        return importProtocolButton;
    }

    public SelectCruiseUIModel getModel() {
        return model;
    }

    public JButton getNewCruiseButton() {
        return newCruiseButton;
    }

    public JButton getNewProgramButton() {
        return newProgramButton;
    }

    public JButton getNewProtocolButton() {
        return newProtocolButton;
    }

    public JComboBox getNewProtocolComboBox() {
        return newProtocolComboBox;
    }

    public BeanFilterableComboBox<Program> getProgramCombobox() {
        return programCombobox;
    }

    public JLabel getProgramLabel() {
        return programLabel;
    }

    public BeanFilterableComboBox<TuttiProtocol> getProtocolCombobox() {
        return protocolCombobox;
    }

    public JLabel getProtocolLabel() {
        return protocolLabel;
    }

    public JButton getSendCruiseReportButton() {
        return sendCruiseReportButton;
    }

    public JButton getValidateCatchesButton() {
        return validateCatchesButton;
    }

    public SwingValidator<SelectCruiseUIModel> getValidator() {
        return validator;
    }

    public JPanel getWarningContainer() {
        return warningContainer;
    }

    public JLabel getWarningLabel() {
        return warningLabel;
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Other methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void registerHelpId(TuttiHelpBroker broker, Component component, String helpId) {
        broker.installUI(component, helpId);
    }

    @Override
    public void showHelp(String helpId) {
        getBroker().showHelp(this, helpId);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSelectCruiseTopPanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(editProgramButton);
        add(exportProgramButton);
        add(editCruiseButton);
        add(exportCruiseButton);
        add(sendCruiseReportButton);
        add(exportCruiseForSumatraButton);
        add(newProtocolButton);
        add(importProtocolButton);
        add(editProtocolButton);
        add(cloneProtocolButton);
        add(exportProtocolButton);
        add(deleteProtocolButton);
        add($Table0, BorderLayout.CENTER);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void addChildrenToWarningContainer() {
        if (!allComponentsCreated) {
            return;
        }
        warningContainer.add(warningLabel, BorderLayout.CENTER);
    }

    protected void createBroker() {
        $objectMap.put("broker", broker = new TuttiHelpBroker("tutti.selectCruise.help"));
    }

    protected void createCloneProtocolButton() {
        $objectMap.put("cloneProtocolButton", cloneProtocolButton = new JButton());
        
        cloneProtocolButton.setName("cloneProtocolButton");
        cloneProtocolButton.setText(_("tutti.selectCruise.action.cloneProtocol"));
        cloneProtocolButton.setToolTipText(_("tutti.selectCruise.action.cloneProtocol.tip"));
        cloneProtocolButton.putClientProperty("help", "tutti.selectCruise.action.cloneProtocol.help");
        cloneProtocolButton.putClientProperty("tuttiAction", CloneProtocolAction.class);
    }

    protected void createCruiseCombobox() {
        $objectMap.put("cruiseCombobox", cruiseCombobox = new BeanFilterableComboBox<Cruise>(this));
        
        cruiseCombobox.setName("cruiseCombobox");
        cruiseCombobox.setI18nPrefix("tutti.property.");
        cruiseCombobox.setProperty("cruise");
        cruiseCombobox.setShowReset(true);
        cruiseCombobox.putClientProperty("validatorLabel", _("tutti.selectCruise.field.cruise"));
    }

    protected void createCruiseLabel() {
        $objectMap.put("cruiseLabel", cruiseLabel = new JLabel());
        
        cruiseLabel.setName("cruiseLabel");
        cruiseLabel.setText(_("tutti.selectCruise.field.cruise"));
        cruiseLabel.setToolTipText(_("tutti.selectCruise.field.cruise.tip"));
        cruiseLabel.putClientProperty("help", "tutti.selectCruise.field.cruise.help");
    }

    protected void createDeleteProtocolButton() {
        $objectMap.put("deleteProtocolButton", deleteProtocolButton = new JButton());
        
        deleteProtocolButton.setName("deleteProtocolButton");
        deleteProtocolButton.setText(_("tutti.selectCruise.action.deleteProtocol"));
        deleteProtocolButton.setToolTipText(_("tutti.selectCruise.action.deleteProtocol.tip"));
        deleteProtocolButton.putClientProperty("help", "tutti.selectCruise.action.deleteProtocol.help");
        deleteProtocolButton.putClientProperty("tuttiAction", DeleteProtocolAction.class);
    }

    protected void createEditCatchesButton() {
        $objectMap.put("editCatchesButton", editCatchesButton = new JButton());
        
        editCatchesButton.setName("editCatchesButton");
        editCatchesButton.setText(_("tutti.selectCruise.action.editCatches"));
        editCatchesButton.setToolTipText(_("tutti.selectCruise.action.editCatches.tip"));
        editCatchesButton.putClientProperty("help", "tutti.selectCruise.action.editCatches.help");
        editCatchesButton.putClientProperty("tuttiAction", EditCatchesAction.class);
    }

    protected void createEditCruiseButton() {
        $objectMap.put("editCruiseButton", editCruiseButton = new JButton());
        
        editCruiseButton.setName("editCruiseButton");
        editCruiseButton.setText(_("tutti.selectCruise.action.editCruise"));
        editCruiseButton.setToolTipText(_("tutti.selectCruise.action.editCruise.tip"));
        editCruiseButton.putClientProperty("help", "tutti.selectCruise.action.editCruise.help");
        editCruiseButton.putClientProperty("tuttiAction", EditCruiseAction.class);
    }

    protected void createEditCruiseComboBox() {
        $objectMap.put("editCruiseComboBox", editCruiseComboBox = new JComboBox());
        
        editCruiseComboBox.setName("editCruiseComboBox");
        editCruiseComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editCruiseComboBox"));
        editCruiseComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__editCruiseComboBox"));
        editCruiseComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__editCruiseComboBox"));
    }

    protected void createEditProgramButton() {
        $objectMap.put("editProgramButton", editProgramButton = new JButton());
        
        editProgramButton.setName("editProgramButton");
        editProgramButton.setText(_("tutti.selectCruise.action.editProgram"));
        editProgramButton.setToolTipText(_("tutti.selectCruise.action.editProgram.tip"));
        editProgramButton.putClientProperty("help", "tutti.selectCruise.action.editProgram.help");
        editProgramButton.putClientProperty("tuttiAction", EditProgramAction.class);
    }

    protected void createEditProgramComboBox() {
        $objectMap.put("editProgramComboBox", editProgramComboBox = new JComboBox());
        
        editProgramComboBox.setName("editProgramComboBox");
        editProgramComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editProgramComboBox"));
        editProgramComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__editProgramComboBox"));
        editProgramComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__editProgramComboBox"));
    }

    protected void createEditProtocolButton() {
        $objectMap.put("editProtocolButton", editProtocolButton = new JButton());
        
        editProtocolButton.setName("editProtocolButton");
        editProtocolButton.setText(_("tutti.selectCruise.action.editProtocol"));
        editProtocolButton.setToolTipText(_("tutti.selectCruise.action.editProtocol.tip"));
        editProtocolButton.putClientProperty("help", "tutti.selectCruise.action.editProtocol.help");
        editProtocolButton.putClientProperty("tuttiAction", EditProtocolAction.class);
    }

    protected void createEditProtocolComboBox() {
        $objectMap.put("editProtocolComboBox", editProtocolComboBox = new JComboBox());
        
        editProtocolComboBox.setName("editProtocolComboBox");
        editProtocolComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__editProtocolComboBox"));
        editProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__editProtocolComboBox"));
        editProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__editProtocolComboBox"));
    }

    protected void createExportCruiseButton() {
        $objectMap.put("exportCruiseButton", exportCruiseButton = new JButton());
        
        exportCruiseButton.setName("exportCruiseButton");
        exportCruiseButton.setEnabled(false);
        exportCruiseButton.setText(_("tutti.selectCruise.action.exportCruise"));
        exportCruiseButton.setToolTipText(_("tutti.selectCruise.action.exportCruise.tip"));
        exportCruiseButton.putClientProperty("help", "tutti.selectCruise.action.exportCruise.help");
        exportCruiseButton.putClientProperty("tuttiAction", ExportCruiseAction.class);
    }

    protected void createExportCruiseForSumatraButton() {
        $objectMap.put("exportCruiseForSumatraButton", exportCruiseForSumatraButton = new JButton());
        
        exportCruiseForSumatraButton.setName("exportCruiseForSumatraButton");
        exportCruiseForSumatraButton.setText(_("tutti.selectCruise.action.exportCruiseForSumatra"));
        exportCruiseForSumatraButton.setToolTipText(_("tutti.selectCruise.action.exportCruiseForSumatra.tip"));
        exportCruiseForSumatraButton.putClientProperty("help", "tutti.selectCruise.action.exportCruiseForSumatra.help");
        exportCruiseForSumatraButton.putClientProperty("tuttiAction", ExportCruiseForSumatraAction.class);
    }

    protected void createExportProgramButton() {
        $objectMap.put("exportProgramButton", exportProgramButton = new JButton());
        
        exportProgramButton.setName("exportProgramButton");
        exportProgramButton.setEnabled(false);
        exportProgramButton.setText(_("tutti.selectCruise.action.exportProgram"));
        exportProgramButton.setToolTipText(_("tutti.selectCruise.action.exportProgram.tip"));
        exportProgramButton.putClientProperty("help", "tutti.selectCruise.action.exportProgram.help");
        exportProgramButton.putClientProperty("tuttiAction", ExportProgramAction.class);
    }

    protected void createExportProtocolButton() {
        $objectMap.put("exportProtocolButton", exportProtocolButton = new JButton());
        
        exportProtocolButton.setName("exportProtocolButton");
        exportProtocolButton.setText(_("tutti.selectCruise.action.exportProtocol"));
        exportProtocolButton.setToolTipText(_("tutti.selectCruise.action.exportProtocol.tip"));
        exportProtocolButton.putClientProperty("help", "tutti.selectCruise.action.exportProtocol.help");
        exportProtocolButton.putClientProperty("tuttiAction", ExportProtocolAction.class);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SelectCruiseUIHandler.class));
    }

    protected void createImportProtocolButton() {
        $objectMap.put("importProtocolButton", importProtocolButton = new JButton());
        
        importProtocolButton.setName("importProtocolButton");
        importProtocolButton.setText(_("tutti.selectCruise.action.importProtocol"));
        importProtocolButton.setToolTipText(_("tutti.selectCruise.action.importProtocol.tip"));
        importProtocolButton.putClientProperty("help", "tutti.selectCruise.action.importProtocol.help");
        importProtocolButton.putClientProperty("tuttiAction", ImportProtocolAction.class);
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SelectCruiseUIModel.class));
    }

    protected void createNewCruiseButton() {
        $objectMap.put("newCruiseButton", newCruiseButton = new JButton());
        
        newCruiseButton.setName("newCruiseButton");
        newCruiseButton.setText(_("tutti.selectCruise.action.newCruise"));
        newCruiseButton.setToolTipText(_("tutti.selectCruise.action.newCruise.tip"));
        newCruiseButton.putClientProperty("help", "tutti.selectCruise.action.newCruise.help");
        newCruiseButton.putClientProperty("tuttiAction", NewCruiseAction.class);
    }

    protected void createNewProgramButton() {
        $objectMap.put("newProgramButton", newProgramButton = new JButton());
        
        newProgramButton.setName("newProgramButton");
        newProgramButton.setText(_("tutti.selectCruise.action.newProgram"));
        newProgramButton.setToolTipText(_("tutti.selectCruise.action.newProgram.tip"));
        newProgramButton.putClientProperty("help", "tutti.selectCruise.action.newProgram.help");
        newProgramButton.putClientProperty("tuttiAction", NewProgramAction.class);
    }

    protected void createNewProtocolButton() {
        $objectMap.put("newProtocolButton", newProtocolButton = new JButton());
        
        newProtocolButton.setName("newProtocolButton");
        newProtocolButton.setText(_("tutti.selectCruise.action.newProtocol"));
        newProtocolButton.setToolTipText(_("tutti.selectCruise.action.newProtocol.tip"));
        newProtocolButton.putClientProperty("help", "tutti.selectCruise.action.newProtocol.help");
        newProtocolButton.putClientProperty("tuttiAction", NewProtocolAction.class);
    }

    protected void createNewProtocolComboBox() {
        $objectMap.put("newProtocolComboBox", newProtocolComboBox = new JComboBox());
        
        newProtocolComboBox.setName("newProtocolComboBox");
        newProtocolComboBox.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__newProtocolComboBox"));
        newProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__newProtocolComboBox"));
        newProtocolComboBox.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseEntered", this, "doMouseEntered__on__newProtocolComboBox"));
    }

    protected void createProgramCombobox() {
        $objectMap.put("programCombobox", programCombobox = new BeanFilterableComboBox<Program>(this));
        
        programCombobox.setName("programCombobox");
        programCombobox.setI18nPrefix("tutti.property.");
        programCombobox.setProperty("program");
        programCombobox.setShowReset(true);
        programCombobox.putClientProperty("validatorLabel", _("tutti.selectCruise.field.program"));
    }

    protected void createProgramLabel() {
        $objectMap.put("programLabel", programLabel = new JLabel());
        
        programLabel.setName("programLabel");
        programLabel.setText(_("tutti.selectCruise.field.program"));
        programLabel.setToolTipText(_("tutti.selectCruise.field.program.tip"));
        programLabel.putClientProperty("help", "tutti.selectCruise.field.program.help");
    }

    protected void createProtocolCombobox() {
        $objectMap.put("protocolCombobox", protocolCombobox = new BeanFilterableComboBox<TuttiProtocol>(this));
        
        protocolCombobox.setName("protocolCombobox");
        protocolCombobox.setI18nPrefix("tutti.property.");
        protocolCombobox.setProperty("protocol");
        protocolCombobox.setShowReset(true);
        protocolCombobox.putClientProperty("validatorLabel", _("tutti.selectCruise.field.protocol"));
    }

    protected void createProtocolLabel() {
        $objectMap.put("protocolLabel", protocolLabel = new JLabel());
        
        protocolLabel.setName("protocolLabel");
        protocolLabel.setText(_("tutti.selectCruise.field.protocol"));
        protocolLabel.setToolTipText(_("tutti.selectCruise.field.protocol.tip"));
        protocolLabel.putClientProperty("help", "tutti.selectCruise.field.protocol.help");
    }

    protected void createSendCruiseReportButton() {
        $objectMap.put("sendCruiseReportButton", sendCruiseReportButton = new JButton());
        
        sendCruiseReportButton.setName("sendCruiseReportButton");
        sendCruiseReportButton.setText(_("tutti.selectCruise.action.sendCruiseReport"));
        sendCruiseReportButton.setToolTipText(_("tutti.selectCruise.action.sendCruiseReport.tip"));
        sendCruiseReportButton.putClientProperty("help", "tutti.selectCruise.action.sendCruiseReport.help");
        sendCruiseReportButton.putClientProperty("tuttiAction", SendCruiseReportAction.class);
    }

    protected void createValidateCatchesButton() {
        $objectMap.put("validateCatchesButton", validateCatchesButton = new JButton());
        
        validateCatchesButton.setName("validateCatchesButton");
        validateCatchesButton.setText(_("tutti.selectCruise.action.validateCatches"));
        validateCatchesButton.setToolTipText(_("tutti.selectCruise.action.validateCatches.tip"));
        validateCatchesButton.putClientProperty("help", "tutti.selectCruise.action.validateCatches.help");
        validateCatchesButton.putClientProperty("tuttiAction", ValidateCatchesAction.class);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SelectCruiseUIModel.class, null));
    }

    protected void createWarningContainer() {
        $objectMap.put("warningContainer", warningContainer = new JPanel());
        
        warningContainer.setName("warningContainer");
        warningContainer.setLayout(new BorderLayout(10, 10));
    }

    protected void createWarningLabel() {
        $objectMap.put("warningLabel", warningLabel = new JLabel());
        
        warningLabel.setName("warningLabel");
        warningLabel.setText(_("tutti.selectCruise.warn.invalid.selected.data"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToSelectCruiseTopPanel();
        addChildrenToValidator();
        // inline complete setup of $Table0
        $Table0.add(warningContainer, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(programLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(programCombobox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(cruiseLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(cruiseCombobox), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel1, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(protocolLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(SwingUtil.boxComponentWithJxLayer(protocolCombobox), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel3, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToWarningContainer();
        // inline complete setup of $JPanel0
        $JPanel0.add(editProgramComboBox);
        $JPanel0.add(newProgramButton);
        // inline complete setup of $JPanel1
        $JPanel1.add(editCruiseComboBox);
        $JPanel1.add(newCruiseButton);
        // inline complete setup of $JPanel2
        $JPanel2.add(editProtocolComboBox);
        $JPanel2.add(newProtocolComboBox);
        // inline complete setup of $JPanel3
        $JPanel3.add(editCatchesButton);
        $JPanel3.add(validateCatchesButton);
        
        // apply 13 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 46 property setters
        programCombobox.setBeanType(Program.class);
        cruiseCombobox.setBeanType(Cruise.class);
        protocolCombobox.setBeanType(TuttiProtocol.class);
        editProgramButton.setIcon(SwingUtil.createActionIcon("edit"));
        exportProgramButton.setIcon(SwingUtil.createActionIcon("export"));
        editCruiseButton.setIcon(SwingUtil.createActionIcon("edit"));
        exportCruiseButton.setIcon(SwingUtil.createActionIcon("export"));
        sendCruiseReportButton.setIcon(SwingUtil.createActionIcon("email"));
        exportCruiseForSumatraButton.setIcon(SwingUtil.createActionIcon("export"));
        newProtocolButton.setIcon(SwingUtil.createActionIcon("add"));
        importProtocolButton.setIcon(SwingUtil.createActionIcon("import"));
        editProtocolButton.setIcon(SwingUtil.createActionIcon("edit"));
        cloneProtocolButton.setIcon(SwingUtil.createActionIcon("copy"));
        exportProtocolButton.setIcon(SwingUtil.createActionIcon("export"));
        deleteProtocolButton.setIcon(SwingUtil.createActionIcon("delete"));
        warningContainer.setBackground(new java.awt.Color(245, 218, 88));
        warningLabel.setIcon(SwingUtil.createActionIcon("warning"));
        warningLabel.setBorder(new javax.swing.border.EmptyBorder(5, 10, 5, 10));
        programLabel.setIcon(SwingUtil.createActionIcon("program"));
        programCombobox.setBean(model);
        editProgramComboBox.setModel(handler.newComboModel(editProgramButton, exportProgramButton));
        editProgramComboBox.setRenderer(new ActionListCellRenderer());
        newProgramButton.setIcon(SwingUtil.createActionIcon("add"));
        cruiseLabel.setLabelFor(cruiseCombobox);
        cruiseLabel.setIcon(SwingUtil.createActionIcon("cruise"));
        cruiseCombobox.setBean(model);
        editCruiseComboBox.setModel(handler.newComboModel(editCruiseButton, exportCruiseButton, sendCruiseReportButton, exportCruiseForSumatraButton));
        editCruiseComboBox.setRenderer(new ActionListCellRenderer());
        newCruiseButton.setIcon(SwingUtil.createActionIcon("add"));
        protocolLabel.setLabelFor(protocolCombobox);
        protocolLabel.setIcon(SwingUtil.createActionIcon("protocol"));
        protocolCombobox.setBean(model);
        editProtocolComboBox.setModel(handler.newComboModel(editProtocolButton, cloneProtocolButton, exportProtocolButton, deleteProtocolButton));
        editProtocolComboBox.setRenderer(new ActionListCellRenderer());
        newProtocolComboBox.setModel(handler.newComboModel(newProtocolButton, importProtocolButton));
        newProtocolComboBox.setRenderer(new ActionListCellRenderer());
        editCatchesButton.setIcon(SwingUtil.createActionIcon("edit"));
        editCatchesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectCruise.action.editCatches.mnemonic"),'Z'));
        validateCatchesButton.setIcon(SwingUtil.createActionIcon("validate"));
        validateCatchesButton.setMnemonic(SwingUtil.getFirstCharAt(_("tutti.selectCruise.action.validateCatches.mnemonic"),'Z'));
        // late initializer
        // help broker setup
        TuttiHelpBroker _broker = getBroker();
        registerHelpId(_broker, selectCruiseTopPanel, "tutti.selectCruise.help");
        registerHelpId(_broker, editProgramButton, "tutti.selectCruise.action.editProgram.help");
        registerHelpId(_broker, exportProgramButton, "tutti.selectCruise.action.exportProgram.help");
        registerHelpId(_broker, editCruiseButton, "tutti.selectCruise.action.editCruise.help");
        registerHelpId(_broker, exportCruiseButton, "tutti.selectCruise.action.exportCruise.help");
        registerHelpId(_broker, sendCruiseReportButton, "tutti.selectCruise.action.sendCruiseReport.help");
        registerHelpId(_broker, exportCruiseForSumatraButton, "tutti.selectCruise.action.exportCruiseForSumatra.help");
        registerHelpId(_broker, newProtocolButton, "tutti.selectCruise.action.newProtocol.help");
        registerHelpId(_broker, importProtocolButton, "tutti.selectCruise.action.importProtocol.help");
        registerHelpId(_broker, editProtocolButton, "tutti.selectCruise.action.editProtocol.help");
        registerHelpId(_broker, cloneProtocolButton, "tutti.selectCruise.action.cloneProtocol.help");
        registerHelpId(_broker, exportProtocolButton, "tutti.selectCruise.action.exportProtocol.help");
        registerHelpId(_broker, deleteProtocolButton, "tutti.selectCruise.action.deleteProtocol.help");
        registerHelpId(_broker, programLabel, "tutti.selectCruise.field.program.help");
        registerHelpId(_broker, newProgramButton, "tutti.selectCruise.action.newProgram.help");
        registerHelpId(_broker, cruiseLabel, "tutti.selectCruise.field.cruise.help");
        registerHelpId(_broker, newCruiseButton, "tutti.selectCruise.action.newCruise.help");
        registerHelpId(_broker, protocolLabel, "tutti.selectCruise.field.protocol.help");
        registerHelpId(_broker, editCatchesButton, "tutti.selectCruise.action.editCatches.help");
        registerHelpId(_broker, validateCatchesButton, "tutti.selectCruise.action.validateCatches.help");
        _broker.prepareUI(this);
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("selectCruiseTopPanel", selectCruiseTopPanel);
        createHandler();
        createModel();
        createValidator();
        createBroker();
        createEditProgramButton();
        createExportProgramButton();
        createEditCruiseButton();
        createExportCruiseButton();
        createSendCruiseReportButton();
        createExportCruiseForSumatraButton();
        createNewProtocolButton();
        createImportProtocolButton();
        createEditProtocolButton();
        createCloneProtocolButton();
        createExportProtocolButton();
        createDeleteProtocolButton();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createWarningContainer();
        createWarningLabel();
        createProgramLabel();
        createProgramCombobox();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createEditProgramComboBox();
        createNewProgramButton();
        createCruiseLabel();
        createCruiseCombobox();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createEditCruiseComboBox();
        createNewCruiseButton();
        createProtocolLabel();
        createProtocolCombobox();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1,0));
        createEditProtocolComboBox();
        createNewProtocolComboBox();
        // inline creation of $JPanel3
        $objectMap.put("$JPanel3", $JPanel3 = new JPanel());
        
        $JPanel3.setName("$JPanel3");
        $JPanel3.setLayout(new GridLayout(1,0));
        createEditCatchesButton();
        createValidateCatchesButton();
        // inline creation of selectCruiseTopPanel
        setName("selectCruiseTopPanel");
        setLayout(new BorderLayout());
        selectCruiseTopPanel.putClientProperty("help", "tutti.selectCruise.help");
        
        // registers 13 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 13 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_WARNING_CONTAINER_VISIBLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    warningContainer.setVisible(!model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (programCombobox != null) {
                    programCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (programCombobox != null) {
                    programCombobox.setEnabled(!programCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (programCombobox != null) {
                    programCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROGRAM_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("program", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    programCombobox.setSelectedItem(model.getProgram());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("program", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROGRAM_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProgramComboBox.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.setEnabled(!cruiseCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (cruiseCombobox != null) {
                    cruiseCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CRUISE_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("cruise", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    cruiseCombobox.setSelectedItem(model.getCruise());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("cruise", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CRUISE_COMBO_BOX_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.addPropertyChangeListener("cruiseFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editCruiseComboBox.setEnabled(model.isProgramFound() && model.isCruiseFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
                if (model != null) {
                    model.removePropertyChangeListener("cruiseFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NEW_CRUISE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("programFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    newCruiseButton.setEnabled(model.isProgramFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("programFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROTOCOL_COMBOBOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.addPropertyChangeListener("empty", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.setEnabled(!protocolCombobox.isEmpty());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (protocolCombobox != null) {
                    protocolCombobox.removePropertyChangeListener("empty", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_PROTOCOL_COMBOBOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("protocol", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    protocolCombobox.setSelectedItem(model.getProtocol());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("protocol", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_PROTOCOL_COMBO_BOX_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("protocolFound", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    editProtocolComboBox.setEnabled(model.isProtocolFound());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("protocolFound", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_EDIT_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                addPropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && uiContext != null) {
                    editCatchesButton.setEnabled(model.isValid() && uiContext.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                removePropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_VALIDATE_CATCHES_BUTTON_ENABLED, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
                addPropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.addPropertyChangeListener("cruiseFilled", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null && uiContext != null) {
                    validateCatchesButton.setEnabled(model.isValid() && uiContext.isCruiseFilled());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
                removePropertyChangeListener("uiContext", this);
                if (uiContext != null) {
                    uiContext.removePropertyChangeListener("cruiseFilled", this);
                }
            }
        });
    }

}