/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.timer;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.scheduling.timer.DelegatingTimerTask;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class TimerTaskExecutor
implements SchedulingTaskExecutor,
BeanNameAware,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Timer timer;
    private long delay = 0L;
    private String beanName;
    private boolean timerInternal = false;

    public TimerTaskExecutor() {
    }

    public TimerTaskExecutor(Timer timer) {
        Assert.notNull((Object)timer, (String)"Timer must not be null");
        this.timer = timer;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() {
        if (this.timer == null) {
            this.logger.info((Object)"Initializing Timer");
            this.timer = this.createTimer();
            this.timerInternal = true;
        }
    }

    protected Timer createTimer() {
        if (StringUtils.hasText((String)this.beanName)) {
            return new Timer(this.beanName);
        }
        return new Timer();
    }

    protected final Timer getTimer() {
        Assert.notNull((Object)this.timer, (String)"Timer not initialized yet");
        return this.timer;
    }

    public void execute(Runnable task) {
        this.getTimer().schedule((TimerTask)new DelegatingTimerTask(task), this.delay);
    }

    public void execute(Runnable task, long startTimeout) {
        long actualDelay = startTimeout < this.delay ? startTimeout : this.delay;
        this.getTimer().schedule((TimerTask)new DelegatingTimerTask(task), actualDelay);
    }

    public Future<?> submit(Runnable task) {
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        this.execute(future);
        return future;
    }

    public <T> Future<T> submit(Callable<T> task) {
        FutureTask<T> future = new FutureTask<T>(task);
        this.execute(future);
        return future;
    }

    @Override
    public boolean prefersShortLivedTasks() {
        return true;
    }

    public void destroy() {
        if (this.timerInternal) {
            this.logger.info((Object)"Cancelling Timer");
            this.timer.cancel();
        }
    }
}

