package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportMultiPostAction.java 933 2013-05-08 16:06:49Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/ExportMultiPostAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.catches.multipost.TuttiMultiPostImportExportService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;

import java.io.File;

import static org.nuiton.i18n.I18n._;

/**
 * @author kmorin <kmorin@codelutin.com>
 * @since 2.2
 */
public class ExportMultiPostAction extends AbstractTuttiAction<SpeciesBatchUIModel, SpeciesBatchUI, SpeciesBatchUIHandler> {

    protected File file;

    protected FishingOperation currentOperation;

    protected TuttiMultiPostImportExportService multiPostImportExportService;

    public ExportMultiPostAction(SpeciesBatchUIHandler handler) {
        super(handler, false);
        multiPostImportExportService = getContext().getMultiPostImportExportService();
    }

    @Override
    protected boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            EditCatchesUI catchesUI = getUI().getParentContainer(EditCatchesUI.class);
            currentOperation = catchesUI.getModel().getFishingOperation();

            // choose file to export
            file = TuttiUIUtil.saveFile(
                    decorate(currentOperation, DecoratorService.FILE_NAME_COMPATIBLE) + ".zip",
                    getContext().getMainUI(),
                    _("tutti.editSpeciesBatch.action.exportMultiPost.destinationFile.title"),
                    _("tutti.editSpeciesBatch.action.exportMultiPost.destinationFile.button"),
                    "^.*\\.zip", _("tutti.common.file.zip")
            );
            if (file == null) {

                // user cancel
                doAction = false;
            } else {

                // ask user to confirm overwrite.
                doAction = getHandler().askOverwriteFile(file);
            }
        }
        return doAction;
    }

    @Override
    protected void releaseAction() {
        file = null;
        currentOperation = null;
        super.releaseAction();
    }

    @Override
    protected void doAction() throws Exception {
        multiPostImportExportService.exportSpecies(file, currentOperation);
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        sendMessage(_("tutti.editSpeciesBatch.action.exportMultiPost.success", file));
    }
}
