/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.dao.annotation;

import java.lang.annotation.Annotation;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.dao.annotation.PersistenceExceptionTranslationAdvisor;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceExceptionTranslationPostProcessor
extends ProxyConfig
implements BeanPostProcessor,
BeanClassLoaderAware,
BeanFactoryAware,
Ordered {
    private Class<? extends Annotation> repositoryAnnotationType = Repository.class;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private PersistenceExceptionTranslationAdvisor persistenceExceptionTranslationAdvisor;

    public void setRepositoryAnnotationType(Class<? extends Annotation> repositoryAnnotationType) {
        Assert.notNull(repositoryAnnotationType, (String)"'repositoryAnnotationType' must not be null");
        this.repositoryAnnotationType = repositoryAnnotationType;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ListableBeanFactory)) {
            throw new IllegalArgumentException("Cannot use PersistenceExceptionTranslator autodetection without ListableBeanFactory");
        }
        this.persistenceExceptionTranslationAdvisor = new PersistenceExceptionTranslationAdvisor((ListableBeanFactory)beanFactory, this.repositoryAnnotationType);
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof AopInfrastructureBean) {
            return bean;
        }
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (AopUtils.canApply((Advisor)this.persistenceExceptionTranslationAdvisor, (Class)targetClass)) {
            if (bean instanceof Advised) {
                ((Advised)bean).addAdvisor((Advisor)this.persistenceExceptionTranslationAdvisor);
                return bean;
            }
            ProxyFactory proxyFactory = new ProxyFactory(bean);
            proxyFactory.copyFrom((ProxyConfig)this);
            proxyFactory.addAdvisor((Advisor)this.persistenceExceptionTranslationAdvisor);
            return proxyFactory.getProxy(this.beanClassLoader);
        }
        return bean;
    }
}

