/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.logging.jdk;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerUtils;
import java.util.logging.Level;

public class JdkLogger
implements Logger {
    private java.util.logging.Logger log;

    public JdkLogger(java.util.logging.Logger log) {
        this.log = log;
    }

    public void error(String msg, String ... args) {
        this.log.log(Level.SEVERE, LoggerUtils.format(msg, args));
    }

    public void error(String msg, Throwable ex, String ... args) {
        this.log.log(Level.SEVERE, LoggerUtils.format(msg, args), ex);
    }

    public void fatal(String msg, String ... args) {
        this.log.log(Level.SEVERE, LoggerUtils.format(msg, args));
    }

    public void fatal(String msg, Throwable ex, String ... args) {
        this.log.log(Level.SEVERE, LoggerUtils.format(msg, args), ex);
    }

    public void info(String msg, String ... args) {
        this.log.log(Level.INFO, LoggerUtils.format(msg, args));
    }

    public void info(String msg, Throwable ex, String ... args) {
        this.log.log(Level.INFO, LoggerUtils.format(msg, args), ex);
    }

    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    public void warn(String msg, String ... args) {
        this.log.log(Level.WARNING, LoggerUtils.format(msg, args));
    }

    public void warn(String msg, Throwable ex, String ... args) {
        this.log.log(Level.WARNING, LoggerUtils.format(msg, args), ex);
    }

    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    public void debug(String msg, String ... args) {
        this.log.log(Level.FINE, LoggerUtils.format(msg, args));
    }

    public void debug(String msg, Throwable ex, String ... args) {
        this.log.log(Level.FINE, LoggerUtils.format(msg, args), ex);
    }

    public boolean isTraceEnabled() {
        return this.log.isLoggable(Level.FINEST);
    }

    public void trace(String msg, String ... args) {
        this.log.log(Level.FINEST, LoggerUtils.format(msg, args));
    }

    public void trace(String msg, Throwable ex, String ... args) {
        this.log.log(Level.FINEST, LoggerUtils.format(msg, args), ex);
    }

    public boolean isErrorEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }

    public boolean isFatalEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }

    public boolean isWarnEnabled() {
        return this.log.isLoggable(Level.WARNING);
    }
}

