/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseFishingOperationAction;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.CloseableUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.NuitonValidatorResult;
import org.nuiton.validator.NuitonValidatorScope;

public class ValidateCruiseUIHandler
extends AbstractTuttiUIHandler<ValidateCruiseUIModel, ValidateCruiseUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(ValidateCruiseUIHandler.class);
    private final PersistenceService persistenceService;
    private final ValidationService validationService;
    protected EditCruiseFishingOperationAction editFishingOperationAction;
    protected Map<FishingOperation, NuitonValidatorResult> validator;

    public ValidateCruiseUIHandler(TuttiUI parentUi, ValidateCruiseUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui);
        this.persistenceService = this.context.getPersistenceService();
        this.validationService = this.context.getValidationService();
    }

    @Override
    public void beforeInitUI() {
        this.validator = this.context.getValidateCruiseOperationsService().validateCruiseOperations();
        ValidateCruiseUIModel model = new ValidateCruiseUIModel();
        ((ValidateCruiseUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        this.editFishingOperationAction = TuttiActionHelper.createLogicAction(this, EditCruiseFishingOperationAction.class);
        ((ValidateCruiseUI)this.ui).getOperationPanel().getModel().setSelectedFishingOperation(null);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (FishingOperation operation : this.validator.keySet()) {
            operation = this.persistenceService.getFishingOperation(operation.getId());
            NuitonValidatorResult result = this.validator.get(operation);
            LinkedListMultimap messages = LinkedListMultimap.create();
            messages.putAll((Object)NuitonValidatorScope.ERROR, (Iterable)result.getMessagesForScope(NuitonValidatorScope.ERROR));
            messages.putAll((Object)NuitonValidatorScope.WARNING, (Iterable)result.getMessagesForScope(NuitonValidatorScope.WARNING));
            OperationTreeNode node = new OperationTreeNode(operation, (Multimap<NuitonValidatorScope, String>)messages);
            root.add(node);
        }
        DefaultTreeModel model = new DefaultTreeModel(root);
        final JTree navigation = ((ValidateCruiseUI)this.ui).getNavigation();
        navigation.setModel(model);
        navigation.setCellRenderer(new ValidationTreeCellRenderer());
        navigation.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Object[] paths = navigation.getSelectionPath().getPath();
                    FishingOperation operation = null;
                    for (Object o : paths) {
                        if (o == null || !OperationTreeNode.class.isAssignableFrom(o.getClass())) continue;
                        operation = (FishingOperation)((OperationTreeNode)o).getUserObject();
                        break;
                    }
                    ValidateCruiseUIHandler.this.editFishingOperationAction.setFishingOperation(operation);
                    AbstractTuttiAction.runAction(ValidateCruiseUIHandler.this.editFishingOperationAction);
                }
            }
        });
        FishingOperationsUI operationPanel = ((ValidateCruiseUI)this.ui).getOperationPanel();
        operationPanel.getTopPanel().setVisible(false);
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    @Override
    public SwingValidator<ValidateCruiseUIModel> getValidator() {
        return null;
    }

    @Override
    protected JComponent getComponentToFocus() {
        return null;
    }

    @Override
    public boolean quitUI() {
        return true;
    }

    protected class MessageTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        protected NuitonValidatorScope scope;

        public MessageTreeNode(NuitonValidatorScope scope, String message) {
            super(message);
            this.scope = scope;
        }

        public NuitonValidatorScope getScope() {
            return this.scope;
        }
    }

    protected class OperationTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;

        public OperationTreeNode(FishingOperation operation, Multimap<NuitonValidatorScope, String> messages) {
            super(operation);
            this.setAllowsChildren(messages != null);
            this.createChildren(messages);
        }

        public void createChildren(Multimap<NuitonValidatorScope, String> messages) {
            for (NuitonValidatorScope scope : messages.keySet()) {
                for (String message : messages.get((Object)scope)) {
                    MessageTreeNode child = new MessageTreeNode(scope, message);
                    this.add(child);
                }
            }
        }
    }

    protected class ValidationTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        protected ValidationTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value != null) {
                if (value instanceof OperationTreeNode) {
                    OperationTreeNode node = (OperationTreeNode)value;
                    label.setText(ValidateCruiseUIHandler.this.getDecorator(FishingOperation.class, null).toString(node.getUserObject()));
                } else if (value instanceof MessageTreeNode) {
                    MessageTreeNode node = (MessageTreeNode)value;
                    label.setText(I18n._((String)String.valueOf(node.getUserObject()), (Object[])new Object[0]));
                    String iconName = node.getScope().toString().toLowerCase();
                    label.setIcon(SwingUtil.createImageIcon((String)(iconName + ".png")));
                }
            }
            return label;
        }
    }
}

