/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SelectCruiseUIHandler
extends AbstractTuttiUIHandler<SelectCruiseUIModel, SelectCruiseUI> {
    private static final Log log = LogFactory.getLog(SelectCruiseUIHandler.class);
    protected final PersistenceService persistenceService;
    protected boolean resetEditProtolAction;

    public SelectCruiseUIHandler(TuttiUI<?, ?> parentUI, SelectCruiseUI ui) {
        super(((AbstractTuttiUIHandler)parentUI.getHandler()).getContext(), ui);
        this.persistenceService = this.context.getPersistenceService();
    }

    @Override
    public SwingValidator<SelectCruiseUIModel> getValidator() {
        return ((SelectCruiseUI)this.ui).getValidator();
    }

    @Override
    public void beforeInitUI() {
        SelectCruiseUIModel model = new SelectCruiseUIModel();
        List programs = this.persistenceService.getAllProgram();
        model.setPrograms(programs);
        if (programs.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No program found.");
            }
        } else {
            Program selectedProgram = null;
            List cruises = null;
            if (this.context.isProgramFilled()) {
                selectedProgram = this.getDataContext().getProgram();
                cruises = this.persistenceService.getAllCruise(selectedProgram.getId());
            }
            model.setProgram(selectedProgram);
            model.setCruises(cruises);
            if (!CollectionUtils.isEmpty(cruises)) {
                Cruise selectedCruise = null;
                if (this.context.isCruiseFilled()) {
                    selectedCruise = this.getDataContext().getCruise();
                }
                model.setCruise(selectedCruise);
            }
        }
        ArrayList protocols = Lists.newArrayList((Iterable)this.persistenceService.getAllProtocol());
        model.setProtocols(protocols);
        if (protocols.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No protocol found.");
            }
        } else {
            TuttiProtocol selectedProtocol = null;
            if (this.context.isProgramFilled()) {
                selectedProtocol = this.getDataContext().getProtocol();
            }
            model.setProtocol(selectedProtocol);
        }
        ((SelectCruiseUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        SelectCruiseUIModel model = (SelectCruiseUIModel)((Object)this.getModel());
        this.initBeanFilterableComboBox(((SelectCruiseUI)this.ui).getProgramCombobox(), model.getPrograms(), model.getProgram());
        this.initBeanFilterableComboBox(((SelectCruiseUI)this.ui).getCruiseCombobox(), model.getCruises(), model.getCruise());
        this.initBeanFilterableComboBox(((SelectCruiseUI)this.ui).getProtocolCombobox(), model.getProtocols(), model.getProtocol());
        ((SelectCruiseUI)this.ui).getEditProtocolComboBox().putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        ((SelectCruiseUI)this.ui).getNewProtocolComboBox().putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        model.addPropertyChangeListener("protocols", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BeanFilterableComboBox<TuttiProtocol> combobox = ((SelectCruiseUI)SelectCruiseUIHandler.this.ui).getProtocolCombobox();
                List protocols = (List)evt.getNewValue();
                combobox.setData(null);
                combobox.setData(protocols);
                ((SelectCruiseUI)SelectCruiseUIHandler.this.ui).applyDataBinding("protocolCombobox.enabled");
            }
        });
        model.addPropertyChangeListener("program", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Program newValue = (Program)evt.getNewValue();
                boolean noProgram = newValue == null;
                SelectCruiseUIHandler.this.context.setProgramId(noProgram ? null : newValue.getId());
                if (log.isInfoEnabled()) {
                    log.info((Object)("Selected program: " + newValue));
                }
                List cruises = noProgram ? Lists.newArrayList() : SelectCruiseUIHandler.this.persistenceService.getAllCruise(newValue.getId());
                SelectCruiseUIModel source = (SelectCruiseUIModel)((Object)evt.getSource());
                source.setCruises(cruises);
                source.setCruise(null);
            }
        });
        model.addPropertyChangeListener("cruises", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BeanFilterableComboBox<Cruise> combobox = ((SelectCruiseUI)SelectCruiseUIHandler.this.ui).getCruiseCombobox();
                List campaigns = (List)evt.getNewValue();
                combobox.setData(null);
                combobox.setData(campaigns);
            }
        });
        model.addPropertyChangeListener("cruise", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Cruise newValue = (Cruise)evt.getNewValue();
                SelectCruiseUIHandler.this.context.setCruiseId(newValue == null ? null : newValue.getId());
            }
        });
        model.addPropertyChangeListener("protocol", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TuttiProtocol newValue = (TuttiProtocol)evt.getNewValue();
                SelectCruiseUIHandler.this.context.setProtocolId(newValue == null ? null : newValue.getId());
            }
        });
        this.registerValidators(this.getValidator());
        this.listenValidatorValid((SimpleBeanValidator)this.getValidator(), model);
        this.getValidator().setBean((Object)model);
        ((SelectCruiseUI)this.ui).applyDataBinding("editProgramButton.enabled");
        ((SelectCruiseUI)this.ui).applyDataBinding("newCruiseButton.enabled");
        ((SelectCruiseUI)this.ui).applyDataBinding("editCruiseButton.enabled");
        ((SelectCruiseUI)this.ui).applyDataBinding("editCatchesButton.enabled");
        ((SelectCruiseUI)this.ui).applyDataBinding("validateCatchesButton.enabled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEditProtolAction() {
        this.resetEditProtolAction = true;
        try {
            ((SelectCruiseUI)this.ui).getEditProtocolComboBox().setSelectedIndex(0);
        }
        finally {
            this.resetEditProtolAction = false;
        }
    }

    @Override
    public void onCloseUI() {
        PropertyChangeListener[] listeners;
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        for (PropertyChangeListener listener : listeners = ((SelectCruiseUIModel)((Object)this.getModel())).getPropertyChangeListeners()) {
            ((SelectCruiseUIModel)((Object)this.getModel())).removePropertyChangeListener(listener);
        }
        this.clearValidators();
    }

    public void startExistingProtocolAction(MouseEvent event) {
        JComboBox existingProtocolCombo = (JComboBox)event.getSource();
        TuttiActionHelper.runAction((AbstractButton)existingProtocolCombo.getItemAt(0));
    }

    public void startExistingProtocolAction(ActionEvent event) {
        if (!this.resetEditProtolAction) {
            JComboBox existingProtocolCombo = (JComboBox)event.getSource();
            JButton selectedAction = (JButton)existingProtocolCombo.getSelectedItem();
            existingProtocolCombo.setSelectedIndex(0);
            existingProtocolCombo.hidePopup();
            TuttiActionHelper.runAction(selectedAction);
        }
    }

    public void startNewProtocolAction(MouseEvent event) {
        JComboBox newProtocolCombo = (JComboBox)event.getSource();
        TuttiActionHelper.runAction((AbstractButton)newProtocolCombo.getItemAt(0));
    }

    public void startNewProtocolAction(ActionEvent event) {
        JComboBox newProtocolCombo = (JComboBox)event.getSource();
        JButton selectedAction = (JButton)newProtocolCombo.getSelectedItem();
        newProtocolCombo.setSelectedIndex(0);
        newProtocolCombo.hidePopup();
        TuttiActionHelper.runAction(selectedAction);
    }
}

