/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.AttachementObjectTypeEnum;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.spatial.SexagecimalPosition;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import fr.ifremer.tutti.ui.swing.util.editor.CoordinateEditorType;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.nuiton.i18n.I18n;
import org.nuiton.util.DateUtil;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

public class EditFishingOperationUIModel
extends AbstractTuttiBeanUIModel<FishingOperation, EditFishingOperationUIModel>
implements AttachmentModelAware {
    private static final long serialVersionUID = 1L;
    public static final String TITLE = I18n.n_((String)"tutti.label.tab.fishingOperation.general", (Object[])new Object[0]);
    public static final String PROPERTY_PERSISTED = "persisted";
    public static final String PROPERTY_EMPTY = "empty";
    public static final String PROPERTY_STATION_NUMBER = "stationNumber";
    public static final String PROPERTY_FISHING_OPERATION_NUMBER = "fishingOperationNumber";
    public static final String PROPERTY_STRATA = "strata";
    public static final String PROPERTY_SUB_STRATA = "subStrata";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE = "gearShootingStartLatitude";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DEGREE = "gearShootingStartLatitudeDegree";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_MINUTE = "gearShootingStartLatitudeMinute";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_DECIMAL_MINUTE = "gearShootingStartLatitudeDecimalMinute";
    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE_SECOND = "gearShootingStartLatitudeSecond";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE = "gearShootingStartLongitude";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DEGREE = "gearShootingStartLongitudeDegree";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_MINUTE = "gearShootingStartLongitudeMinute";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DECIMAL_MINUTE = "gearShootingStartLongitudeDecimalMinute";
    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE_SECOND = "gearShootingStartLongitudeSecond";
    public static final String PROPERTY_GEAR_SHOOTING_START_DATE = "gearShootingStartDate";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE = "gearShootingEndLatitude";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DEGREE = "gearShootingEndLatitudeDegree";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_MINUTE = "gearShootingEndLatitudeMinute";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_DECIMAL_MINUTE = "gearShootingEndLatitudeDecimalMinute";
    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE_SECOND = "gearShootingEndLatitudeSecond";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE = "gearShootingEndLongitude";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DEGREE = "gearShootingEndLongitudeDegree";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_MINUTE = "gearShootingEndLongitudeMinute";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DECIMAL_MINUTE = "gearShootingEndLongitudeDecimalMinute";
    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE_SECOND = "gearShootingEndLongitudeSecond";
    public static final String PROPERTY_GEAR_SHOOTING_END_DATE = "gearShootingEndDate";
    public static final String PROPERTY_FISHING_OPERATION_RECTILIGNE = "fishingOperationRectiligne";
    public static final String PROPERTY_TRAWL_DISTANCE = "trawlDistance";
    public static final String PROPERTY_MULTIRIG_AGGREGATION = "multirigAggregation";
    public static final String PROPERTY_FISHING_OPERATION_VALID = "fishingOperationValid";
    public static final String PROPERTY_LOCATION = "location";
    public static final String PROPERTY_COMMENT = "comment";
    public static final String PROPERTY_RECORDER_PERSON = "recorderPerson";
    public static final String PROPERTY_VESSEL = "vessel";
    public static final String PROPERTY_GEAR = "gear";
    public static final String PROPERTY_VALIDATION_CONTEXT = "validationContext";
    protected boolean empty;
    protected Cruise cruise;
    protected String stationNumber;
    protected Integer fishingOperationNumber;
    protected FishingOperationLocation strata;
    protected FishingOperationLocation subStrata;
    protected SexagecimalPosition gearShootingStartLatitudeAsSexagecimal;
    protected SexagecimalPosition gearShootingStartLongitudeAsSexagecimal;
    protected SexagecimalPosition gearShootingEndLatitudeAsSexagecimal;
    protected SexagecimalPosition gearShootingEndLongitudeAsSexagecimal;
    protected Float gearShootingStartLatitude;
    protected Float gearShootingStartLongitude;
    protected Date gearShootingStartDate;
    protected Float gearShootingEndLatitude;
    protected Float gearShootingEndLongitude;
    protected Date gearShootingEndDate;
    protected boolean fishingOperationRectiligne;
    protected Float trawlDistance;
    protected Boolean fishingOperationValid;
    protected FishingOperationLocation location;
    protected String comment;
    protected List<Person> recorderPerson = Lists.newArrayList();
    protected final List<Attachment> attachment = Lists.newArrayList();
    protected FishingOperation fishingOperation;
    protected String validationContext;
    protected Gear gear;
    protected Vessel vessel;
    protected String multirigAggregation;
    protected CoordinateEditorType coordinateEditorType;
    protected List<FishingOperation> existingOperations;
    protected static Binder<EditFishingOperationUIModel, FishingOperation> toBeanBinder = BinderFactory.newBinder(EditFishingOperationUIModel.class, FishingOperation.class);
    protected static Binder<FishingOperation, EditFishingOperationUIModel> fromBeanBinder = BinderFactory.newBinder(FishingOperation.class, EditFishingOperationUIModel.class);

    public EditFishingOperationUIModel() {
        super(FishingOperation.class, fromBeanBinder, toBeanBinder);
        this.gearShootingStartLatitudeAsSexagecimal = SexagecimalPosition.valueOf(this.gearShootingStartLatitude);
        this.gearShootingStartLongitudeAsSexagecimal = SexagecimalPosition.valueOf(this.gearShootingStartLongitude);
        this.gearShootingEndLatitudeAsSexagecimal = SexagecimalPosition.valueOf(this.gearShootingEndLatitude);
        this.gearShootingEndLongitudeAsSexagecimal = SexagecimalPosition.valueOf(this.gearShootingEndLongitude);
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    public FishingOperation getFishingOperation() {
        return this.fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
        this.firePropertyChange(PROPERTY_PERSISTED, null, this.isPersisted());
    }

    public boolean isPersisted() {
        return this.fishingOperation != null && !TuttiEntities.isNew(this.fishingOperation);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        Boolean oldValue = this.isEmpty();
        this.empty = empty;
        this.firePropertyChange(PROPERTY_EMPTY, oldValue, empty);
    }

    public Cruise getCruise() {
        return this.cruise;
    }

    public void setCruise(Cruise cruise) {
        this.cruise = cruise;
    }

    @Override
    public AttachementObjectTypeEnum getObjectType() {
        return AttachementObjectTypeEnum.OPERATION;
    }

    @Override
    public String getObjectId() {
        return this.getId();
    }

    @Override
    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    @Override
    public void addAllAttachment(Collection<Attachment> attachments) {
        this.attachment.addAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachment.add(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAllAttachment(Collection<Attachment> attachments) {
        this.attachment.removeAll(attachments);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    @Override
    public void removeAttachment(Attachment attachment) {
        this.attachment.remove(attachment);
        this.firePropertyChange("attachment", null, this.getAttachment());
    }

    public String getStationNumber() {
        return this.stationNumber;
    }

    public void setStationNumber(String stationNumber) {
        String oldValue = this.getStationNumber();
        this.stationNumber = stationNumber;
        this.firePropertyChange(PROPERTY_STATION_NUMBER, oldValue, stationNumber);
    }

    public Integer getFishingOperationNumber() {
        return this.fishingOperationNumber;
    }

    public void setFishingOperationNumber(Integer fishingOperationNumber) {
        Integer oldValue = this.getFishingOperationNumber();
        this.fishingOperationNumber = fishingOperationNumber;
        this.firePropertyChange(PROPERTY_FISHING_OPERATION_NUMBER, oldValue, fishingOperationNumber);
    }

    public FishingOperationLocation getStrata() {
        return this.strata;
    }

    public void setStrata(FishingOperationLocation strata) {
        FishingOperationLocation oldValue = this.getStrata();
        this.strata = strata;
        this.firePropertyChange(PROPERTY_STRATA, oldValue, strata);
    }

    public FishingOperationLocation getSubStrata() {
        return this.subStrata;
    }

    public void setSubStrata(FishingOperationLocation subStrata) {
        FishingOperationLocation oldValue = this.getSubStrata();
        this.subStrata = subStrata;
        this.firePropertyChange(PROPERTY_SUB_STRATA, oldValue, subStrata);
    }

    public Float getGearShootingStartLatitude() {
        return this.gearShootingStartLatitude;
    }

    public void setGearShootingStartLatitude(Float gearShootingStartLatitude) {
        Float oldValue = this.getGearShootingStartLatitude();
        this.gearShootingStartLatitude = gearShootingStartLatitude;
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE, oldValue, gearShootingStartLatitude);
    }

    public Integer getGearShootingStartLatitudeDegree() {
        Integer result = this.gearShootingStartLatitudeAsSexagecimal.getDegre();
        if (this.gearShootingStartLatitudeAsSexagecimal.isSign()) {
            result = result * -1;
        }
        return result;
    }

    public Integer getGearShootingStartLatitudeDecimalDegree() {
        return this.getGearShootingStartLatitudeDegree();
    }

    public void setGearShootingStartLatitudeDegree(Integer degree) {
        boolean sign;
        Integer oldValue = this.getGearShootingStartLatitudeDegree();
        boolean bl = sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        this.gearShootingStartLatitudeAsSexagecimal.setSign(sign);
        this.gearShootingStartLatitudeAsSexagecimal.setDegre(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingStartLatitudeDecimalDegree(Integer degree) {
        this.setGearShootingStartLatitudeDegree(degree);
    }

    public Integer getGearShootingStartLatitudeMinute() {
        return this.gearShootingStartLatitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingStartLatitudeMinute(Integer minute) {
        Integer oldValue = this.getGearShootingStartLatitudeMinute();
        this.gearShootingStartLatitudeAsSexagecimal.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingStartLatitudeDecimalMinute() {
        return this.gearShootingStartLatitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingStartLatitudeDecimalMinute(Float decimalMinute) {
        this.gearShootingStartLatitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingStartLatitudeSecond() {
        return this.gearShootingStartLatitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingStartLatitudeSecond(Integer second) {
        Integer oldValue = this.getGearShootingStartLatitudeSecond();
        this.gearShootingStartLatitudeAsSexagecimal.setSeconde(second);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE_SECOND, oldValue, second);
    }

    public Float getGearShootingStartLongitude() {
        return this.gearShootingStartLongitude;
    }

    public void setGearShootingStartLongitude(Float gearShootingStartLongitude) {
        Float oldValue = this.getGearShootingStartLongitude();
        this.gearShootingStartLongitude = gearShootingStartLongitude;
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE, oldValue, gearShootingStartLongitude);
    }

    public Integer getGearShootingStartLongitudeDegree() {
        Integer result = this.gearShootingStartLongitudeAsSexagecimal.getDegre();
        if (this.gearShootingStartLongitudeAsSexagecimal.isSign()) {
            result = result * -1;
        }
        return result;
    }

    public Integer getGearShootingStartLongitudeDecimalDegree() {
        return this.getGearShootingStartLongitudeDegree();
    }

    public void setGearShootingStartLongitudeDegree(Integer degree) {
        boolean sign;
        Integer oldValue = this.getGearShootingStartLongitudeDegree();
        boolean bl = sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        this.gearShootingStartLongitudeAsSexagecimal.setSign(sign);
        this.gearShootingStartLongitudeAsSexagecimal.setDegre(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingStartLongitudeDecimalDegree(Integer degree) {
        this.setGearShootingStartLongitudeDegree(degree);
    }

    public Integer getGearShootingStartLongitudeMinute() {
        return this.gearShootingStartLongitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingStartLongitudeMinute(Integer minute) {
        Integer oldValue = this.getGearShootingStartLongitudeMinute();
        this.gearShootingStartLongitudeAsSexagecimal.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingStartLongitudeDecimalMinute() {
        return this.gearShootingStartLongitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingStartLongitudeDecimalMinute(Float decimalMinute) {
        this.gearShootingStartLongitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingStartLongitudeSecond() {
        return this.gearShootingStartLongitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingStartLongitudeSecond(Integer second) {
        Integer oldValue = this.getGearShootingStartLongitudeSecond();
        this.gearShootingStartLongitudeAsSexagecimal.setSeconde(second);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE_SECOND, oldValue, second);
    }

    public Date getGearShootingStartDate() {
        return this.gearShootingStartDate;
    }

    public void setGearShootingStartDate(Date gearShootingStartDate) {
        Date oldValue = this.getGearShootingStartDate();
        if (gearShootingStartDate != null) {
            Calendar calendar = DateUtil.getDefaultCalendar((Date)gearShootingStartDate);
            calendar.set(13, 0);
            this.gearShootingStartDate = calendar.getTime();
        } else {
            this.gearShootingStartDate = null;
        }
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_START_DATE, oldValue, this.gearShootingStartDate);
    }

    public void setGearShootingStartTime(Date gearShootingStartDate) {
        Date oldValue = this.getGearShootingStartDate();
        if (oldValue != null) {
            this.setGearShootingStartDate(gearShootingStartDate);
        }
    }

    public Float getGearShootingEndLatitude() {
        return this.gearShootingEndLatitude;
    }

    public void setGearShootingEndLatitude(Float gearShootingEndLatitude) {
        Float oldValue = this.getGearShootingEndLatitude();
        this.gearShootingEndLatitude = gearShootingEndLatitude;
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE, oldValue, gearShootingEndLatitude);
    }

    public Integer getGearShootingEndLatitudeDegree() {
        Integer result = this.gearShootingEndLatitudeAsSexagecimal.getDegre();
        if (this.gearShootingEndLatitudeAsSexagecimal.isSign()) {
            result = result * -1;
        }
        return result;
    }

    public Integer getGearShootingEndLatitudeDecimalDegree() {
        return this.getGearShootingEndLatitudeDegree();
    }

    public void setGearShootingEndLatitudeDegree(Integer degree) {
        boolean sign;
        Integer oldValue = this.getGearShootingEndLatitudeDegree();
        boolean bl = sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        this.gearShootingEndLatitudeAsSexagecimal.setSign(sign);
        this.gearShootingEndLatitudeAsSexagecimal.setDegre(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingEndLatitudeDecimalDegree(Integer degree) {
        this.setGearShootingEndLatitudeDegree(degree);
    }

    public Integer getGearShootingEndLatitudeMinute() {
        return this.gearShootingEndLatitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingEndLatitudeMinute(Integer minute) {
        Integer oldValue = this.getGearShootingEndLatitudeMinute();
        this.gearShootingEndLatitudeAsSexagecimal.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingEndLatitudeDecimalMinute() {
        return this.gearShootingEndLatitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingEndLatitudeDecimalMinute(Float decimalMinute) {
        this.gearShootingEndLatitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingEndLatitudeSecond() {
        return this.gearShootingEndLatitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingEndLatitudeSecond(Integer second) {
        Integer oldValue = this.getGearShootingEndLatitudeSecond();
        this.gearShootingEndLatitudeAsSexagecimal.setSeconde(second);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE_SECOND, oldValue, second);
    }

    public Float getGearShootingEndLongitude() {
        return this.gearShootingEndLongitude;
    }

    public void setGearShootingEndLongitude(Float gearShootingEndLongitude) {
        Float oldValue = this.getGearShootingEndLongitude();
        this.gearShootingEndLongitude = gearShootingEndLongitude;
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE, oldValue, gearShootingEndLongitude);
    }

    public Integer getGearShootingEndLongitudeDegree() {
        Integer result = this.gearShootingEndLongitudeAsSexagecimal.getDegre();
        if (this.gearShootingEndLongitudeAsSexagecimal.isSign()) {
            result = result * -1;
        }
        return result;
    }

    public Integer getGearShootingEndLongitudeDecimalDegree() {
        return this.getGearShootingEndLongitudeDegree();
    }

    public void setGearShootingEndLongitudeDegree(Integer degree) {
        boolean sign;
        Integer oldValue = this.getGearShootingEndLongitudeDegree();
        boolean bl = sign = degree != null && degree < 0;
        if (degree != null) {
            degree = Math.abs(degree);
        }
        this.gearShootingEndLongitudeAsSexagecimal.setSign(sign);
        this.gearShootingEndLongitudeAsSexagecimal.setDegre(degree);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DEGREE, oldValue, degree);
    }

    public void setGearShootingEndLongitudeDecimalDegree(Integer degree) {
        this.setGearShootingEndLongitudeDegree(degree);
    }

    public Integer getGearShootingEndLongitudeMinute() {
        return this.gearShootingEndLongitudeAsSexagecimal.getMinute();
    }

    public void setGearShootingEndLongitudeMinute(Integer minute) {
        Integer oldValue = this.getGearShootingEndLongitudeMinute();
        this.gearShootingEndLongitudeAsSexagecimal.setMinute(minute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_MINUTE, oldValue, minute);
    }

    public Float getGearShootingEndLongitudeDecimalMinute() {
        return this.gearShootingEndLongitudeAsSexagecimal.getMinuteDecimale();
    }

    public void setGearShootingEndLongitudeDecimalMinute(Float decimalMinute) {
        this.gearShootingEndLongitudeAsSexagecimal.setMinuteDecimale(decimalMinute);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_DECIMAL_MINUTE, null, decimalMinute);
    }

    public Integer getGearShootingEndLongitudeSecond() {
        return this.gearShootingEndLongitudeAsSexagecimal.getSeconde();
    }

    public void setGearShootingEndLongitudeSecond(Integer second) {
        Integer oldValue = this.getGearShootingEndLongitudeSecond();
        this.gearShootingEndLongitudeAsSexagecimal.setSeconde(second);
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE_SECOND, oldValue, second);
    }

    public Date getGearShootingEndDate() {
        return this.gearShootingEndDate;
    }

    public void setGearShootingEndDate(Date gearShootingEndDate) {
        Date oldValue = this.getGearShootingEndDate();
        if (gearShootingEndDate != null) {
            Calendar calendar = DateUtil.getDefaultCalendar((Date)gearShootingEndDate);
            calendar.set(13, 0);
            this.gearShootingEndDate = calendar.getTime();
        } else {
            this.gearShootingEndDate = null;
        }
        this.firePropertyChange(PROPERTY_GEAR_SHOOTING_END_DATE, oldValue, this.gearShootingEndDate);
    }

    public void setGearShootingEndTime(Date gearShootingEndDate) {
        Date oldValue = this.getGearShootingEndDate();
        if (oldValue != null) {
            this.setGearShootingEndDate(gearShootingEndDate);
        }
    }

    public boolean isFishingOperationRectiligne() {
        return this.fishingOperationRectiligne;
    }

    public void setFishingOperationRectiligne(boolean fishingOperationRectiligne) {
        Boolean oldValue = this.isFishingOperationRectiligne();
        this.fishingOperationRectiligne = fishingOperationRectiligne;
        this.firePropertyChange(PROPERTY_FISHING_OPERATION_RECTILIGNE, oldValue, fishingOperationRectiligne);
    }

    public Float getTrawlDistance() {
        return this.trawlDistance;
    }

    public void setTrawlDistance(Float trawlDistance) {
        Float oldValue = this.getTrawlDistance();
        this.trawlDistance = trawlDistance;
        this.firePropertyChange(PROPERTY_TRAWL_DISTANCE, oldValue, trawlDistance);
    }

    public Boolean getFishingOperationValid() {
        return this.fishingOperationValid;
    }

    public void setFishingOperationValid(Boolean fishingOperationValid) {
        Boolean oldValue = this.getFishingOperationValid();
        this.fishingOperationValid = fishingOperationValid;
        this.firePropertyChange(PROPERTY_FISHING_OPERATION_VALID, oldValue, fishingOperationValid);
    }

    public FishingOperationLocation getLocation() {
        return this.location;
    }

    public void setLocation(FishingOperationLocation location) {
        FishingOperationLocation oldValue = this.getLocation();
        this.location = location;
        this.firePropertyChange(PROPERTY_LOCATION, oldValue, location);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.getComment();
        this.comment = comment;
        this.firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    public List<Person> getRecorderPerson() {
        return this.recorderPerson;
    }

    public void setRecorderPerson(List<Person> recorderPerson) {
        ArrayList oldValue = Lists.newArrayList(this.getRecorderPerson());
        this.recorderPerson = Lists.newArrayList();
        if (recorderPerson != null) {
            this.recorderPerson.addAll(recorderPerson);
        }
        this.firePropertyChange(PROPERTY_RECORDER_PERSON, oldValue, recorderPerson);
    }

    public String getValidationContext() {
        return this.validationContext;
    }

    public void setValidationContext(String validationContext) {
        String oldValue = this.getValidationContext();
        this.validationContext = validationContext;
        this.firePropertyChange(PROPERTY_VALIDATION_CONTEXT, oldValue, validationContext);
    }

    public Gear getGear() {
        return this.gear;
    }

    public void setGear(Gear gear) {
        Gear oldValue = this.getGear();
        this.gear = gear;
        this.firePropertyChange(PROPERTY_GEAR, oldValue, gear);
    }

    public Vessel getVessel() {
        return this.vessel;
    }

    public void setVessel(Vessel vessel) {
        Vessel oldValue = this.getVessel();
        this.vessel = vessel;
        this.firePropertyChange(PROPERTY_VESSEL, oldValue, vessel);
    }

    public String getMultirigAggregation() {
        return this.multirigAggregation;
    }

    public void setMultirigAggregation(String multirigAggregation) {
        String oldValue = this.getMultirigAggregation();
        this.multirigAggregation = multirigAggregation;
        this.firePropertyChange(PROPERTY_MULTIRIG_AGGREGATION, oldValue, multirigAggregation);
    }

    public CoordinateEditorType getCoordinateEditorType() {
        return this.coordinateEditorType;
    }

    public void setCoordinateEditorType(CoordinateEditorType coordinateEditorType) {
        this.coordinateEditorType = coordinateEditorType;
    }

    @Override
    protected FishingOperation newEntity() {
        return this.fishingOperation;
    }

    public boolean isDateInCruise(Date date) {
        return DateUtil.between((Date)date, (Date)this.cruise.getBeginDate(), (Date)this.cruise.getEndDate());
    }

    public boolean isValidDuration() {
        int minutes = DateUtil.getDifferenceInMinutes((Date)this.gearShootingStartDate, (Date)this.gearShootingEndDate);
        return minutes <= 45 && minutes >= 20;
    }

    public List<FishingOperation> getExistingOperations() {
        return this.existingOperations;
    }

    public void setExistingOperations(List<FishingOperation> existingOperations) {
        this.existingOperations = existingOperations;
    }

    public void convertGearShootingCoordinatesDDToDMS() {
        SexagecimalPosition position = SexagecimalPosition.valueOf(this.gearShootingStartLatitude);
        Integer degree = position.getDegre();
        if (degree != null) {
            degree = degree * (position.isSign() ? -1 : 1);
        }
        this.setGearShootingStartLatitudeDegree(degree);
        this.setGearShootingStartLatitudeMinute(position.getMinute());
        this.setGearShootingStartLatitudeSecond(position.getSeconde());
        this.setGearShootingStartLatitudeDecimalMinute(position.getMinuteDecimale());
        position = SexagecimalPosition.valueOf(this.gearShootingStartLongitude);
        degree = position.getDegre();
        if (degree != null) {
            degree = degree * (position.isSign() ? -1 : 1);
        }
        this.setGearShootingStartLongitudeDegree(degree);
        this.setGearShootingStartLongitudeMinute(position.getMinute());
        this.setGearShootingStartLongitudeSecond(position.getSeconde());
        this.setGearShootingStartLongitudeDecimalMinute(position.getMinuteDecimale());
        position = SexagecimalPosition.valueOf(this.gearShootingEndLatitude);
        degree = position.getDegre();
        if (degree != null) {
            degree = degree * (position.isSign() ? -1 : 1);
        }
        if (position.getDegre() != null) {
            // empty if block
        }
        this.setGearShootingEndLatitudeDegree(degree);
        this.setGearShootingEndLatitudeMinute(position.getMinute());
        this.setGearShootingEndLatitudeSecond(position.getSeconde());
        this.setGearShootingEndLatitudeDecimalMinute(position.getMinuteDecimale());
        position = SexagecimalPosition.valueOf(this.gearShootingEndLongitude);
        degree = position.getDegre();
        if (degree != null) {
            degree = degree * (position.isSign() ? -1 : 1);
        }
        this.setGearShootingEndLongitudeDegree(degree);
        this.setGearShootingEndLongitudeMinute(position.getMinute());
        this.setGearShootingEndLongitudeSecond(position.getSeconde());
        this.setGearShootingEndLongitudeDecimalMinute(position.getMinuteDecimale());
    }

    public void convertGearShootingCoordinatesDMSToDD() {
        Float decimalValue = this.gearShootingStartLatitudeAsSexagecimal.toDecimal();
        this.setGearShootingStartLatitude(decimalValue);
        decimalValue = this.gearShootingStartLongitudeAsSexagecimal.toDecimal();
        this.setGearShootingStartLongitude(decimalValue);
        decimalValue = this.gearShootingEndLatitudeAsSexagecimal.toDecimal();
        this.setGearShootingEndLatitude(decimalValue);
        decimalValue = this.gearShootingEndLongitudeAsSexagecimal.toDecimal();
        this.setGearShootingEndLongitude(decimalValue);
    }

    public void computeDistance() {
        if (this.coordinateEditorType != CoordinateEditorType.DD) {
            this.convertGearShootingCoordinatesDMSToDD();
        }
        if (this.gearShootingStartLatitude != null && this.gearShootingStartLongitude != null && this.gearShootingEndLatitude != null && this.gearShootingEndLongitude != null) {
            Integer distance = TuttiUIUtil.computeDistanceInMeters(this.gearShootingStartLatitude, this.gearShootingStartLongitude, this.gearShootingEndLatitude, this.gearShootingEndLongitude);
            this.setTrawlDistance(Float.valueOf(distance.floatValue()));
        }
    }
}

