/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service.referential.location.impl;

import fr.ifremer.adagio.core.dao.referential.location.LocationExtendDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationLevelId;
import fr.ifremer.adagio.core.service.referential.location.LocationService;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="locationService")
public class LocationServiceImpl
implements LocationService {
    @Resource(name="locationDao")
    private LocationExtendDao locationDao;
    @Value(value="${LocationLevelId.RECTANGLE_STATISTIQUE_MED}")
    private final Integer RECTANGLE_STATISTIQUE_MED = new Integer(-1);

    @Override
    public String getLocationLabelByLatLong(Float latitude, Float longitude) {
        if (longitude == null || latitude == null) {
            throw new IllegalArgumentException("Arguments 'latitude' and 'longitude' should not be null.");
        }
        return this.locationDao.getLocationLabelByLatLong(latitude, longitude);
    }

    @Override
    public Integer getLocationIdByLatLong(Float latitude, Float longitude) {
        String locationLabel = this.getLocationLabelByLatLong(latitude, longitude);
        if (locationLabel == null) {
            return null;
        }
        Integer locationId = this.locationDao.getLocationIdByLabelAndLocationLevel(locationLabel, new Integer[]{LocationLevelId.RECTANGLE_STATISTIQUE.getValue(), this.RECTANGLE_STATISTIQUE_MED, LocationLevelId.FAO_ZONE.getValue()});
        return locationId;
    }
}

