package fr.ifremer.tutti.ui.swing.util.attachment;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.FileEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n._;

public class AttachmentEditorUI extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_EDITABLE = "editable";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTW8jRRAtO7bjj82STZQQ2EXKQkCcxntA4pAobBywEsvLIhxQhC+0Zzpxh/b00FODJ4pA/AR+Aty5IHHjhDhw5sAF8RcQ4sAVUT1jz3jiiZwFSx7Z3a9evaqpet/+AWVfw8MLFoaWDlwUI251Dk5Pnw4uuI1vc9/WwkOlIf4UilDsQ8NJzn2EV/pdE96chDcP1chTLndnone7UPfxUnJ/yDkivJSNsH2/2Uuud0Mv0FPWRFQe69d//Vn8yvnymyJA6JG6e1TK9qKotJJSF4rCQVijTJ+xpmTuOcnQwj0nvSvm7FAy33+Xjfin8AUsd6HiMU1kCC/fvuSII4oPPYRVhsjs4chgBZPqHGHvTFviTPMR1xYGiMIKhOWPSYYVoJBWGmEdJD/fcQQl+eDY8yLuCkKV0xEbSI5wz2i3TD1WSynJmZvCSgP6i7D/X5I+UQ6XB2PqQcq3PGSuI7lGOPw/dRzFLCnv3RTeUs4lwkOlz60LmrxPUHkxb2h1Tk8ESu68x1wuTWQtIdjKEvRsraQ0OITnTX/CibZOemMiNxKC2ogJNyImssxUxYEnptkGu5WENNKcfpRmLujDlgoN+H4Sc2en0+M0V4z68AhhM6ttepONqZ0JybtsYKStZQKiwyy4ZMAIOzlqeNR9q02A+EVcS8Mcp0VvUtHArGfSxKdZ9IrJY5Yl0fBaFlCdAq5XecJDbAsunSx+1eBptUw7b+Jc2Zl5f4/M4YtZQGOGBGFjLu+B5sxA3/DIPO5nekS2ZKW2lPpGoQ9lHdAxzUV/3snep6vYw7aueZghjG7/2Vz/9Yffv29PjatGuTdyoTO+S4biaeXRqgmT+rnYtcxqNZ8wb7dPLFySaUem/CBHWG9yTeIoX2wS0WYeMX9IFOXl3378afPjX5ag2Ia6VMxpM4M/hhoONXVBSSf03nocKbozrtJzlb5FanLgOtxWNKmc/LSEOuBmGeSYXfpP3RPlTQ5DasqDnKYkyga1n/9e7333eNqYAgl94UZ42pzyR1ARrhQujzx9Yte5Ht7wfB44KrXlPKOGHKf2Jua0Hz1bc30oIJTRuBGNd+x/0b8Z3wsDE3kU1WV+dWDO5xYloWZXpdmFtiLLrVyZ6f7cdJdGmTwyzhsBZvLGu20ZbJ6E1E2eLXv9arrQqYJXFyow+DwVWft4NiUrVzNbnop5faGYSUienjn3ucX7r9O+COUe28Yxl8g9c9uduOoixqWkkrW4kpjesqXyacqqI5ePlCtshEL7WvJyhMlL34hubieASqpIdqkIDHf3HIZseyBch8xzf466YJ71WzCWtBqTQ63txQu7TS9Gi0GA/AbON4nzX7uduqeoCgAA";
    private static final Log log = LogFactory.getLog(AttachmentEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addButton;
    protected JXTitledPanel attachmentBody;
    protected JScrollPane attachmentBodyScrollPane;
    protected AttachmentEditorUI attachmentDialog = this;
    protected VBox attachments;
    protected AttachmentModelAware bean;
    protected Boolean editable;
    protected FileEditor file;
    protected JTextArea fileComment;
    protected JLabel fileCommentLabel;
    protected JLabel fileLabel;
    protected JTextField fileName;
    protected JLabel fileNameLabel;
    protected AttachmentEditorUIHandler handler;
    protected Table mainPanel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() {
        getHandler().afterInitUI();
    }
    
    public void openEditor(JComponent component) {
       handler.openEditor(component);
    }
    
    public void closeEditor() {
       handler.closeEditor();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentEditorUI(TuttiUIContext context) {
        super(context.getMainUI());
            setContextValue(context);
            AttachmentEditorUIHandler handler = new AttachmentEditorUIHandler(context, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public AttachmentEditorUI(Window param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI() {
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addAttachment();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddButton() {
        return addButton;
    }

    public JXTitledPanel getAttachmentBody() {
        return attachmentBody;
    }

    public JScrollPane getAttachmentBodyScrollPane() {
        return attachmentBodyScrollPane;
    }

    public VBox getAttachments() {
        return attachments;
    }

    public AttachmentModelAware getBean() {
        return bean;
    }

    public Boolean getEditable() {
        return editable;
    }

    public FileEditor getFile() {
        return file;
    }

    public JTextArea getFileComment() {
        return fileComment;
    }

    public JLabel getFileCommentLabel() {
        return fileCommentLabel;
    }

    public JLabel getFileLabel() {
        return fileLabel;
    }

    public JTextField getFileName() {
        return fileName;
    }

    public JLabel getFileNameLabel() {
        return fileNameLabel;
    }

    public AttachmentEditorUIHandler getHandler() {
        return handler;
    }

    public Table getMainPanel() {
        return mainPanel;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(AttachmentModelAware bean) {
        AttachmentModelAware oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentBody() {
        if (!allComponentsCreated) {
            return;
        }
        attachmentBody.add(attachmentBodyScrollPane);
    }

    protected void addChildrenToAttachmentBodyScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        attachmentBodyScrollPane.getViewport().add(mainPanel);
    }

    protected void addChildrenToAttachmentDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(attachmentBody, BorderLayout.CENTER);
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(attachments, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add($JSeparator0, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(fileLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(file, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(addButton, new GridBagConstraints(2, 2, 1, 3, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(fileNameLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(fileName, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(fileCommentLabel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add($JScrollPane0, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
        addButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addButton"));
    }

    protected void createAttachmentBody() {
        $objectMap.put("attachmentBody", attachmentBody = new JXTitledPanel());
        
        attachmentBody.setName("attachmentBody");
        attachmentBody.setTitle(_("tutti.title.attachment"));
    }

    protected void createAttachmentBodyScrollPane() {
        $objectMap.put("attachmentBodyScrollPane", attachmentBodyScrollPane = new JScrollPane());
        
        attachmentBodyScrollPane.setName("attachmentBodyScrollPane");
    }

    protected void createAttachments() {
        $objectMap.put("attachments", attachments = new VBox());
        
        attachments.setName("attachments");
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createFile() {
        $objectMap.put("file", file = new FileEditor());
        
        file.setName("file");
    }

    protected void createFileComment() {
        $objectMap.put("fileComment", fileComment = new JTextArea());
        
        fileComment.setName("fileComment");
        fileComment.setColumns(15);
        fileComment.setLineWrap(true);
        fileComment.setWrapStyleWord(true);
        fileComment.setRows(3);
    }

    protected void createFileCommentLabel() {
        $objectMap.put("fileCommentLabel", fileCommentLabel = new JLabel());
        
        fileCommentLabel.setName("fileCommentLabel");
        fileCommentLabel.setText(_("tutti.label.attachmentEditor.fileComment"));
    }

    protected void createFileLabel() {
        $objectMap.put("fileLabel", fileLabel = new JLabel());
        
        fileLabel.setName("fileLabel");
        fileLabel.setText(_("tutti.label.attachmentEditor.file"));
    }

    protected void createFileName() {
        $objectMap.put("fileName", fileName = new JTextField());
        
        fileName.setName("fileName");
        fileName.setColumns(15);
    }

    protected void createFileNameLabel() {
        $objectMap.put("fileNameLabel", fileNameLabel = new JLabel());
        
        fileNameLabel.setName("fileNameLabel");
        fileNameLabel.setText(_("tutti.label.attachmentEditor.fileName"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(AttachmentEditorUIHandler.class));
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new Table());
        
        mainPanel.setName("mainPanel");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAttachmentDialog();
        addChildrenToAttachmentBody();
        addChildrenToAttachmentBodyScrollPane();
        addChildrenToMainPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fileComment);
        
        // apply 5 property setters
        fileLabel.setLabelFor(file);
        addButton.setIcon(SwingUtil.createActionIcon("add"));
        fileNameLabel.setLabelFor(fileName);
        fileCommentLabel.setLabelFor(fileComment);
        // late initializer
        attachmentDialog.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("attachmentDialog", attachmentDialog);
        createEditable();
        createBean();
        createHandler();
        createAttachmentBody();
        createAttachmentBodyScrollPane();
        createMainPanel();
        createAttachments();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createFileLabel();
        createFile();
        createAddButton();
        createFileNameLabel();
        createFileName();
        createFileCommentLabel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFileComment();
        // inline creation of attachmentDialog
        setName("attachmentDialog");
        attachmentDialog.getContentPane().setLayout(new BorderLayout());
        setUndecorated(true);
        setAlwaysOnTop(true);
        
        $completeSetup();
    }

}