/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.CustomTab;
import fr.ifremer.tutti.ui.swing.util.TabHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import java.awt.Component;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JTabbedPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTuttiTabContainerUIHandler<M, UI extends TuttiUI<M, ?>>
extends AbstractTuttiUIHandler<M, UI> {
    private static final Log log = LogFactory.getLog(AbstractTuttiTabContainerUIHandler.class);

    protected AbstractTuttiTabContainerUIHandler(TuttiUIContext context, UI ui) {
        super(context, ui);
    }

    protected abstract JTabbedPane getTabPanel();

    protected boolean onTabChanged(int currentIndex, int newIndex) {
        boolean result = true;
        if (currentIndex != newIndex) {
            TabHandler handler = this.getTabHandler(currentIndex);
            if (handler != null) {
                result = handler.onHideTab(currentIndex, newIndex);
            }
            if ((handler = this.getTabHandler(newIndex)) != null) {
                handler.onShowTab(currentIndex, newIndex);
            }
        }
        return result;
    }

    protected TabHandler getTabHandler(int index) {
        TuttiUI tuttiTab;
        Object handler;
        Component tab;
        TabHandler tabHandler = null;
        JTabbedPane tabPanel = this.getTabPanel();
        if (index >= 0 && index < tabPanel.getTabCount() && TuttiUI.class.isInstance(tab = tabPanel.getComponentAt(index)) && TabHandler.class.isInstance(handler = (tuttiTab = (TuttiUI)((Object)tabPanel.getComponentAt(index))).getHandler())) {
            tabHandler = (TabHandler)handler;
        }
        return tabHandler;
    }

    @Override
    protected void initUI(TuttiUI ui) {
        super.initUI(ui);
        final JTabbedPane tabPanel = this.getTabPanel();
        tabPanel.setModel(new DefaultSingleSelectionModel(){

            @Override
            public void setSelectedIndex(int index) {
                int currentIndex = tabPanel.getSelectedIndex();
                boolean mustChangeTab = AbstractTuttiTabContainerUIHandler.this.onTabChanged(currentIndex, index);
                if (mustChangeTab) {
                    super.setSelectedIndex(index);
                }
            }
        });
    }

    protected void setCustomTab(int index, AbstractTuttiBeanUIModel model) {
        this.getTabPanel().setTabComponentAt(index, new CustomTab(model));
    }
}

